/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import io.fabric8.kubernetes.client.informers.SharedIndexInformer;
import io.fabric8.kubernetes.client.informers.SharedInformerFactory;
import io.fabric8.kubernetes.client.informers.cache.Lister;
import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InformerExample {
    private static Logger logger = LoggerFactory.getLogger(InformerExample.class);

    public static void main(String[] args) throws IOException, InterruptedException {
        try (DefaultKubernetesClient client = new DefaultKubernetesClient();){
            SharedInformerFactory sharedInformerFactory = client.informers();
            SharedIndexInformer podInformer = sharedInformerFactory.sharedIndexInformerFor(Pod.class, PodList.class, 900000L);
            InformerExample.log("Informer factory initialized.");
            podInformer.addEventHandler((ResourceEventHandler)new ResourceEventHandler<Pod>(){

                public void onAdd(Pod pod) {
                    System.out.printf("%s pod added\n", pod.getMetadata().getName());
                }

                public void onUpdate(Pod oldPod, Pod newPod) {
                    System.out.printf("%s pod updated\n", oldPod.getMetadata().getName());
                }

                public void onDelete(Pod pod, boolean deletedFinalStateUnknown) {
                    System.out.printf("%s pod deleted \n", pod.getMetadata().getName());
                }
            });
            InformerExample.log("Starting all registered informers");
            sharedInformerFactory.startAllRegisteredInformers();
            Pod testPod = ((PodBuilder)((PodFluent.SpecNested)((PodSpecFluent.InitContainersNested)((PodSpecFluent.InitContainersNested)((PodSpecFluent.InitContainersNested)((PodFluent.SpecNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("myapp-pod")).withLabels(Collections.singletonMap("app", "myapp-pod"))).endMetadata()).withNewSpec().addNewContainer().withName("myapp-container")).withImage("busybox:1.28")).withCommand(new String[]{"sh", "-c", "echo The app is running!; sleep 10"})).endContainer()).addNewInitContainer().withName("init-myservice")).withImage("busybox:1.28")).withCommand(new String[]{"sh", "-c", "echo inititalizing...; sleep 5"})).endInitContainer()).endSpec()).build();
            ((NonNamespaceOperation)client.pods().inNamespace("default")).create((Object[])new Pod[]{testPod});
            InformerExample.log("Pod created");
            Thread.sleep(3000L);
            Lister podLister = new Lister(podInformer.getIndexer(), "default");
            Pod myPod = (Pod)podLister.get("myapp-pod");
            InformerExample.log("PodLister has " + podLister.list().size());
            if (myPod != null) {
                System.out.printf("***** myapp-pod created %s", myPod.getMetadata().getCreationTimestamp());
            }
            TimeUnit.MINUTES.sleep(15L);
            sharedInformerFactory.stopAllRegisteredInformers();
        }
    }

    private static void log(String action, Object obj) {
        logger.info("{}: {}", (Object)action, obj);
    }

    private static void log(String action) {
        logger.info(action);
    }
}

