/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.examples;

import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamBuilder;
import io.fabric8.openshift.api.model.ImageStreamFluent;
import io.fabric8.openshift.api.model.TagReference;
import io.fabric8.openshift.api.model.TagReferenceBuilder;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageStreamExample {
    private static final Logger logger = LoggerFactory.getLogger(ImageStreamExample.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws InterruptedException {
        String namespace = "myproject";
        String master = "CLUSTER_URL";
        Config config = ((ConfigBuilder)new ConfigBuilder().withMasterUrl(master)).build();
        DefaultOpenShiftClient client = new DefaultOpenShiftClient(config);
        HashMap<String, String> annotations = new HashMap<String, String>();
        annotations.put("role", "jenkins-slave");
        annotations.put("slave-label", "jenkins-slave");
        try {
            ImageStream imageStream = ((ImageStreamBuilder)((ImageStreamFluent.SpecNested)((ImageStreamFluent.SpecNested)((ImageStreamBuilder)((ImageStreamFluent.MetadataNested)new ImageStreamBuilder().withNewMetadata().withName("slave-jenkins")).endMetadata()).withNewSpec().addToTags(0, ((TagReferenceBuilder)((TagReferenceBuilder)new TagReferenceBuilder().withName("base")).withFrom(((ObjectReferenceBuilder)((ObjectReferenceBuilder)new ObjectReferenceBuilder().withKind("DockerImage")).withName("docker.io/openshift/jenkins-slave-maven-centos7:latest")).build())).build())).addToTags(1, ((TagReferenceBuilder)((TagReferenceBuilder)((TagReferenceBuilder)new TagReferenceBuilder().withAnnotations(annotations)).withName("latest")).withFrom(((ObjectReferenceBuilder)((ObjectReferenceBuilder)new ObjectReferenceBuilder().withKind("ImageStreamTag")).withName("base")).build())).build())).endSpec()).build();
            ImageStreamExample.log("Created ImageStream", ((NonNamespaceOperation)client.imageStreams().inNamespace(namespace)).create((Object[])new ImageStream[]{imageStream}));
        }
        finally {
            ImageStreamExample.log("Tags in ImageStream are");
            ImageStreamExample.log("First Tag is " + ((TagReference)((ImageStream)((Resource)((NonNamespaceOperation)client.imageStreams().inNamespace(namespace)).withName("slave-jenkins")).get()).getSpec().getTags().get(0)).getName());
            ImageStreamExample.log("Second Tag is " + ((TagReference)((ImageStream)((Resource)((NonNamespaceOperation)client.imageStreams().inNamespace(namespace)).withName("slave-jenkins")).get()).getSpec().getTags().get(1)).getName());
            ((Resource)((NonNamespaceOperation)client.imageStreams().inNamespace(namespace)).withName("slave-jenkins")).delete();
            client.close();
        }
    }

    private static void log(String action, Object obj) {
        logger.info("{}: {}", (Object)action, obj);
    }

    private static void log(String action) {
        logger.info(action);
    }
}

