/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinition;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawCustomResourceExample {
    private static final Logger logger = LoggerFactory.getLogger(RawCustomResourceExample.class);

    public static void main(String[] args) throws IOException {
        try (DefaultKubernetesClient client = new DefaultKubernetesClient();){
            CustomResourceDefinition prometheousRuleCrd = (CustomResourceDefinition)((Resource)client.customResourceDefinitions().load(RawCustomResourceExample.class.getResourceAsStream("/prometheous-rule-crd.yml"))).get();
            client.customResourceDefinitions().create((Object[])new CustomResourceDefinition[]{prometheousRuleCrd});
            RawCustomResourceExample.log("Successfully created prometheous custom resource definition");
            CustomResourceDefinitionContext crdContext = new CustomResourceDefinitionContext.Builder().withGroup("monitoring.coreos.com").withPlural("prometheusrules").withScope("Namespaced").withVersion("v1").build();
            client.customResource(crdContext).create("myproject", RawCustomResourceExample.class.getResourceAsStream("/prometheous-rule-cr.yml"));
            RawCustomResourceExample.log("Created Custom Resource successfully too");
            Map list = client.customResource(crdContext).list("myproject");
            List items = (List)list.get("items");
            RawCustomResourceExample.log("Custom Resources :- ");
            for (Map customResource : items) {
                Map metadata = (Map)customResource.get("metadata");
                RawCustomResourceExample.log(metadata.get("name").toString());
            }
            RawCustomResourceExample.log("Deleting custom resources...");
            Map deleted = client.customResource(crdContext).delete("myproject", "prometheus-example-rules");
            ((Resource)client.customResourceDefinitions().withName("prometheusrules.monitoring.coreos.com")).delete();
        }
        catch (KubernetesClientException e) {
            e.printStackTrace();
            RawCustomResourceExample.log("Could not create resource", e.getMessage());
        }
    }

    private static void log(String action, Object obj) {
        logger.info("{}: {}", (Object)action, obj);
    }

    private static void log(String action) {
        logger.info(action);
    }
}

