/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.LoadBalancerStatusFluent;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServiceSpecFluent;
import io.fabric8.kubernetes.api.model.ServiceStatusFluent;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceExample {
    private static final Logger logger = LoggerFactory.getLogger(ServiceExample.class);

    public static void main(String[] args) {
        try (DefaultKubernetesClient client = new DefaultKubernetesClient();){
            Service service = ((ServiceBuilder)((ServiceFluent.StatusNested)((ServiceStatusFluent.LoadBalancerNested)((LoadBalancerStatusFluent.IngressNested)((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceFluent.SpecNested)((ServiceBuilder)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName("my-service")).endMetadata()).withNewSpec().withSelector(Collections.singletonMap("app", "MyApp"))).addNewPort().withName("test-port")).withProtocol("TCP")).withPort(Integer.valueOf(80))).withTargetPort(new IntOrString(Integer.valueOf(9376)))).endPort()).withType("LoadBalancer")).endSpec()).withNewStatus().withNewLoadBalancer().addNewIngress().withIp("146.148.47.155")).endIngress()).endLoadBalancer()).endStatus()).build();
            service = (Service)((NonNamespaceOperation)client.services().inNamespace(client.getNamespace())).create((Object[])new Service[]{service});
            ServiceExample.log("Created service with name ", service.getMetadata().getName());
            String serviceURL = ((ServiceResource)((NonNamespaceOperation)client.services().inNamespace(client.getNamespace())).withName(service.getMetadata().getName())).getURL("test-port");
            ServiceExample.log("Service URL", serviceURL);
        }
    }

    private static void log(String action, Object obj) {
        logger.info("{}: {}", (Object)action, obj);
    }

    private static void log(String action) {
        logger.info(action);
    }
}

