/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.dsl.ExecListenable;
import io.fabric8.kubernetes.client.dsl.ExecListener;
import io.fabric8.kubernetes.client.dsl.ExecWatch;
import io.fabric8.kubernetes.client.dsl.Execable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.TtyExecErrorChannelable;
import io.fabric8.kubernetes.client.dsl.TtyExecErrorable;
import io.fabric8.kubernetes.client.dsl.TtyExecOutputErrorable;
import okhttp3.Response;

public class ExecExample {
    public static void main(String[] args) throws InterruptedException {
        if (args.length < 1) {
            System.out.println("Usage: podName [master] [namespace]");
            return;
        }
        String podName = args[0];
        String namespace = "default";
        String master = "https://localhost:8443/";
        if (args.length > 1) {
            master = args[1];
        }
        if (args.length > 2) {
            namespace = args[2];
        }
        Config config = ((ConfigBuilder)new ConfigBuilder().withMasterUrl(master)).build();
        try (DefaultKubernetesClient client = new DefaultKubernetesClient(config);
             ExecWatch watch = (ExecWatch)((Execable)((ExecListenable)((TtyExecErrorChannelable)((TtyExecErrorable)((TtyExecOutputErrorable)((PodResource)((NonNamespaceOperation)client.pods().inNamespace(namespace)).withName(podName)).readingInput((Object)System.in)).writingOutput((Object)System.out)).writingError((Object)System.err)).withTTY()).usingListener((Object)new SimpleListener())).exec((Object[])new String[0]);){
            Thread.sleep(10000L);
        }
    }

    private static class SimpleListener
    implements ExecListener {
        private SimpleListener() {
        }

        public void onOpen(Response response) {
            System.out.println("The shell will remain open for 10 seconds.");
        }

        public void onFailure(Throwable t, Response response) {
            System.err.println("shell barfed");
        }

        public void onClose(int code, String reason) {
            System.out.println("The shell will now close.");
        }
    }
}

