/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.DoneablePod;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplaceExamples {
    private static final Logger logger = LoggerFactory.getLogger(ReplaceExamples.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String master = "https://localhost:8443/";
        if (args.length == 1) {
            master = args[0];
        }
        Config config = ((ConfigBuilder)new ConfigBuilder().withMasterUrl(master)).build();
        try (DefaultKubernetesClient client = new DefaultKubernetesClient(config);){
            try {
                ReplaceExamples.log("Create namespace:", client.namespaces().create((Object[])new Namespace[]{((NamespaceBuilder)((NamespaceFluent.MetadataNested)new NamespaceBuilder().withNewMetadata().withName("thisisatest")).endMetadata()).build()}));
                Pod createdPod = ((DoneablePod)((PodFluent.SpecNested)((PodSpecFluent.ContainersNested)((ContainerFluent.PortsNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((DoneablePod)((PodFluent.MetadataNested)((PodFluent.MetadataNested)((DoneablePod)((NonNamespaceOperation)client.pods().inNamespace("thisisatest")).createNew()).withNewMetadata().withName("testpod")).addToLabels("server", "nginx")).endMetadata()).withNewSpec().addNewContainer().withName("nginx")).withImage("nginx")).addNewPort().withContainerPort(Integer.valueOf(80))).endPort()).endContainer()).endSpec()).done();
                ReplaceExamples.log("Created testPod:", createdPod);
                Pod updatedPod = ((DoneablePod)((PodFluent.MetadataNested)((DoneablePod)((PodResource)((NonNamespaceOperation)client.pods().inNamespace("thisisatest")).withName("testpod")).edit()).editMetadata().addToLabels("server2", "nginx2")).and()).done();
                ReplaceExamples.log("Replaced testPod:", updatedPod);
            }
            catch (KubernetesClientException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                ((Resource)client.namespaces().withName("thisisatest")).delete();
            }
        }
    }

    private static void log(String action, Object obj) {
        logger.info("{}: {}", (Object)action, obj);
    }

    private static void log(String action) {
        logger.info(action);
    }
}

