/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientPodResource;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListExamples {
    private static final Logger logger = LoggerFactory.getLogger(ListExamples.class);

    public static void main(String[] args) {
        String master = "https://localhost:8443/";
        if (args.length == 1) {
            master = args[0];
        }
        Config config = ((ConfigBuilder)new ConfigBuilder().withMasterUrl(master)).build();
        try (DefaultKubernetesClient client = new DefaultKubernetesClient(config);){
            System.out.println(client.namespaces().list());
            System.out.println(((FilterWatchListDeletable)client.namespaces().withLabel("this", "works")).list());
            System.out.println(((FilterWatchListDeletable)client.pods().withLabel("this", "works")).list());
            System.out.println(((FilterWatchListDeletable)((ClientNonNamespaceOperation)client.pods().inNamespace("test")).withLabel("this", "works")).list());
            System.out.println(((ClientPodResource)((ClientNonNamespaceOperation)client.pods().inNamespace("test")).withName("testing")).get());
        }
        catch (KubernetesClientException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

