/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.internal;

import io.fabric8.kubernetes.api.model.NamedContext;
import io.fabric8.kubernetes.api.model.NamedContextBuilder;
import io.fabric8.kubernetes.api.model.NamedContextFluent;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.internal.KubeConfigUtils;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

@DisplayName(value="KubeConfigUtils.merge")
class KubeConfigUtilsMergeTest {
    private Config result;

    KubeConfigUtilsMergeTest() {
    }

    @Test
    void noContextProvidedLeavesConfigUnchanged() {
        this.result = Config.empty();
        KubeConfigUtils.merge((Config)this.result, null, (io.fabric8.kubernetes.api.model.Config[])new io.fabric8.kubernetes.api.model.Config[]{KubeConfigUtilsMergeTest.parseConfig("/internal/kube-config-utils-merge/config-empty.yaml")});
        ((ObjectAssert)Assertions.assertThat((Object)this.result).hasFieldOrPropertyWithValue("currentContext", null)).hasFieldOrPropertyWithValue("contexts", Collections.emptyList());
    }

    @Test
    void incompleteContextProvidedLeavesConfigUnchanged() {
        this.result = ((ConfigBuilder)new ConfigBuilder(Config.empty()).addToContexts(new NamedContext[]{((NamedContextBuilder)new NamedContextBuilder().withName("incomplete-context")).build()})).build();
        KubeConfigUtils.merge((Config)this.result, (String)"incomplete-context", (io.fabric8.kubernetes.api.model.Config[])new io.fabric8.kubernetes.api.model.Config[]{KubeConfigUtilsMergeTest.parseConfig("/internal/kube-config-utils-merge/config-1.yaml"), KubeConfigUtilsMergeTest.parseConfig("/internal/kube-config-utils-merge/config-2.yaml"), KubeConfigUtilsMergeTest.parseConfig("/internal/kube-config-utils-merge/config-3.yaml"), KubeConfigUtilsMergeTest.parseConfig("/internal/kube-config-utils-merge/config-4.yaml")});
        ((ObjectAssert)((ObjectAssert)((ListAssert)((ListAssert)((ObjectAssert)Assertions.assertThat((Object)this.result).hasFieldOrPropertyWithValue("currentContext", null)).extracting("contexts").asInstanceOf(InstanceOfAssertFactories.list(NamedContext.class))).filteredOn(ctx -> "incomplete-context".equals(ctx.getName()))).singleElement()).hasFieldOrPropertyWithValue("name", (Object)"incomplete-context")).hasFieldOrPropertyWithValue("context", null);
    }

    private static io.fabric8.kubernetes.api.model.Config parseConfig(String path) {
        File file = new File(Objects.requireNonNull(KubeConfigUtilsMergeTest.class.getResource(path)).getFile());
        return KubeConfigUtils.parseConfig((File)file);
    }

    @Nested
    @DisplayName(value="When merging multiple Configs with context argument, use context from ORIGINAL Config that matches context argument")
    class ContextArgumentInOriginalConfig {
        ContextArgumentInOriginalConfig() {
        }

        @BeforeEach
        void setUp() {
            KubeConfigUtilsMergeTest.this.result = ((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().addToContexts(new NamedContext[]{((NamedContextBuilder)((NamedContextFluent.ContextNested)((NamedContextFluent.ContextNested)((NamedContextBuilder)new NamedContextBuilder().withName("context-in-original-config")).withNewContext().withCluster("original-cluster")).withUser("original-user")).endContext()).build()})).withMasterUrl("https://original-cluster.example.com/")).withHttpsProxy("socks5://proxy.original-cluster.example.com")).withUsername("original-username")).withPassword("original-password")).build();
            KubeConfigUtils.merge((Config)KubeConfigUtilsMergeTest.this.result, (String)"context-in-original-config", (io.fabric8.kubernetes.api.model.Config[])new io.fabric8.kubernetes.api.model.Config[]{KubeConfigUtilsMergeTest.parseConfig("/internal/kube-config-utils-merge/config-1.yaml"), KubeConfigUtilsMergeTest.parseConfig("/internal/kube-config-utils-merge/config-2.yaml"), KubeConfigUtilsMergeTest.parseConfig("/internal/kube-config-utils-merge/config-3.yaml"), KubeConfigUtilsMergeTest.parseConfig("/internal/kube-config-utils-merge/config-4.yaml")});
        }

        @Test
        void currentContextPreservedFromOriginalConfig() {
            ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)KubeConfigUtilsMergeTest.this.result.getCurrentContext()).hasFieldOrPropertyWithValue("name", (Object)"context-in-original-config")).hasFieldOrPropertyWithValue("context.cluster", (Object)"original-cluster")).hasFieldOrPropertyWithValue("context.user", (Object)"original-user");
        }

        @Test
        void clusterInfoPreservedFromOriginalConfig() {
            ((ObjectAssert)Assertions.assertThat((Object)KubeConfigUtilsMergeTest.this.result).hasFieldOrPropertyWithValue("masterUrl", (Object)"https://original-cluster.example.com/")).hasFieldOrPropertyWithValue("httpsProxy", (Object)"socks5://proxy.original-cluster.example.com");
        }

        @Test
        void userInfoPreservedFromOriginalConfig() {
            ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)KubeConfigUtilsMergeTest.this.result).hasFieldOrPropertyWithValue("username", (Object)"original-username")).hasFieldOrPropertyWithValue("password", (Object)"original-password")).hasFieldOrPropertyWithValue("autoOAuthToken", null);
        }
    }

    @Nested
    @DisplayName(value="When merging multiple Configs with context argument, use context from FIRST Config that matches context argument")
    class MatchingDuplicateContextArgument {
        MatchingDuplicateContextArgument() {
        }

        @BeforeEach
        void setUp() {
            KubeConfigUtilsMergeTest.this.result = Config.empty();
            KubeConfigUtils.merge((Config)KubeConfigUtilsMergeTest.this.result, (String)"duplicate-context", (io.fabric8.kubernetes.api.model.Config[])new io.fabric8.kubernetes.api.model.Config[]{KubeConfigUtilsMergeTest.parseConfig("/internal/kube-config-utils-merge/config-1.yaml"), KubeConfigUtilsMergeTest.parseConfig("/internal/kube-config-utils-merge/config-2.yaml"), KubeConfigUtilsMergeTest.parseConfig("/internal/kube-config-utils-merge/config-3.yaml"), KubeConfigUtilsMergeTest.parseConfig("/internal/kube-config-utils-merge/config-4.yaml")});
        }

        @Test
        void currentContextLoadedFromFirstMatchingConfig() {
            ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)KubeConfigUtilsMergeTest.this.result.getCurrentContext()).hasFieldOrPropertyWithValue("name", (Object)"duplicate-context")).hasFieldOrPropertyWithValue("context.cluster", (Object)"duplicate-cluster")).hasFieldOrPropertyWithValue("context.user", (Object)"duplicate-user");
        }

        @Test
        void clusterInfoFromFirstMatchingConfig() {
            ((ObjectAssert)Assertions.assertThat((Object)KubeConfigUtilsMergeTest.this.result).hasFieldOrPropertyWithValue("masterUrl", (Object)"https://duplicate-cluster-in-1.example.com/")).hasFieldOrPropertyWithValue("httpsProxy", null);
        }

        @Test
        void userInfoFromFirstMatchingConfig() {
            ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)KubeConfigUtilsMergeTest.this.result).hasFieldOrPropertyWithValue("username", null)).hasFieldOrPropertyWithValue("password", null)).hasFieldOrPropertyWithValue("autoOAuthToken", (Object)"duplicate-user-1-token");
        }
    }

    @Nested
    @DisplayName(value="When merging multiple Configs with context argument, use context from Config that matches context argument")
    class MatchingContextArgument {
        MatchingContextArgument() {
        }

        @BeforeEach
        void setUp() {
            KubeConfigUtilsMergeTest.this.result = Config.empty();
            KubeConfigUtils.merge((Config)KubeConfigUtilsMergeTest.this.result, (String)"context-in-config-3", (io.fabric8.kubernetes.api.model.Config[])new io.fabric8.kubernetes.api.model.Config[]{KubeConfigUtilsMergeTest.parseConfig("/internal/kube-config-utils-merge/config-1.yaml"), KubeConfigUtilsMergeTest.parseConfig("/internal/kube-config-utils-merge/config-2.yaml"), KubeConfigUtilsMergeTest.parseConfig("/internal/kube-config-utils-merge/config-3.yaml"), KubeConfigUtilsMergeTest.parseConfig("/internal/kube-config-utils-merge/config-4.yaml")});
        }

        @Test
        void currentContextLoadedFromConfig3() {
            ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)KubeConfigUtilsMergeTest.this.result.getCurrentContext()).hasFieldOrPropertyWithValue("name", (Object)"context-in-config-3")).hasFieldOrPropertyWithValue("context.cluster", (Object)"config-3-special-cluster")).hasFieldOrPropertyWithValue("context.user", (Object)"config-3-special-user");
        }

        @Test
        void clusterInfoFromConfig3() {
            ((ObjectAssert)Assertions.assertThat((Object)KubeConfigUtilsMergeTest.this.result).hasFieldOrPropertyWithValue("masterUrl", (Object)"https://config-3-special-cluster.example.com/")).hasFieldOrPropertyWithValue("httpsProxy", (Object)"socks5://proxy.config-3-special-cluster.example.com");
        }

        @Test
        void userInfoFromConfig3() {
            ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)KubeConfigUtilsMergeTest.this.result).hasFieldOrPropertyWithValue("username", null)).hasFieldOrPropertyWithValue("password", null)).hasFieldOrPropertyWithValue("autoOAuthToken", (Object)"config-3-special-user-token");
        }
    }

    @Nested
    @DisplayName(value="When merging multiple Configs with null context, use context from first Config and read context from other")
    class NullContextArgumentScattered {
        NullContextArgumentScattered() {
        }

        @BeforeEach
        void setUp() {
            KubeConfigUtilsMergeTest.this.result = Config.empty();
            KubeConfigUtils.merge((Config)KubeConfigUtilsMergeTest.this.result, null, (io.fabric8.kubernetes.api.model.Config[])new io.fabric8.kubernetes.api.model.Config[]{KubeConfigUtilsMergeTest.parseConfig("/internal/kube-config-utils-merge/just-current-context.yaml"), KubeConfigUtilsMergeTest.parseConfig("/internal/kube-config-utils-merge/config-1.yaml"), KubeConfigUtilsMergeTest.parseConfig("/internal/kube-config-utils-merge/config-2.yaml"), KubeConfigUtilsMergeTest.parseConfig("/internal/kube-config-utils-merge/config-3.yaml"), KubeConfigUtilsMergeTest.parseConfig("/internal/kube-config-utils-merge/config-4.yaml")});
        }

        @Test
        void contextsContainsAllValidConfigContexts() {
            Assertions.assertThat((List)KubeConfigUtilsMergeTest.this.result.getContexts()).allMatch(ctx -> ctx.getContext() != null);
        }

        @Test
        void contextsContainInformationFromFile() {
            ((ListAssert)((ListAssert)((ListAssert)((ListAssert)((ListAssert)Assertions.assertThat((List)KubeConfigUtilsMergeTest.this.result.getContexts()).allMatch(ctx -> ctx.getAdditionalProperties() != null)).allMatch(ctx -> ctx.getAdditionalProperties().get("KUBERNETES_CONFIG_CONTEXT_FILE_KEY") != null)).anyMatch(ctx -> ctx.getAdditionalProperties().get("KUBERNETES_CONFIG_CLUSTER_FILE_KEY") == null)).anyMatch(ctx -> ctx.getAdditionalProperties().get("KUBERNETES_CONFIG_AUTH_INFO_FILE_KEY") != null)).anyMatch(ctx -> ctx.getAdditionalProperties().get("KUBERNETES_CONFIG_CLUSTER_FILE_KEY") == null)).anyMatch(ctx -> ctx.getAdditionalProperties().get("KUBERNETES_CONFIG_AUTH_INFO_FILE_KEY") != null);
        }

        @Test
        void currentContextContainsInformationFromUsedFiles() {
            ((MapAssert)Assertions.assertThat((Object)KubeConfigUtilsMergeTest.this.result.getCurrentContext()).extracting("additionalProperties").asInstanceOf(InstanceOfAssertFactories.map(String.class, Object.class))).containsKeys((Object[])new String[]{"KUBERNETES_CONFIG_CONTEXT_FILE_KEY", "KUBERNETES_CONFIG_CLUSTER_FILE_KEY", "KUBERNETES_CONFIG_AUTH_INFO_FILE_KEY"});
        }

        @Test
        void currentContextLoadedFromFirstConfig() {
            ((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)KubeConfigUtilsMergeTest.this.result.getCurrentContext()).hasFieldOrPropertyWithValue("name", (Object)"context-in-config-3")).hasFieldOrPropertyWithValue("context.cluster", (Object)"config-3-special-cluster")).hasFieldOrPropertyWithValue("context.namespace", (Object)"config-3-namespace")).hasFieldOrPropertyWithValue("context.user", (Object)"config-3-special-user");
        }

        @Test
        void clusterInfoFromFirstConfig() {
            ((ObjectAssert)Assertions.assertThat((Object)KubeConfigUtilsMergeTest.this.result).hasFieldOrPropertyWithValue("masterUrl", (Object)"https://config-3-special-cluster.example.com/")).hasFieldOrPropertyWithValue("httpsProxy", (Object)"socks5://proxy.config-3-special-cluster.example.com");
        }

        @Test
        void userInfoFromFirstConfig() {
            ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)KubeConfigUtilsMergeTest.this.result).hasFieldOrPropertyWithValue("username", null)).hasFieldOrPropertyWithValue("password", null)).hasFieldOrPropertyWithValue("autoOAuthToken", (Object)"config-3-special-user-token");
        }
    }

    @Nested
    @DisplayName(value="When merging multiple Configs with null context, use context from first Config")
    class NullContextArgument {
        NullContextArgument() {
        }

        @BeforeEach
        void setUp() {
            KubeConfigUtilsMergeTest.this.result = Config.empty();
            KubeConfigUtils.merge((Config)KubeConfigUtilsMergeTest.this.result, null, (io.fabric8.kubernetes.api.model.Config[])new io.fabric8.kubernetes.api.model.Config[]{KubeConfigUtilsMergeTest.parseConfig("/internal/kube-config-utils-merge/config-1.yaml"), KubeConfigUtilsMergeTest.parseConfig("/internal/kube-config-utils-merge/config-2.yaml"), KubeConfigUtilsMergeTest.parseConfig("/internal/kube-config-utils-merge/config-3.yaml"), KubeConfigUtilsMergeTest.parseConfig("/internal/kube-config-utils-merge/config-4.yaml")});
        }

        @Test
        void contextsContainsAllValidConfigContexts() {
            Assertions.assertThat((List)KubeConfigUtilsMergeTest.this.result.getContexts()).allMatch(ctx -> ctx.getContext() != null);
        }

        @Test
        void contextsContainInformationFromUsedFile() {
            ((ListAssert)((ListAssert)((ListAssert)((ListAssert)((ListAssert)Assertions.assertThat((List)KubeConfigUtilsMergeTest.this.result.getContexts()).allMatch(ctx -> ctx.getAdditionalProperties() != null)).allMatch(ctx -> ctx.getAdditionalProperties().get("KUBERNETES_CONFIG_CONTEXT_FILE_KEY") != null)).anyMatch(ctx -> ctx.getAdditionalProperties().get("KUBERNETES_CONFIG_CLUSTER_FILE_KEY") == null)).anyMatch(ctx -> ctx.getAdditionalProperties().get("KUBERNETES_CONFIG_AUTH_INFO_FILE_KEY") != null)).anyMatch(ctx -> ctx.getAdditionalProperties().get("KUBERNETES_CONFIG_CLUSTER_FILE_KEY") == null)).anyMatch(ctx -> ctx.getAdditionalProperties().get("KUBERNETES_CONFIG_AUTH_INFO_FILE_KEY") != null);
        }

        @Test
        void currentContextContainsInformationFromUsedFiles() {
            ((MapAssert)Assertions.assertThat((Object)KubeConfigUtilsMergeTest.this.result.getCurrentContext()).extracting("additionalProperties").asInstanceOf(InstanceOfAssertFactories.map(String.class, Object.class))).containsKeys((Object[])new String[]{"KUBERNETES_CONFIG_CONTEXT_FILE_KEY", "KUBERNETES_CONFIG_CLUSTER_FILE_KEY", "KUBERNETES_CONFIG_AUTH_INFO_FILE_KEY"});
        }

        @Test
        void currentContextLoadedFromFirstConfig() {
            ((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)KubeConfigUtilsMergeTest.this.result.getCurrentContext()).hasFieldOrPropertyWithValue("name", (Object)"context-in-all-configs")).hasFieldOrPropertyWithValue("context.cluster", (Object)"config-1-cluster")).hasFieldOrPropertyWithValue("context.namespace", (Object)"config-1-namespace")).hasFieldOrPropertyWithValue("context.user", (Object)"config-1-user");
        }

        @Test
        void clusterInfoFromFirstConfig() {
            ((ObjectAssert)Assertions.assertThat((Object)KubeConfigUtilsMergeTest.this.result).hasFieldOrPropertyWithValue("masterUrl", (Object)"https://config-1.example.com/")).hasFieldOrPropertyWithValue("httpsProxy", (Object)"socks5://proxy.config-1.example.com");
        }

        @Test
        void userInfoFromFirstConfig() {
            ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)KubeConfigUtilsMergeTest.this.result).hasFieldOrPropertyWithValue("username", (Object)"config-1-user-username")).hasFieldOrPropertyWithValue("password", (Object)"config-1-user-pa33word")).hasFieldOrPropertyWithValue("autoOAuthToken", (Object)"config-1-user-token");
        }
    }
}

