/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.extended.leaderelection.resourcelock;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.coordination.v1.Lease;
import io.fabric8.kubernetes.api.model.coordination.v1.LeaseBuilder;
import io.fabric8.kubernetes.api.model.coordination.v1.LeaseFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NamespaceableResource;
import io.fabric8.kubernetes.client.dsl.base.PatchContext;
import io.fabric8.kubernetes.client.extended.leaderelection.resourcelock.LeaderElectionRecord;
import io.fabric8.kubernetes.client.extended.leaderelection.resourcelock.LeaseLock;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

class LeaseLockTest {
    private KubernetesClient kc;

    LeaseLockTest() {
    }

    @BeforeEach
    void setUp() {
        this.kc = (KubernetesClient)Mockito.mock(KubernetesClient.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    }

    @Test
    void missingNamespaceShouldThrowException() {
        Executable newInstance = () -> new LeaseLock(null, "name", "1337");
        Assertions.assertThrows(NullPointerException.class, (Executable)newInstance);
    }

    @Test
    void missingNameShouldThrowException() {
        Executable newInstance = () -> new LeaseLock("namespace", null, "1337");
        Assertions.assertThrows(NullPointerException.class, (Executable)newInstance);
    }

    @Test
    void missingIdentityShouldThrowException() {
        Executable newInstance = () -> new LeaseLock("namespace", "name", null);
        Assertions.assertThrows(NullPointerException.class, (Executable)newInstance);
    }

    @Test
    void getWithExistingLeaseShouldReturnLeaderElectionRecord() {
        Lease lease = ((LeaseBuilder)((LeaseFluent.SpecNested)((LeaseFluent.SpecNested)((LeaseFluent.SpecNested)((LeaseFluent.SpecNested)((LeaseFluent.SpecNested)new LeaseBuilder().withNewSpec().withHolderIdentity("1337")).withLeaseDurationSeconds(Integer.valueOf(15))).withAcquireTime(ZonedDateTime.of(2015, 10, 21, 4, 29, 0, 0, ZoneId.of("UTC")))).withRenewTime(ZonedDateTime.of(2015, 10, 21, 7, 28, 0, 0, ZoneId.of("UTC")))).withLeaseTransitions(Integer.valueOf(0))).endSpec()).build();
        lease.setMetadata(((ObjectMetaBuilder)new ObjectMetaBuilder().withResourceVersion("313373")).build());
        LeaseLock lock = new LeaseLock("namespace", "name", "1337");
        LeaderElectionRecord result = lock.toRecord(lease);
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((Object)"1337", (Object)result.getHolderIdentity());
        Assertions.assertEquals((long)15L, (long)result.getLeaseDuration().getSeconds());
        Assertions.assertEquals((Object)ZonedDateTime.of(2015, 10, 21, 4, 29, 0, 0, ZoneId.of("UTC")), (Object)result.getAcquireTime());
    }

    @Test
    void createWithValidLeaderElectionRecordShouldSendPostRequest() throws Exception {
        LeaderElectionRecord record = new LeaderElectionRecord("1", Duration.ofSeconds(1L), ZonedDateTime.now(), ZonedDateTime.now(), 0);
        LeaseLock lock = new LeaseLock("namespace", "name", "1337");
        lock.create(this.kc, record);
        ((NamespaceableResource)Mockito.verify((Object)this.kc.resource((HasMetadata)((Lease)ArgumentMatchers.any(Lease.class))))).create();
    }

    @Test
    void updateWithValidLeaderElectionRecordShouldSendPatchRequest() throws Exception {
        LeaderElectionRecord record = new LeaderElectionRecord("1337", Duration.ofSeconds(1L), ZonedDateTime.now(), ZonedDateTime.now(), 0);
        LeaseLock lock = new LeaseLock("namespace", "name", "1337");
        Lease lease = lock.toResource(record, lock.getObjectMeta("313373"));
        lock.setResource((HasMetadata)lease);
        lock.update(this.kc, record.toBuilder().leaseDuration(Duration.ofSeconds(2L)).build());
        ((NamespaceableResource)Mockito.verify((Object)this.kc.resource((HasMetadata)((Lease)Mockito.any(Lease.class))))).patch((PatchContext)ArgumentMatchers.any(PatchContext.class));
    }

    @Test
    void identityShouldReturnProvidedIdentity() {
        LeaseLock leaseLock = new LeaseLock("namespace", "name", "1337");
        String identity = leaseLock.identity();
        Assertions.assertEquals((Object)"1337", (Object)identity);
    }

    @Test
    void describeShouldReturnAnIdentifiableDescription() {
        LeaseLock leaseLock = new LeaseLock("namespace", "name", "1337");
        String description = leaseLock.describe();
        Assertions.assertEquals((Object)"LeaseLock: namespace - name (1337)", (Object)description);
    }
}

