/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.utils.Utils;
import java.net.URL;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

class ConfigSourcePrecedenceTest {
    ConfigSourcePrecedenceTest() {
    }

    @Nested
    @DisplayName(value="With Provided System Properties")
    class SystemPropertiesSource {
        SystemPropertiesSource() {
        }

        @BeforeEach
        void setUp() {
            System.setProperty("kubernetes.master", "https://property-configuration-override:8443");
            System.setProperty("kubernetes.namespace", "namespace-set-via-properties");
            System.setProperty("kubernetes.auth.token", "token-set-via-properties");
        }

        @Test
        @DisplayName(value="then read from System properties")
        void whenNoOtherSourceProvided_thenUseSystemProperties() {
            ((ObjectAssert)((ObjectAssert)AssertionsForClassTypes.assertThat((Object)new ConfigBuilder().build()).hasFieldOrPropertyWithValue("masterUrl", (Object)"https://property-configuration-override:8443/")).hasFieldOrPropertyWithValue("namespace", (Object)"namespace-set-via-properties")).hasFieldOrPropertyWithValue("autoOAuthToken", (Object)"token-set-via-properties");
        }

        @Test
        @DisplayName(value="And User configuration via builder, then User Configuration via builder takes precedence")
        void whenUserConfigurationOverridesSomeFields_thenUserConfigurationGivenPrecedence() {
            Config config = ((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withMasterUrl("https://user-configuration-override:8443")).withNamespace("namespace-overridden-by-user")).build();
            ((ObjectAssert)((ObjectAssert)AssertionsForClassTypes.assertThat((Object)config).hasFieldOrPropertyWithValue("masterUrl", (Object)"https://user-configuration-override:8443/")).hasFieldOrPropertyWithValue("namespace", (Object)"namespace-overridden-by-user")).hasFieldOrPropertyWithValue("autoOAuthToken", (Object)"token-set-via-properties");
        }

        @AfterEach
        void tearDown() {
            System.clearProperty("kubernetes.master");
            System.clearProperty("kubernetes.namespace");
            System.clearProperty("kubernetes.auth.token");
        }
    }

    @Nested
    @DisplayName(value="With ServiceAccount mounted")
    class InsideKubernetesCluster {
        InsideKubernetesCluster() {
        }

        @BeforeEach
        void setUp() {
            System.setProperty("kubeconfig", "/dev/null");
            System.setProperty("kubernetes.auth.serviceAccount.token", Utils.filePath((URL)ConfigSourcePrecedenceTest.class.getResource("/config-source-precedence/serviceaccount/token")));
            System.setProperty("kubenamespace", Utils.filePath((URL)ConfigSourcePrecedenceTest.class.getResource("/config-source-precedence/serviceaccount/namespace")));
        }

        @Test
        @DisplayName(value="then use ServiceAccount attributes in Config")
        void whenNoOtherSourceProvided_thenUseServiceAccount() {
            Config config = new ConfigBuilder().build();
            ((ObjectAssert)AssertionsForClassTypes.assertThat((Object)config).hasFieldOrPropertyWithValue("namespace", (Object)"namespace-from-mounted-serviceaccount")).extracting(Config::getAutoOAuthToken).asString().contains(new CharSequence[]{"token-from-mounted-serviceaccount"});
        }

        @Test
        @DisplayName(value="And User configuration via builder, then User Configuration takes precedence")
        void whenUserConfigurationOverridesSomeFields_thenUserConfigurationGivenPrecedence() {
            Config config = ((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withMasterUrl("https://user-configuration-override:8443")).withNamespace("namespace-from-user")).build();
            ((ObjectAssert)((ObjectAssert)AssertionsForClassTypes.assertThat((Object)config).hasFieldOrPropertyWithValue("masterUrl", (Object)"https://user-configuration-override:8443/")).hasFieldOrPropertyWithValue("namespace", (Object)"namespace-from-user")).extracting(Config::getAutoOAuthToken).asString().contains(new CharSequence[]{"token-from-mounted-serviceaccount"});
        }

        @Test
        @DisplayName(value="And System Properties configured, then System Properties takes precedence")
        void whenSystemPropertiesUsedForSomeFields_thenSystemPropertiesGivenPrecedence() {
            try {
                System.setProperty("kubernetes.master", "https://properties-configuration-override:8443");
                System.setProperty("kubernetes.auth.token", "token-from-properties");
                Config config = new ConfigBuilder().build();
                ((ObjectAssert)((ObjectAssert)AssertionsForClassTypes.assertThat((Object)config).hasFieldOrPropertyWithValue("masterUrl", (Object)"https://properties-configuration-override:8443/")).hasFieldOrPropertyWithValue("autoOAuthToken", (Object)"token-from-properties")).hasFieldOrPropertyWithValue("namespace", (Object)"namespace-from-mounted-serviceaccount");
            }
            finally {
                System.clearProperty("kubernetes.master");
                System.clearProperty("kubernetes.namespace");
                System.clearProperty("kubernetes.auth.token");
            }
        }

        @AfterEach
        void tearDown() {
            System.clearProperty("kubernetes.auth.serviceAccount.token");
            System.clearProperty("kubenamespace");
            System.clearProperty("kubeconfig");
        }
    }

    @Nested
    @DisplayName(value="With provided kubeconfig property")
    class KubeConfigSource {
        KubeConfigSource() {
        }

        @BeforeEach
        void setUp() {
            System.setProperty("kubeconfig", Utils.filePath((URL)ConfigSourcePrecedenceTest.class.getResource("/config-source-precedence/kube-config")));
        }

        @Test
        @DisplayName(value="then use kubeconfig attributes in Config")
        void whenNoOtherSourceProvided_thenUseKubeConfig() {
            Config config = new ConfigBuilder().build();
            ((ObjectAssert)((ObjectAssert)AssertionsForClassTypes.assertThat((Object)config).hasFieldOrPropertyWithValue("masterUrl", (Object)"https://172.28.128.4:8443/")).hasFieldOrPropertyWithValue("namespace", (Object)"namespace-from-kubeconfig")).hasFieldOrPropertyWithValue("autoOAuthToken", (Object)"token-from-kubeconfig");
        }

        @Test
        @DisplayName(value="And User configuration via builder, then User Configuration via builder takes precedence")
        void whenUserConfigurationOverridesSomeFields_thenUserConfigurationGivenPrecedence() {
            Config config = ((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withMasterUrl("https://user-configuration-override:8443")).withNamespace("namespace-from-user")).build();
            ((ObjectAssert)((ObjectAssert)AssertionsForClassTypes.assertThat((Object)config).hasFieldOrPropertyWithValue("masterUrl", (Object)"https://user-configuration-override:8443/")).hasFieldOrPropertyWithValue("namespace", (Object)"namespace-from-user")).hasFieldOrPropertyWithValue("autoOAuthToken", (Object)"token-from-kubeconfig");
        }

        @Test
        @DisplayName(value="And System Properties configured, then System Properties take precedence")
        void whenSystemPropertiesUsedForSomeFields_thenSystemPropertiesGivenPrecedence() {
            try {
                System.setProperty("kubernetes.master", "https://user-configuration-override:8443");
                System.setProperty("kubernetes.auth.token", "token-overridden");
                Config config = new ConfigBuilder().build();
                ((ObjectAssert)((ObjectAssert)AssertionsForClassTypes.assertThat((Object)config).hasFieldOrPropertyWithValue("masterUrl", (Object)"https://user-configuration-override:8443/")).hasFieldOrPropertyWithValue("namespace", (Object)"namespace-from-kubeconfig")).hasFieldOrPropertyWithValue("autoOAuthToken", (Object)"token-overridden");
            }
            finally {
                System.clearProperty("kubernetes.master");
                System.clearProperty("kubernetes.namespace");
                System.clearProperty("kubernetes.auth.token");
            }
        }

        @Test
        @DisplayName(value="And Service Account mounted, then kubeconfig takes precedence")
        void whenServiceAccountPropertyConfigured_thenDoNotUseServiceAccount() {
            try {
                System.setProperty("kubernetes.auth.serviceAccount.token", Utils.filePath((URL)ConfigSourcePrecedenceTest.class.getResource("/config-source-precedence/serviceaccount/token")));
                System.setProperty("kubenamespace", Utils.filePath((URL)ConfigSourcePrecedenceTest.class.getResource("/config-source-precedence/serviceaccount/namespace")));
                Config config = new ConfigBuilder().build();
                ((ObjectAssert)AssertionsForClassTypes.assertThat((Object)config).hasFieldOrPropertyWithValue("namespace", (Object)"namespace-from-kubeconfig")).hasFieldOrPropertyWithValue("autoOAuthToken", (Object)"token-from-kubeconfig");
            }
            finally {
                System.clearProperty("kubernetes.auth.serviceAccount.token");
                System.clearProperty("kubenamespace");
            }
        }
    }
}

