/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.model.ConfigFluent;
import io.fabric8.kubernetes.api.model.NamedAuthInfoFluent;
import io.fabric8.kubernetes.api.model.NamedClusterFluent;
import io.fabric8.kubernetes.api.model.NamedContextFluent;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.utils.Serialization;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class ConfigRefreshTest {
    @TempDir
    private Path tempDir;
    private Path kubeConfigFile;
    private io.fabric8.kubernetes.api.model.Config kubeConfigOriginal;

    ConfigRefreshTest() {
    }

    @BeforeEach
    void setUp() throws IOException {
        this.kubeConfigFile = this.tempDir.resolve("kubeconfig");
        this.kubeConfigOriginal = ((io.fabric8.kubernetes.api.model.ConfigBuilder)((io.fabric8.kubernetes.api.model.ConfigBuilder)((ConfigFluent.ContextsNested)((NamedContextFluent.ContextNested)((NamedContextFluent.ContextNested)((ConfigFluent.ContextsNested)((io.fabric8.kubernetes.api.model.ConfigBuilder)((ConfigFluent.UsersNested)((NamedAuthInfoFluent.UserNested)((ConfigFluent.UsersNested)((io.fabric8.kubernetes.api.model.ConfigBuilder)((ConfigFluent.ClustersNested)((NamedClusterFluent.ClusterNested)((ConfigFluent.ClustersNested)new io.fabric8.kubernetes.api.model.ConfigBuilder().addNewCluster().withName("the-cluster")).withNewCluster().withServer("https://the-cluster:8443")).endCluster()).endCluster()).addNewUser().withName("the-user")).withNewUser().withToken("the-token")).endUser()).endUser()).addNewContext().withName("the-context")).withNewContext().withCluster("the-cluster")).withUser("the-user")).endContext()).endContext()).withCurrentContext("the-context")).build();
        Files.writeString(this.kubeConfigFile, (CharSequence)Serialization.asYaml((Object)this.kubeConfigOriginal), StandardOpenOption.CREATE);
    }

    @Test
    @DisplayName(value="When oauthToken manually provided by user, then don't refresh (returns same instance)")
    void oauthTokenProvidedByUser() {
        Config config = ((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withAutoConfigure()).withOauthToken("manually-provided")).build();
        Config result = config.refresh();
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)result).isSameAs((Object)config)).hasFieldOrPropertyWithValue("autoConfigure", (Object)true)).hasFieldOrPropertyWithValue("oauthToken", (Object)"manually-provided");
    }

    @Test
    @DisplayName(value="When manually crafted Config, then don't refresh (returns same instance)")
    void manualConfig() {
        Config config = ((ConfigBuilder)new ConfigBuilder().withAutoConfigure(false)).build();
        Config result = config.refresh();
        ((ObjectAssert)Assertions.assertThat((Object)result).isSameAs((Object)config)).hasFieldOrPropertyWithValue("autoConfigure", (Object)false);
    }

    @Test
    @DisplayName(value="When autoconfigure enabled (from properties), then refresh (returns new instance)")
    void autoConfiguredConfigFromProperties() {
        try {
            System.setProperty("kubernetes.master", "https://test.example.com/");
            Config config = new ConfigBuilder().build();
            System.setProperty("kubernetes.master", "https://test-updated.example.com/");
            Config result = config.refresh();
            ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)result).isNotSameAs((Object)config)).hasFieldOrPropertyWithValue("autoConfigure", (Object)true)).hasFieldOrPropertyWithValue("masterUrl", (Object)"https://test-updated.example.com/");
        }
        finally {
            System.clearProperty("kubernetes.master");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DisplayName(value="When autoconfigure enabled (from files), then refresh (returns new instance)")
    void autoConfiguredConfigFromFiles() throws IOException {
        try {
            Path kubeConfigUserFile = this.tempDir.resolve("kubeconfig-user");
            io.fabric8.kubernetes.api.model.Config kubeConfigUser = ((io.fabric8.kubernetes.api.model.ConfigBuilder)new io.fabric8.kubernetes.api.model.ConfigBuilder().addAllToUsers((Collection)this.kubeConfigOriginal.getUsers())).build();
            this.kubeConfigOriginal.getUsers().clear();
            Files.writeString(this.kubeConfigFile, (CharSequence)Serialization.asYaml((Object)this.kubeConfigOriginal), StandardOpenOption.TRUNCATE_EXISTING);
            Files.writeString(kubeConfigUserFile, (CharSequence)Serialization.asYaml((Object)kubeConfigUser), StandardOpenOption.CREATE);
            System.setProperty("kubeconfig", this.kubeConfigFile.toFile().getAbsolutePath() + File.pathSeparator + kubeConfigUserFile.toFile().getAbsolutePath());
            Config config = new ConfigBuilder().build();
            io.fabric8.kubernetes.api.model.Config kubeConfigUserUpdated = ((io.fabric8.kubernetes.api.model.ConfigBuilder)((ConfigFluent.UsersNested)((NamedAuthInfoFluent.UserNested)new io.fabric8.kubernetes.api.model.ConfigBuilder(kubeConfigUser).editFirstUser().editUser().withToken("the-token-updated")).endUser()).endUser()).build();
            Files.writeString(kubeConfigUserFile, (CharSequence)Serialization.asYaml((Object)kubeConfigUserUpdated), StandardOpenOption.CREATE);
            Config result = config.refresh();
            ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)result).isNotSameAs((Object)config)).hasFieldOrPropertyWithValue("autoConfigure", (Object)true)).hasFieldOrPropertyWithValue("autoOAuthToken", (Object)"the-token-updated");
        }
        finally {
            System.clearProperty("kubeconfig");
        }
    }

    @Test
    @DisplayName(value="When config from file, then refresh (returns new instance)")
    void configFromFile() throws IOException {
        Config config = Config.fromKubeconfig((File)this.kubeConfigFile.toFile());
        io.fabric8.kubernetes.api.model.Config kubeConfigUpdated = ((io.fabric8.kubernetes.api.model.ConfigBuilder)((ConfigFluent.UsersNested)((NamedAuthInfoFluent.UserNested)new io.fabric8.kubernetes.api.model.ConfigBuilder(this.kubeConfigOriginal).editFirstUser().editUser().withToken("the-token-updated")).endUser()).endUser()).build();
        Files.writeString(this.kubeConfigFile, (CharSequence)Serialization.asYaml((Object)kubeConfigUpdated), StandardOpenOption.CREATE);
        Config result = config.refresh();
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)result).isNotSameAs((Object)config)).hasFieldOrPropertyWithValue("autoConfigure", (Object)false)).hasFieldOrPropertyWithValue("masterUrl", (Object)"https://the-cluster:8443/")).hasFieldOrPropertyWithValue("autoOAuthToken", (Object)"the-token-updated");
    }

    @Test
    @DisplayName(value="When config from file deleted, then don't refresh (returns same instance)")
    void configFromFileEmptied() throws IOException {
        Config config = Config.fromKubeconfig((File)this.kubeConfigFile.toFile());
        Files.delete(this.kubeConfigFile);
        Config result = config.refresh();
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)result).isSameAs((Object)config)).hasFieldOrPropertyWithValue("autoConfigure", (Object)false)).hasFieldOrPropertyWithValue("masterUrl", (Object)"https://the-cluster:8443/")).hasFieldOrPropertyWithValue("autoOAuthToken", (Object)"the-token");
    }
}

