/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class ConfigAutoConfigureTest {
    @TempDir
    private Path tempDir;

    ConfigAutoConfigureTest() {
    }

    @AfterEach
    void tearDown() {
        System.clearProperty("kubeconfig");
    }

    private static File resolveFile(String path) {
        return new File(Objects.requireNonNull(ConfigAutoConfigureTest.class.getResource(path)).getFile());
    }

    @Nested
    class FromKubeconfig {
        FromKubeconfig() {
        }

        @Test
        void withNoKubeConfigFiles() {
            System.setProperty("kubeconfig", "/dev/null");
            Config result = ((ConfigBuilder)new ConfigBuilder().withAutoConfigure()).build();
            ((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)result).hasFieldOrPropertyWithValue("autoConfigure", (Object)true)).returns(null, Config::getFile)).returns(null, Config::getFileWithCluster)).returns(null, Config::getFileWithAuthInfo);
        }

        @Test
        void withNonExistentConfigFile() {
            System.setProperty("kubeconfig", ConfigAutoConfigureTest.this.tempDir.resolve("non-existent").toFile().getAbsolutePath());
            Config result = ((ConfigBuilder)new ConfigBuilder().withAutoConfigure()).build();
            ((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)result).hasFieldOrPropertyWithValue("autoConfigure", (Object)true)).returns(null, Config::getFile)).returns(null, Config::getFileWithCluster)).returns(null, Config::getFileWithAuthInfo);
        }

        @Test
        void withEmptyConfigFile() throws IOException {
            Path emptyFile = Files.createFile(ConfigAutoConfigureTest.this.tempDir.resolve("empty"), new FileAttribute[0]);
            System.setProperty("kubeconfig", emptyFile.toFile().getAbsolutePath());
            Config result = ((ConfigBuilder)new ConfigBuilder().withAutoConfigure()).build();
            ((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)result).hasFieldOrPropertyWithValue("autoConfigure", (Object)true)).returns(null, Config::getFile)).returns(null, Config::getFileWithCluster)).returns(null, Config::getFileWithAuthInfo);
        }

        @Test
        void withSingleConfigFile() {
            System.setProperty("kubeconfig", ConfigAutoConfigureTest.resolveFile("/config-auto-configure/config-2.yaml").getAbsolutePath());
            Config result = ((ConfigBuilder)new ConfigBuilder().withAutoConfigure()).build();
            ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)result).hasFieldOrPropertyWithValue("autoConfigure", (Object)true)).returns((Object)ConfigAutoConfigureTest.resolveFile("/config-auto-configure/config-2.yaml"), Config::getFile)).returns((Object)ConfigAutoConfigureTest.resolveFile("/config-auto-configure/config-2.yaml"), Config::getFileWithCluster)).returns((Object)ConfigAutoConfigureTest.resolveFile("/config-auto-configure/config-2.yaml"), Config::getFileWithAuthInfo)).hasFieldOrPropertyWithValue("masterUrl", (Object)"https://config-2.example.com/")).hasFieldOrPropertyWithValue("currentContext.name", (Object)"context-in-all-configs");
        }

        @Test
        void withMultipleConfigFiles() {
            System.setProperty("kubeconfig", ConfigAutoConfigureTest.resolveFile("/config-auto-configure/config-1.yaml").getAbsolutePath() + File.pathSeparator + ConfigAutoConfigureTest.resolveFile("/config-auto-configure/config-2.yaml").getAbsolutePath() + File.pathSeparator + ConfigAutoConfigureTest.resolveFile("/config-auto-configure/config-3.yaml").getAbsolutePath() + File.pathSeparator);
            Config result = ((ConfigBuilder)new ConfigBuilder().withAutoConfigure()).build();
            ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)result).hasFieldOrPropertyWithValue("autoConfigure", (Object)true)).returns((Object)ConfigAutoConfigureTest.resolveFile("/config-auto-configure/config-1.yaml"), Config::getFile)).returns((Object)ConfigAutoConfigureTest.resolveFile("/config-auto-configure/config-1.yaml"), Config::getFileWithCluster)).returns((Object)ConfigAutoConfigureTest.resolveFile("/config-auto-configure/config-1.yaml"), Config::getFileWithAuthInfo)).hasFieldOrPropertyWithValue("masterUrl", (Object)"https://config-1.example.com/")).hasFieldOrPropertyWithValue("currentContext.name", (Object)"context-in-all-configs");
        }

        @Test
        void withMultipleConfigFilesAndContext() {
            System.setProperty("kubeconfig", ConfigAutoConfigureTest.resolveFile("/config-auto-configure/just-current-context.yaml").getAbsolutePath() + File.pathSeparator + ConfigAutoConfigureTest.resolveFile("/config-auto-configure/config-1.yaml").getAbsolutePath() + File.pathSeparator + ConfigAutoConfigureTest.resolveFile("/config-auto-configure/config-2.yaml").getAbsolutePath() + File.pathSeparator + ConfigAutoConfigureTest.resolveFile("/config-auto-configure/config-3.yaml").getAbsolutePath() + File.pathSeparator);
            Config result = ((ConfigBuilder)new ConfigBuilder().withAutoConfigure()).build();
            ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)result).hasFieldOrPropertyWithValue("autoConfigure", (Object)true)).returns((Object)ConfigAutoConfigureTest.resolveFile("/config-auto-configure/config-3.yaml"), Config::getFile)).returns((Object)ConfigAutoConfigureTest.resolveFile("/config-auto-configure/config-3.yaml"), Config::getFileWithCluster)).returns((Object)ConfigAutoConfigureTest.resolveFile("/config-auto-configure/config-3.yaml"), Config::getFileWithAuthInfo)).hasFieldOrPropertyWithValue("masterUrl", (Object)"https://config-3-special-cluster.example.com/")).hasFieldOrPropertyWithValue("currentContext.name", (Object)"context-in-config-3");
        }

        @Test
        void withMultipleConfigFilesAndScattered() {
            System.setProperty("kubeconfig", ConfigAutoConfigureTest.resolveFile("/config-auto-configure/scattered.yaml").getAbsolutePath() + File.pathSeparator + ConfigAutoConfigureTest.resolveFile("/config-auto-configure/scattered-context.yaml").getAbsolutePath() + File.pathSeparator + ConfigAutoConfigureTest.resolveFile("/config-auto-configure/scattered-cluster.yaml").getAbsolutePath() + File.pathSeparator + ConfigAutoConfigureTest.resolveFile("/config-auto-configure/scattered-user.yaml").getAbsolutePath() + File.pathSeparator);
            Config result = ((ConfigBuilder)new ConfigBuilder().withAutoConfigure()).build();
            ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)result).hasFieldOrPropertyWithValue("autoConfigure", (Object)true)).returns((Object)ConfigAutoConfigureTest.resolveFile("/config-auto-configure/scattered-context.yaml"), Config::getFile)).returns((Object)ConfigAutoConfigureTest.resolveFile("/config-auto-configure/scattered-cluster.yaml"), Config::getFileWithCluster)).returns((Object)ConfigAutoConfigureTest.resolveFile("/config-auto-configure/scattered-user.yaml"), Config::getFileWithAuthInfo)).hasFieldOrPropertyWithValue("masterUrl", (Object)"https://scattered-cluster.example.com/")).hasFieldOrPropertyWithValue("currentContext.name", (Object)"scattered-context");
        }
    }
}

