package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ConfigBuilder extends ConfigFluent<ConfigBuilder> implements VisitableBuilder<Config,ConfigBuilder>{
  public ConfigBuilder() {
    this(new Config());
  }
  
  public ConfigBuilder(ConfigFluent<?> fluent) {
    this(fluent, new Config());
  }
  
  public ConfigBuilder(ConfigFluent<?> fluent,Config instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ConfigBuilder(Config instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ConfigFluent<?> fluent;
  
  public Config build() {
    Config buildable = new Config(fluent.getMasterUrl(),fluent.getApiVersion(),fluent.getNamespace(),fluent.isTrustCerts(),fluent.isDisableHostnameVerification(),fluent.getCaCertFile(),fluent.getCaCertData(),fluent.getClientCertFile(),fluent.getClientCertData(),fluent.getClientKeyFile(),fluent.getClientKeyData(),fluent.getClientKeyAlgo(),fluent.getClientKeyPassphrase(),fluent.getUsername(),fluent.getPassword(),fluent.getOauthToken(),fluent.getAutoOAuthToken(),fluent.getWatchReconnectInterval(),fluent.getWatchReconnectLimit(),fluent.getConnectionTimeout(),fluent.getRequestTimeout(),fluent.getScaleTimeout(),fluent.getLoggingInterval(),fluent.getMaxConcurrentRequests(),fluent.getMaxConcurrentRequestsPerHost(),fluent.isHttp2Disable(),fluent.getHttpProxy(),fluent.getHttpsProxy(),fluent.getNoProxy(),fluent.getErrorMessages(),fluent.getUserAgent(),fluent.getTlsVersions(),fluent.getWebsocketPingInterval(),fluent.getProxyUsername(),fluent.getProxyPassword(),fluent.getTrustStoreFile(),fluent.getTrustStorePassphrase(),fluent.getKeyStoreFile(),fluent.getKeyStorePassphrase(),fluent.getImpersonateUsername(),fluent.getImpersonateGroups(),fluent.getImpersonateExtras(),fluent.getOauthTokenProvider(),fluent.getCustomHeaders(),fluent.getRequestRetryBackoffLimit(),fluent.getRequestRetryBackoffInterval(),fluent.getUploadRequestTimeout(),fluent.isOnlyHttpWatches());
    buildable.setDefaultNamespace(fluent.isDefaultNamespace());
    buildable.setAuthProvider(fluent.getAuthProvider());
    buildable.setContexts(fluent.getContexts());
    buildable.setCurrentContext(fluent.getCurrentContext());
    buildable.setAutoConfigure(fluent.isAutoConfigure());
    buildable.setFile(fluent.getFile());
    return buildable;
  }
  

}