/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.http;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.http.Interceptor;
import io.fabric8.kubernetes.client.http.TlsVersion;
import io.fabric8.kubernetes.client.http.WebSocket;
import io.fabric8.kubernetes.client.utils.HttpClientUtils;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;

public interface HttpClient
extends AutoCloseable {
    @Override
    public void close();

    public DerivedClientBuilder newBuilder();

    public <T> CompletableFuture<HttpResponse<T>> sendAsync(HttpRequest var1, Class<T> var2);

    public CompletableFuture<HttpResponse<AsyncBody>> consumeLines(HttpRequest var1, BodyConsumer<String> var2);

    public CompletableFuture<HttpResponse<AsyncBody>> consumeBytes(HttpRequest var1, BodyConsumer<List<ByteBuffer>> var2);

    public WebSocket.Builder newWebSocketBuilder();

    public HttpRequest.Builder newHttpRequestBuilder();

    @FunctionalInterface
    public static interface BodyConsumer<T> {
        public void consume(T var1, AsyncBody var2) throws Exception;
    }

    public static interface AsyncBody {
        public void consume();

        public CompletableFuture<Void> done();

        public void cancel();
    }

    public static interface Builder
    extends DerivedClientBuilder {
        @Override
        public HttpClient build();

        @Override
        public Builder readTimeout(long var1, TimeUnit var3);

        @Override
        public Builder writeTimeout(long var1, TimeUnit var3);

        public Builder connectTimeout(long var1, TimeUnit var3);

        @Override
        public Builder forStreaming();

        @Override
        public Builder addOrReplaceInterceptor(String var1, Interceptor var2);

        @Override
        public Builder authenticatorNone();

        public Builder sslContext(KeyManager[] var1, TrustManager[] var2);

        public Builder followAllRedirects();

        public Builder proxyAddress(InetSocketAddress var1);

        public Builder proxyAuthorization(String var1);

        public Builder tlsVersions(TlsVersion ... var1);

        public Builder preferHttp11();
    }

    public static interface DerivedClientBuilder {
        public HttpClient build();

        public DerivedClientBuilder readTimeout(long var1, TimeUnit var3);

        public DerivedClientBuilder writeTimeout(long var1, TimeUnit var3);

        public DerivedClientBuilder forStreaming();

        public DerivedClientBuilder addOrReplaceInterceptor(String var1, Interceptor var2);

        public DerivedClientBuilder authenticatorNone();

        public DerivedClientBuilder requestConfig(Config var1);
    }

    public static interface Factory {
        default public Builder newBuilder(Config config) {
            Builder builder = this.newBuilder();
            HttpClientUtils.applyCommonConfiguration(config, builder, this);
            return builder;
        }

        public Builder newBuilder();

        default public boolean isDefault() {
            return false;
        }
    }
}

