/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.informers.cache;

import io.fabric8.kubernetes.client.informers.cache.Lister;
import io.fabric8.kubernetes.client.informers.cache.MapIndexer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ListerTest {
    ListerTest() {
    }

    @Test
    void testListerWithEmptyIndex() {
        Lister namespacedPodLister = new Lister(new MapIndexer(), "default");
        Assertions.assertTrue((boolean)namespacedPodLister.list().isEmpty());
    }

    @Test
    void testListerWithIndexValues() {
        MapIndexer<Integer> indexer = new MapIndexer<Integer>();
        indexer.put("default", "key1", 1);
        indexer.put("other", "key2", 1);
        indexer.put("other", "key3", 1);
        Lister result = new Lister(indexer, "default");
        Assertions.assertEquals((int)1, (int)result.list().size());
    }

    @Test
    void testListerWithIndexValuesInOther() {
        MapIndexer<Integer> indexer = new MapIndexer<Integer>();
        indexer.put("default", "key1", 1);
        indexer.put("other", "key2", 1);
        indexer.put("other", "key3", 1);
        Lister result = new Lister(indexer, "default");
        Assertions.assertEquals((int)2, (int)result.namespace("other").list().size());
    }
}

