/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionVersion;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionVersionBuilder;
import io.fabric8.kubernetes.client.utils.KubernetesVersionPriority;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class KubernetesVersionPriorityTest {
    KubernetesVersionPriorityTest() {
    }

    @Test
    void highestPriority_should_version_with_highest_priority() {
        String highest = "v10";
        List<String> versions = Arrays.asList("foo10", "v11alpha2", "foo1", "v3beta1", "v2", "v10beta3", highest, "v11beta2", "v1", "v12alpha1");
        String computed = KubernetesVersionPriority.highestPriority(versions);
        Assertions.assertThat((String)computed).isEqualTo(highest);
    }

    @Test
    void highestPriority_should_null() {
        Assertions.assertThat((String)KubernetesVersionPriority.highestPriority(null)).isNull();
        Assertions.assertThat((String)KubernetesVersionPriority.highestPriority(Collections.emptyList())).isNull();
    }

    @Test
    void sortByPriority_should_sort_with_highest_priority() {
        CustomResourceDefinitionVersion foo10 = KubernetesVersionPriorityTest.createCustomResourceDefinitionVersion("foo10");
        CustomResourceDefinitionVersion v11alpha2 = KubernetesVersionPriorityTest.createCustomResourceDefinitionVersion("v11alpha2");
        CustomResourceDefinitionVersion foo1 = KubernetesVersionPriorityTest.createCustomResourceDefinitionVersion("foo1");
        CustomResourceDefinitionVersion v3beta1 = KubernetesVersionPriorityTest.createCustomResourceDefinitionVersion("v3beta1");
        CustomResourceDefinitionVersion v2 = KubernetesVersionPriorityTest.createCustomResourceDefinitionVersion("v2");
        CustomResourceDefinitionVersion v10beta3 = KubernetesVersionPriorityTest.createCustomResourceDefinitionVersion("v10beta3");
        CustomResourceDefinitionVersion v10 = KubernetesVersionPriorityTest.createCustomResourceDefinitionVersion("v10");
        CustomResourceDefinitionVersion v11beta2 = KubernetesVersionPriorityTest.createCustomResourceDefinitionVersion("v11beta2");
        CustomResourceDefinitionVersion v1 = KubernetesVersionPriorityTest.createCustomResourceDefinitionVersion("v1");
        CustomResourceDefinitionVersion v12alpha1 = KubernetesVersionPriorityTest.createCustomResourceDefinitionVersion("v12alpha1");
        List<CustomResourceDefinitionVersion> versions = Arrays.asList(foo10, v11alpha2, foo1, v3beta1, v2, v10beta3, v10, v11beta2, v1, v12alpha1);
        List computed = KubernetesVersionPriority.sortByPriority(versions, CustomResourceDefinitionVersion::getName);
        List<CustomResourceDefinitionVersion> expected = Arrays.asList(v10, v2, v1, v11beta2, v10beta3, v3beta1, v12alpha1, v11alpha2, foo1, foo10);
        Assertions.assertThat((List)computed).isEqualTo(expected);
        Assertions.assertThat(computed.get(0)).isSameAs((Object)v10);
    }

    @Test
    void sortByPriority_should_accept_null_or_empty() {
        Assertions.assertThat((List)KubernetesVersionPriority.sortByPriority(null, CustomResourceDefinitionVersion::getName)).isEmpty();
        Assertions.assertThat((List)KubernetesVersionPriority.sortByPriority(Collections.emptyList(), CustomResourceDefinitionVersion::getName)).isEmpty();
    }

    @Test
    void sortByPriority_no_versionProvider_should_throw_exception() {
        CustomResourceDefinitionVersion v1 = KubernetesVersionPriorityTest.createCustomResourceDefinitionVersion("v1");
        Assertions.assertThatException().isThrownBy(() -> KubernetesVersionPriority.sortByPriority(Collections.singletonList(v1), null));
        Assertions.assertThatException().isThrownBy(() -> KubernetesVersionPriority.sortByPriority(null, null));
        Assertions.assertThatException().isThrownBy(() -> KubernetesVersionPriority.sortByPriority(Collections.emptyList(), null));
    }

    private static CustomResourceDefinitionVersion createCustomResourceDefinitionVersion(String name) {
        return ((CustomResourceDefinitionVersionBuilder)new CustomResourceDefinitionVersionBuilder().withName(name)).build();
    }
}

