/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.http;

import io.fabric8.kubernetes.client.http.HttpHeaders;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class StandardHttpHeaders
implements HttpHeaders {
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String EXPECT = "Expect";
    public static final String EXPECT_CONTINUE = "100-Continue";
    private final Map<String, List<String>> headers;

    public StandardHttpHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
    }

    @Override
    public List<String> headers(String key) {
        return Collections.unmodifiableList(this.headers.getOrDefault(key, Collections.emptyList()));
    }

    @Override
    public Map<String, List<String>> headers() {
        return Collections.unmodifiableMap(this.headers);
    }
}

