/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.assertions;

import io.fabric8.kubernetes.api.model.LabelSelectorRequirement;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.assertions.AbstractPodSelectionAssert;
import io.fabric8.kubernetes.assertions.support.PodWatcher;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Java6Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PodSelectionAssert
extends AbstractPodSelectionAssert {
    private static final transient Logger LOG = LoggerFactory.getLogger(PodSelectionAssert.class);
    private final KubernetesClient client;
    private final Integer replicas;
    private final Map<String, String> matchLabels;
    private final List<LabelSelectorRequirement> matchExpressions;
    private final String description;

    public PodSelectionAssert(KubernetesClient client, Integer replicas, Map<String, String> matchLabels, List<LabelSelectorRequirement> matchExpressions, String description) {
        this.client = client;
        this.replicas = replicas;
        this.matchLabels = matchLabels;
        this.matchExpressions = matchExpressions;
        this.description = description;
    }

    public KubernetesClient getClient() {
        return this.client;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public Map<String, String> getMatchLabels() {
        return this.matchLabels;
    }

    public List<LabelSelectorRequirement> getMatchExpressions() {
        return this.matchExpressions;
    }

    @Override
    public PodSelectionAssert isPodReadyForPeriod(long notReadyTimeoutMS, long readyPeriodMS) {
        if (this.replicas <= 0) {
            LOG.warn("Not that the pod selection for: " + this.description + " has no replicas defined so we cannot assert there is a pod ready");
            return this;
        }
        try (PodWatcher podWatcher = new PodWatcher(this, notReadyTimeoutMS, readyPeriodMS);
             Watch watch = (Watch)((FilterWatchListDeletable)this.client.pods().withLabels(this.matchLabels)).watch((Object)podWatcher);){
            podWatcher.loadCurrentPods();
            podWatcher.waitForPodReady();
        }
        return this;
    }

    @Override
    public List<Pod> getPods() {
        PodList list = (PodList)((FilterWatchListDeletable)this.getClient().pods().withLabels(this.getMatchLabels())).list();
        ((AbstractObjectAssert)Java6Assertions.assertThat((Object)list).describedAs(this.getDescription() + " pods", new Object[0])).isNotNull();
        return list.getItems();
    }
}

