/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.EditableSourceControlUser;
import io.fabric8.openshift.api.model.SourceControlUser;
import io.fabric8.openshift.api.model.SourceControlUserFluent;
import io.fabric8.openshift.api.model.SourceControlUserFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class SourceControlUserBuilder
extends SourceControlUserFluentImpl<SourceControlUserBuilder>
implements VisitableBuilder<SourceControlUser, SourceControlUserBuilder> {
    SourceControlUserFluent<?> fluent;

    public SourceControlUserBuilder() {
        this(new SourceControlUser());
    }

    public SourceControlUserBuilder(SourceControlUserFluent<?> fluent) {
        this(fluent, new SourceControlUser());
    }

    public SourceControlUserBuilder(SourceControlUserFluent<?> fluent, SourceControlUser instance) {
        this.fluent = fluent;
        fluent.withEmail(instance.getEmail());
        fluent.withName(instance.getName());
    }

    public SourceControlUserBuilder(SourceControlUser instance) {
        this.fluent = this;
        this.withEmail(instance.getEmail());
        this.withName(instance.getName());
    }

    public EditableSourceControlUser build() {
        EditableSourceControlUser buildable = new EditableSourceControlUser(this.fluent.getEmail(), this.fluent.getName());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SourceControlUserBuilder that = (SourceControlUserBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

