/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.DeploymentStatus;
import io.fabric8.kubernetes.api.model.extensions.DeploymentStatusFluent;
import io.fabric8.kubernetes.api.model.extensions.DeploymentStatusFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.EditableDeploymentStatus;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class DeploymentStatusBuilder
extends DeploymentStatusFluentImpl<DeploymentStatusBuilder>
implements VisitableBuilder<DeploymentStatus, DeploymentStatusBuilder> {
    DeploymentStatusFluent<?> fluent;

    public DeploymentStatusBuilder() {
        this(new DeploymentStatus());
    }

    public DeploymentStatusBuilder(DeploymentStatusFluent<?> fluent) {
        this(fluent, new DeploymentStatus());
    }

    public DeploymentStatusBuilder(DeploymentStatusFluent<?> fluent, DeploymentStatus instance) {
        this.fluent = fluent;
        fluent.withReplicas(instance.getReplicas());
        fluent.withUpdatedReplicas(instance.getUpdatedReplicas());
    }

    public DeploymentStatusBuilder(DeploymentStatus instance) {
        this.fluent = this;
        this.withReplicas(instance.getReplicas());
        this.withUpdatedReplicas(instance.getUpdatedReplicas());
    }

    public EditableDeploymentStatus build() {
        EditableDeploymentStatus buildable = new EditableDeploymentStatus(this.fluent.getReplicas(), this.fluent.getUpdatedReplicas());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeploymentStatusBuilder that = (DeploymentStatusBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

