/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EditablePodTemplateSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class PodTemplateSpecBuilder
extends PodTemplateSpecFluentImpl<PodTemplateSpecBuilder>
implements VisitableBuilder<PodTemplateSpec, PodTemplateSpecBuilder> {
    PodTemplateSpecFluent<?> fluent;

    public PodTemplateSpecBuilder() {
        this(new PodTemplateSpec());
    }

    public PodTemplateSpecBuilder(PodTemplateSpecFluent<?> fluent) {
        this(fluent, new PodTemplateSpec());
    }

    public PodTemplateSpecBuilder(PodTemplateSpecFluent<?> fluent, PodTemplateSpec instance) {
        this.fluent = fluent;
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
    }

    public PodTemplateSpecBuilder(PodTemplateSpec instance) {
        this.fluent = this;
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
    }

    public EditablePodTemplateSpec build() {
        EditablePodTemplateSpec buildable = new EditablePodTemplateSpec(this.fluent.getMetadata(), this.fluent.getSpec());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodTemplateSpecBuilder that = (PodTemplateSpecBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

