/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSource;
import io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.EditableAWSElasticBlockStoreVolumeSource;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class AWSElasticBlockStoreVolumeSourceBuilder
extends AWSElasticBlockStoreVolumeSourceFluentImpl<AWSElasticBlockStoreVolumeSourceBuilder>
implements VisitableBuilder<AWSElasticBlockStoreVolumeSource, AWSElasticBlockStoreVolumeSourceBuilder> {
    AWSElasticBlockStoreVolumeSourceFluent<?> fluent;

    public AWSElasticBlockStoreVolumeSourceBuilder() {
        this(new AWSElasticBlockStoreVolumeSource());
    }

    public AWSElasticBlockStoreVolumeSourceBuilder(AWSElasticBlockStoreVolumeSourceFluent<?> fluent) {
        this(fluent, new AWSElasticBlockStoreVolumeSource());
    }

    public AWSElasticBlockStoreVolumeSourceBuilder(AWSElasticBlockStoreVolumeSourceFluent<?> fluent, AWSElasticBlockStoreVolumeSource instance) {
        this.fluent = fluent;
        fluent.withFsType(instance.getFsType());
        fluent.withPartition(instance.getPartition());
        fluent.withReadOnly(instance.getReadOnly());
        fluent.withVolumeID(instance.getVolumeID());
    }

    public AWSElasticBlockStoreVolumeSourceBuilder(AWSElasticBlockStoreVolumeSource instance) {
        this.fluent = this;
        this.withFsType(instance.getFsType());
        this.withPartition(instance.getPartition());
        this.withReadOnly(instance.getReadOnly());
        this.withVolumeID(instance.getVolumeID());
    }

    public EditableAWSElasticBlockStoreVolumeSource build() {
        EditableAWSElasticBlockStoreVolumeSource buildable = new EditableAWSElasticBlockStoreVolumeSource(this.fluent.getFsType(), this.fluent.getPartition(), this.fluent.isReadOnly(), this.fluent.getVolumeID());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AWSElasticBlockStoreVolumeSourceBuilder that = (AWSElasticBlockStoreVolumeSourceBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

