/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import io.fabric8.openshift.api.model.BuildOutput;
import io.fabric8.openshift.api.model.BuildOutputBuilder;
import io.fabric8.openshift.api.model.BuildOutputFluent;
import io.fabric8.openshift.api.model.BuildSource;
import io.fabric8.openshift.api.model.BuildSourceBuilder;
import io.fabric8.openshift.api.model.BuildSourceFluent;
import io.fabric8.openshift.api.model.BuildStrategy;
import io.fabric8.openshift.api.model.BuildStrategyBuilder;
import io.fabric8.openshift.api.model.BuildStrategyFluent;
import io.fabric8.openshift.api.model.SourceRevision;
import io.fabric8.openshift.api.model.SourceRevisionBuilder;
import io.fabric8.openshift.api.model.SourceRevisionFluent;
import java.util.HashMap;
import java.util.Map;

public class BuildSpecFluent<T extends BuildSpecFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    VisitableBuilder<BuildOutput, ?> output;
    VisitableBuilder<ResourceRequirements, ?> resources;
    VisitableBuilder<SourceRevision, ?> revision;
    String serviceAccount;
    VisitableBuilder<BuildSource, ?> source;
    VisitableBuilder<BuildStrategy, ?> strategy;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public BuildOutput getOutput() {
        return this.output != null ? (BuildOutput)this.output.build() : null;
    }

    public T withOutput(BuildOutput output) {
        if (output != null) {
            this.output = new BuildOutputBuilder(output);
            this._visitables.add(this.output);
        }
        return (T)((Object)this);
    }

    public OutputNested<T> withNewOutput() {
        return new OutputNested();
    }

    public OutputNested<T> withNewOutputLike(BuildOutput item) {
        return new OutputNested(item);
    }

    public OutputNested<T> editOutput() {
        return this.withNewOutputLike(this.getOutput());
    }

    public ResourceRequirements getResources() {
        return this.resources != null ? (ResourceRequirements)this.resources.build() : null;
    }

    public T withResources(ResourceRequirements resources) {
        if (resources != null) {
            this.resources = new ResourceRequirementsBuilder(resources);
            this._visitables.add(this.resources);
        }
        return (T)((Object)this);
    }

    public ResourcesNested<T> withNewResources() {
        return new ResourcesNested();
    }

    public ResourcesNested<T> withNewResourcesLike(ResourceRequirements item) {
        return new ResourcesNested(item);
    }

    public ResourcesNested<T> editResources() {
        return this.withNewResourcesLike(this.getResources());
    }

    public SourceRevision getRevision() {
        return this.revision != null ? (SourceRevision)this.revision.build() : null;
    }

    public T withRevision(SourceRevision revision) {
        if (revision != null) {
            this.revision = new SourceRevisionBuilder(revision);
            this._visitables.add(this.revision);
        }
        return (T)((Object)this);
    }

    public RevisionNested<T> withNewRevision() {
        return new RevisionNested();
    }

    public RevisionNested<T> withNewRevisionLike(SourceRevision item) {
        return new RevisionNested(item);
    }

    public RevisionNested<T> editRevision() {
        return this.withNewRevisionLike(this.getRevision());
    }

    public String getServiceAccount() {
        return this.serviceAccount;
    }

    public T withServiceAccount(String serviceAccount) {
        this.serviceAccount = serviceAccount;
        return (T)((Object)this);
    }

    public BuildSource getSource() {
        return this.source != null ? (BuildSource)this.source.build() : null;
    }

    public T withSource(BuildSource source) {
        if (source != null) {
            this.source = new BuildSourceBuilder(source);
            this._visitables.add(this.source);
        }
        return (T)((Object)this);
    }

    public SourceNested<T> withNewSource() {
        return new SourceNested();
    }

    public SourceNested<T> withNewSourceLike(BuildSource item) {
        return new SourceNested(item);
    }

    public SourceNested<T> editSource() {
        return this.withNewSourceLike(this.getSource());
    }

    public BuildStrategy getStrategy() {
        return this.strategy != null ? (BuildStrategy)this.strategy.build() : null;
    }

    public T withStrategy(BuildStrategy strategy) {
        if (strategy != null) {
            this.strategy = new BuildStrategyBuilder(strategy);
            this._visitables.add(this.strategy);
        }
        return (T)((Object)this);
    }

    public StrategyNested<T> withNewStrategy() {
        return new StrategyNested();
    }

    public StrategyNested<T> withNewStrategyLike(BuildStrategy item) {
        return new StrategyNested(item);
    }

    public StrategyNested<T> editStrategy() {
        return this.withNewStrategyLike(this.getStrategy());
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)((Object)this);
    }

    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)((Object)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        BuildSpecFluent that = (BuildSpecFluent)((Object)o);
        if (this.output != null ? !this.output.equals(that.output) : that.output != null) {
            return false;
        }
        if (this.resources != null ? !this.resources.equals(that.resources) : that.resources != null) {
            return false;
        }
        if (this.revision != null ? !this.revision.equals(that.revision) : that.revision != null) {
            return false;
        }
        if (this.serviceAccount != null ? !this.serviceAccount.equals(that.serviceAccount) : that.serviceAccount != null) {
            return false;
        }
        if (this.source != null ? !this.source.equals(that.source) : that.source != null) {
            return false;
        }
        if (this.strategy != null ? !this.strategy.equals(that.strategy) : that.strategy != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class StrategyNested<N>
    extends BuildStrategyFluent<StrategyNested<N>>
    implements Nested<N> {
        private final BuildStrategyBuilder builder;

        StrategyNested() {
            this.builder = new BuildStrategyBuilder(this);
        }

        StrategyNested(BuildStrategy item) {
            this.builder = new BuildStrategyBuilder(this, item);
        }

        public N endStrategy() {
            return this.and();
        }

        public N and() {
            return (N)BuildSpecFluent.this.withStrategy(this.builder.build());
        }
    }

    public class SourceNested<N>
    extends BuildSourceFluent<SourceNested<N>>
    implements Nested<N> {
        private final BuildSourceBuilder builder;

        SourceNested() {
            this.builder = new BuildSourceBuilder(this);
        }

        SourceNested(BuildSource item) {
            this.builder = new BuildSourceBuilder(this, item);
        }

        public N and() {
            return (N)BuildSpecFluent.this.withSource(this.builder.build());
        }

        public N endSource() {
            return this.and();
        }
    }

    public class RevisionNested<N>
    extends SourceRevisionFluent<RevisionNested<N>>
    implements Nested<N> {
        private final SourceRevisionBuilder builder;

        RevisionNested() {
            this.builder = new SourceRevisionBuilder(this);
        }

        RevisionNested(SourceRevision item) {
            this.builder = new SourceRevisionBuilder(this, item);
        }

        public N endRevision() {
            return this.and();
        }

        public N and() {
            return (N)BuildSpecFluent.this.withRevision(this.builder.build());
        }
    }

    public class ResourcesNested<N>
    extends ResourceRequirementsFluent<ResourcesNested<N>>
    implements Nested<N> {
        private final ResourceRequirementsBuilder builder;

        ResourcesNested() {
            this.builder = new ResourceRequirementsBuilder(this);
        }

        ResourcesNested(ResourceRequirements item) {
            this.builder = new ResourceRequirementsBuilder(this, item);
        }

        public N and() {
            return (N)BuildSpecFluent.this.withResources(this.builder.build());
        }

        public N endResources() {
            return this.and();
        }
    }

    public class OutputNested<N>
    extends BuildOutputFluent<OutputNested<N>>
    implements Nested<N> {
        private final BuildOutputBuilder builder;

        OutputNested() {
            this.builder = new BuildOutputBuilder(this);
        }

        OutputNested(BuildOutput item) {
            this.builder = new BuildOutputBuilder(this, item);
        }

        public N endOutput() {
            return this.and();
        }

        public N and() {
            return (N)BuildSpecFluent.this.withOutput(this.builder.build());
        }
    }
}

