/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.openshift.api.model.Parameter;
import io.fabric8.openshift.api.model.Template;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

public abstract class AbstractTemplateAssert<S extends AbstractTemplateAssert<S, A>, A extends Template>
extends AbstractAssert<S, A> {
    protected AbstractTemplateAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasAdditionalProperties(Map additionalProperties) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Map<String, Object> actualAdditionalProperties = ((Template)this.actual).getAdditionalProperties();
        if (!Objects.areEqual(actualAdditionalProperties, (Object)additionalProperties)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, additionalProperties, actualAdditionalProperties});
        }
        return (S)((Object)((AbstractTemplateAssert)this.myself));
    }

    public S hasApiVersion(Template.ApiVersion apiVersion) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Template.ApiVersion actualApiVersion = ((Template)this.actual).getApiVersion();
        if (!Objects.areEqual((Object)((Object)actualApiVersion), (Object)((Object)apiVersion))) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, apiVersion, actualApiVersion});
        }
        return (S)((Object)((AbstractTemplateAssert)this.myself));
    }

    public S hasKind(String kind) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualKind = ((Template)this.actual).getKind();
        if (!Objects.areEqual((Object)actualKind, (Object)kind)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, kind, actualKind});
        }
        return (S)((Object)((AbstractTemplateAssert)this.myself));
    }

    public S hasLabels(Map labels) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected labels of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Map<String, String> actualLabels = ((Template)this.actual).getLabels();
        if (!Objects.areEqual(actualLabels, (Object)labels)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, labels, actualLabels});
        }
        return (S)((Object)((AbstractTemplateAssert)this.myself));
    }

    public S hasMetadata(ObjectMeta metadata) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        ObjectMeta actualMetadata = ((Template)this.actual).getMetadata();
        if (!Objects.areEqual((Object)actualMetadata, (Object)metadata)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, metadata, actualMetadata});
        }
        return (S)((Object)((AbstractTemplateAssert)this.myself));
    }

    public S hasObjects(HasMetadata ... objects) {
        this.isNotNull();
        if (objects == null) {
            throw new AssertionError((Object)"Expecting objects parameter not to be null.");
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, ((Template)this.actual).getObjects(), (Object[])objects);
        return (S)((Object)((AbstractTemplateAssert)this.myself));
    }

    public S hasNoObjects() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have objects but had :\n  <%s>";
        if (((Template)this.actual).getObjects().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((Template)this.actual).getObjects()});
        }
        return (S)((Object)((AbstractTemplateAssert)this.myself));
    }

    public S hasParameters(Parameter ... parameters) {
        this.isNotNull();
        if (parameters == null) {
            throw new AssertionError((Object)"Expecting parameters parameter not to be null.");
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, ((Template)this.actual).getParameters(), (Object[])parameters);
        return (S)((Object)((AbstractTemplateAssert)this.myself));
    }

    public S hasNoParameters() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have parameters but had :\n  <%s>";
        if (((Template)this.actual).getParameters().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((Template)this.actual).getParameters()});
        }
        return (S)((Object)((AbstractTemplateAssert)this.myself));
    }
}

