/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.assertions;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodAssert;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerAssert;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.ReplicationControllerListAssert;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceAssert;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.api.model.ServiceListAssert;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import io.fabric8.kubernetes.api.model.ServiceSpecAssert;
import io.fabric8.kubernetes.assertions.Assertions;
import io.fabric8.kubernetes.assertions.KubernetesNamespaceAssert;
import io.fabric8.kubernetes.assertions.PodsAssert;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ClientLoggableResource;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.kubernetes.client.dsl.ClientRollableScallableResource;
import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.ListAssert;

public class KubernetesAssert
extends AbstractAssert<KubernetesAssert, KubernetesClient> {
    private final KubernetesClient client;

    public KubernetesAssert(KubernetesClient client) {
        super((Object)client, KubernetesAssert.class);
        this.client = client;
    }

    public KubernetesNamespaceAssert namespace(String namespace) {
        return new KubernetesNamespaceAssert(this.client, namespace);
    }

    public PodsAssert podList() {
        PodList pods = (PodList)this.client.pods().list();
        return this.podList(pods);
    }

    public PodsAssert podList(PodList pods) {
        Assertions.assertThat(pods).isNotNull();
        return this.podList(pods.getItems());
    }

    public PodsAssert podList(List<Pod> pods) {
        org.assertj.core.api.Assertions.assertThat(pods).isNotNull();
        return new PodsAssert(pods, this.client);
    }

    public PodsAssert pods() {
        return this.pods(null);
    }

    public PodsAssert pods(String namespace) {
        List<Pod> pods = this.getPods(namespace);
        return this.podList(pods);
    }

    protected List<Pod> getPods(String namespace) {
        PodList podList = (PodList)((ClientNonNamespaceOperation)this.client.pods().inNamespace(namespace)).list();
        Assertions.assertThat(podList).isNotNull();
        List<Pod> pods = podList.getItems();
        this.podList(pods).isNotNull();
        return pods;
    }

    public ReplicationControllerListAssert replicationControllerList() {
        ReplicationControllerList replicationControllers = (ReplicationControllerList)this.client.replicationControllers().list();
        return (ReplicationControllerListAssert)Assertions.assertThat(replicationControllers).isNotNull();
    }

    public ReplicationControllerListAssert replicationControllerList(String namespace) {
        ReplicationControllerList replicationControllers = (ReplicationControllerList)((ClientNonNamespaceOperation)this.client.replicationControllers().inNamespace(namespace)).list();
        return (ReplicationControllerListAssert)Assertions.assertThat(replicationControllers).isNotNull();
    }

    public ListAssert<ReplicationController> replicationControllers() {
        return this.replicationControllers(null);
    }

    public ListAssert<ReplicationController> replicationControllers(String namespace) {
        ReplicationControllerList replicationControllerList = (ReplicationControllerList)((ClientNonNamespaceOperation)this.client.replicationControllers().inNamespace(namespace)).list();
        Assertions.assertThat(replicationControllerList).isNotNull();
        List<ReplicationController> replicationControllers = replicationControllerList.getItems();
        return (ListAssert)org.assertj.core.api.Assertions.assertThat(replicationControllers);
    }

    public ServiceListAssert serviceList() {
        ServiceList serviceList = (ServiceList)this.client.services().list();
        return (ServiceListAssert)Assertions.assertThat(serviceList).isNotNull();
    }

    public ServiceListAssert serviceList(String namespace) {
        ServiceList serviceList = (ServiceList)((ClientNonNamespaceOperation)this.client.services().inNamespace(namespace)).list();
        return (ServiceListAssert)Assertions.assertThat(serviceList).isNotNull();
    }

    public ListAssert<Service> services() {
        return this.services(null);
    }

    public ListAssert<Service> services(String namespace) {
        ServiceList serviceList = (ServiceList)((ClientNonNamespaceOperation)this.client.services().inNamespace(namespace)).list();
        Assertions.assertThat(serviceList).isNotNull();
        List<Service> services = serviceList.getItems();
        return (ListAssert)org.assertj.core.api.Assertions.assertThat(services);
    }

    public PodsAssert podsForReplicationController(String replicationControllerId, String namespace) {
        ReplicationController replicationController = this.getReplicationController(replicationControllerId, namespace);
        return this.podsForReplicationController(replicationController);
    }

    public PodsAssert podsForReplicationController(ReplicationController replicationController) {
        List<Pod> allPods = this.getPods(replicationController.getMetadata().getNamespace());
        List pods = KubernetesHelper.getPodsForReplicationController((ReplicationController)replicationController, allPods);
        return this.podList(pods);
    }

    public PodsAssert podsForService(String serviceId, String namespace) {
        Service service = this.getService(serviceId, namespace);
        return this.podsForService(service);
    }

    public PodsAssert podsForService(Service service) {
        List<Pod> allPods = this.getPods(service.getMetadata().getNamespace());
        List pods = KubernetesHelper.getPodsForService((Service)service, allPods);
        return this.podList(pods);
    }

    public ReplicationControllerAssert replicationController(String replicationControllerId, String namespace) {
        return Assertions.assertThat(this.getReplicationController(replicationControllerId, namespace));
    }

    protected ReplicationController getReplicationController(String replicationControllerId, String namespace) {
        org.assertj.core.api.Assertions.assertThat((String)replicationControllerId).isNotNull();
        ReplicationController replicationController = null;
        try {
            replicationController = (ReplicationController)((ClientRollableScallableResource)((ClientNonNamespaceOperation)this.client.replicationControllers().inNamespace(namespace)).withName(replicationControllerId)).get();
        }
        catch (Exception e) {
            org.assertj.core.api.Assertions.fail((String)("Could not find replicationController for '" + replicationControllerId + "'"));
        }
        Assertions.assertThat(replicationController).isNotNull();
        return replicationController;
    }

    public ServiceAssert service(String serviceId, String namespace) {
        return Assertions.assertThat(this.getService(serviceId, namespace));
    }

    public void hasServicePort(String serviceId, String namespace, int port) {
        ServiceSpec spec = this.getServiceSpec(serviceId, namespace);
        boolean found = false;
        List<ServicePort> ports = spec.getPorts();
        ArrayList<Integer> portNumbers = new ArrayList<Integer>();
        if (ports != null) {
            for (ServicePort servicePort : ports) {
                Integer aPort = servicePort.getPort();
                if (aPort == null) continue;
                if (aPort == port) {
                    found = true;
                    break;
                }
                portNumbers.add(aPort);
            }
        }
        ((AbstractBooleanAssert)org.assertj.core.api.Assertions.assertThat((boolean)found).describedAs("No port found for " + port + " but found ports: " + portNumbers, new Object[0])).isTrue();
    }

    public ServiceSpecAssert serviceSpec(String serviceId, String namespace) {
        return Assertions.assertThat(this.getServiceSpec(serviceId, namespace));
    }

    protected Service getService(String serviceId, String namespace) {
        org.assertj.core.api.Assertions.assertThat((String)serviceId).isNotNull();
        Service service = null;
        try {
            service = (Service)((ClientResource)((ClientNonNamespaceOperation)this.client.services().inNamespace(namespace)).withName(serviceId)).get();
        }
        catch (Exception e) {
            org.assertj.core.api.Assertions.fail((String)("Could not find service for '" + serviceId + "'"));
        }
        Assertions.assertThat(service).isNotNull();
        return service;
    }

    protected ServiceSpec getServiceSpec(String serviceId, String namespace) {
        Service service = this.getService(serviceId, namespace);
        ServiceSpec spec = service.getSpec();
        Assertions.assertThat(spec).isNotNull();
        return spec;
    }

    public PodAssert pod(String podId, String namespace) {
        return Assertions.assertThat(this.getPod(podId, namespace));
    }

    protected Pod getPod(String podId, String namespace) {
        org.assertj.core.api.Assertions.assertThat((String)podId).isNotNull();
        Pod pod = null;
        try {
            pod = (Pod)((ClientLoggableResource)((ClientNonNamespaceOperation)this.client.pods().inNamespace(namespace)).withName(podId)).get();
        }
        catch (Exception e) {
            org.assertj.core.api.Assertions.fail((String)("Could not find pod for '" + podId + "'"));
        }
        Assertions.assertThat(pod).isNotNull();
        return pod;
    }
}

