/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EditablePodCondition;
import io.fabric8.kubernetes.api.model.PodCondition;
import io.fabric8.kubernetes.api.model.PodConditionFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class PodConditionBuilder
extends PodConditionFluent<PodConditionBuilder>
implements VisitableBuilder<PodCondition, PodConditionBuilder> {
    PodConditionFluent<?> fluent;

    public PodConditionBuilder() {
        this(new PodCondition());
    }

    public PodConditionBuilder(PodConditionFluent<?> fluent) {
        this(fluent, new PodCondition());
    }

    public PodConditionBuilder(PodConditionFluent<?> fluent, PodCondition instance) {
        this.fluent = fluent;
        fluent.withStatus(instance.getStatus());
        fluent.withType(instance.getType());
    }

    public PodConditionBuilder(PodCondition instance) {
        this.fluent = this;
        this.withStatus(instance.getStatus());
        this.withType(instance.getType());
    }

    public EditablePodCondition build() {
        EditablePodCondition buildable = new EditablePodCondition(this.fluent.getStatus(), this.fluent.getType());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodConditionBuilder that = (PodConditionBuilder)((Object)o);
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

