/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.ContainerPortBuilder;
import io.fabric8.kubernetes.api.model.ContainerPortFluent;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import io.fabric8.kubernetes.api.model.Lifecycle;
import io.fabric8.kubernetes.api.model.LifecycleBuilder;
import io.fabric8.kubernetes.api.model.LifecycleFluent;
import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.ProbeBuilder;
import io.fabric8.kubernetes.api.model.ProbeFluent;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import io.fabric8.kubernetes.api.model.SecurityContext;
import io.fabric8.kubernetes.api.model.SecurityContextBuilder;
import io.fabric8.kubernetes.api.model.SecurityContextFluent;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.kubernetes.api.model.VolumeMountFluent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ContainerFluent<T extends ContainerFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    List<String> args = new ArrayList<String>();
    List<String> command = new ArrayList<String>();
    List<VisitableBuilder<EnvVar, ?>> env = new ArrayList();
    String image;
    String imagePullPolicy;
    VisitableBuilder<Lifecycle, ?> lifecycle;
    VisitableBuilder<Probe, ?> livenessProbe;
    String name;
    List<VisitableBuilder<ContainerPort, ?>> ports = new ArrayList();
    VisitableBuilder<Probe, ?> readinessProbe;
    VisitableBuilder<ResourceRequirements, ?> resources;
    VisitableBuilder<SecurityContext, ?> securityContext;
    String terminationMessagePath;
    List<VisitableBuilder<VolumeMount, ?>> volumeMounts = new ArrayList();
    String workingDir;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public T addToArgs(String ... items) {
        for (String item : items) {
            this.args.add(item);
        }
        return (T)((Object)this);
    }

    public T removeFromArgs(String ... items) {
        for (String item : items) {
            this.args.remove(item);
        }
        return (T)((Object)this);
    }

    public List<String> getArgs() {
        return this.args;
    }

    public T withArgs(List<String> args) {
        this.args.clear();
        if (args != null) {
            for (String item : args) {
                this.addToArgs(item);
            }
        }
        return (T)((Object)this);
    }

    public T withArgs(String ... args) {
        this.args.clear();
        if (args != null) {
            for (String item : args) {
                this.addToArgs(item);
            }
        }
        return (T)((Object)this);
    }

    public T addToCommand(String ... items) {
        for (String item : items) {
            this.command.add(item);
        }
        return (T)((Object)this);
    }

    public T removeFromCommand(String ... items) {
        for (String item : items) {
            this.command.remove(item);
        }
        return (T)((Object)this);
    }

    public List<String> getCommand() {
        return this.command;
    }

    public T withCommand(List<String> command) {
        this.command.clear();
        if (command != null) {
            for (String item : command) {
                this.addToCommand(item);
            }
        }
        return (T)((Object)this);
    }

    public T withCommand(String ... command) {
        this.command.clear();
        if (command != null) {
            for (String item : command) {
                this.addToCommand(item);
            }
        }
        return (T)((Object)this);
    }

    public T addToEnv(EnvVar ... items) {
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.add(builder);
            this.env.add(builder);
        }
        return (T)((Object)this);
    }

    public T removeFromEnv(EnvVar ... items) {
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.remove((Object)builder);
            this.env.remove((Object)builder);
        }
        return (T)((Object)this);
    }

    public List<EnvVar> getEnv() {
        return this.build(this.env);
    }

    public T withEnv(List<EnvVar> env) {
        this.env.clear();
        if (env != null) {
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        }
        return (T)((Object)this);
    }

    public T withEnv(EnvVar ... env) {
        this.env.clear();
        if (env != null) {
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        }
        return (T)((Object)this);
    }

    public EnvNested<T> addNewEnv() {
        return new EnvNested();
    }

    public EnvNested<T> addNewEnvLike(EnvVar item) {
        return new EnvNested(item);
    }

    public String getImage() {
        return this.image;
    }

    public T withImage(String image) {
        this.image = image;
        return (T)((Object)this);
    }

    public String getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public T withImagePullPolicy(String imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
        return (T)((Object)this);
    }

    public Lifecycle getLifecycle() {
        return this.lifecycle != null ? (Lifecycle)this.lifecycle.build() : null;
    }

    public T withLifecycle(Lifecycle lifecycle) {
        if (lifecycle != null) {
            this.lifecycle = new LifecycleBuilder(lifecycle);
            this._visitables.add(this.lifecycle);
        }
        return (T)((Object)this);
    }

    public LifecycleNested<T> withNewLifecycle() {
        return new LifecycleNested();
    }

    public LifecycleNested<T> withNewLifecycleLike(Lifecycle item) {
        return new LifecycleNested(item);
    }

    public LifecycleNested<T> editLifecycle() {
        return this.withNewLifecycleLike(this.getLifecycle());
    }

    public Probe getLivenessProbe() {
        return this.livenessProbe != null ? (Probe)this.livenessProbe.build() : null;
    }

    public T withLivenessProbe(Probe livenessProbe) {
        if (livenessProbe != null) {
            this.livenessProbe = new ProbeBuilder(livenessProbe);
            this._visitables.add(this.livenessProbe);
        }
        return (T)((Object)this);
    }

    public LivenessProbeNested<T> withNewLivenessProbe() {
        return new LivenessProbeNested();
    }

    public LivenessProbeNested<T> withNewLivenessProbeLike(Probe item) {
        return new LivenessProbeNested(item);
    }

    public LivenessProbeNested<T> editLivenessProbe() {
        return this.withNewLivenessProbeLike(this.getLivenessProbe());
    }

    public String getName() {
        return this.name;
    }

    public T withName(String name) {
        this.name = name;
        return (T)((Object)this);
    }

    public T addToPorts(ContainerPort ... items) {
        for (ContainerPort item : items) {
            ContainerPortBuilder builder = new ContainerPortBuilder(item);
            this._visitables.add(builder);
            this.ports.add(builder);
        }
        return (T)((Object)this);
    }

    public T removeFromPorts(ContainerPort ... items) {
        for (ContainerPort item : items) {
            ContainerPortBuilder builder = new ContainerPortBuilder(item);
            this._visitables.remove((Object)builder);
            this.ports.remove((Object)builder);
        }
        return (T)((Object)this);
    }

    public List<ContainerPort> getPorts() {
        return this.build(this.ports);
    }

    public T withPorts(List<ContainerPort> ports) {
        this.ports.clear();
        if (ports != null) {
            for (ContainerPort item : ports) {
                this.addToPorts(item);
            }
        }
        return (T)((Object)this);
    }

    public T withPorts(ContainerPort ... ports) {
        this.ports.clear();
        if (ports != null) {
            for (ContainerPort item : ports) {
                this.addToPorts(item);
            }
        }
        return (T)((Object)this);
    }

    public PortsNested<T> addNewPort() {
        return new PortsNested();
    }

    public PortsNested<T> addNewPortLike(ContainerPort item) {
        return new PortsNested(item);
    }

    public T addNewPort(Integer containerPort, String hostIP, Integer hostPort, String name, String protocol) {
        return this.addToPorts(new ContainerPort(containerPort, hostIP, hostPort, name, protocol));
    }

    public Probe getReadinessProbe() {
        return this.readinessProbe != null ? (Probe)this.readinessProbe.build() : null;
    }

    public T withReadinessProbe(Probe readinessProbe) {
        if (readinessProbe != null) {
            this.readinessProbe = new ProbeBuilder(readinessProbe);
            this._visitables.add(this.readinessProbe);
        }
        return (T)((Object)this);
    }

    public ReadinessProbeNested<T> withNewReadinessProbe() {
        return new ReadinessProbeNested();
    }

    public ReadinessProbeNested<T> withNewReadinessProbeLike(Probe item) {
        return new ReadinessProbeNested(item);
    }

    public ReadinessProbeNested<T> editReadinessProbe() {
        return this.withNewReadinessProbeLike(this.getReadinessProbe());
    }

    public ResourceRequirements getResources() {
        return this.resources != null ? (ResourceRequirements)this.resources.build() : null;
    }

    public T withResources(ResourceRequirements resources) {
        if (resources != null) {
            this.resources = new ResourceRequirementsBuilder(resources);
            this._visitables.add(this.resources);
        }
        return (T)((Object)this);
    }

    public ResourcesNested<T> withNewResources() {
        return new ResourcesNested();
    }

    public ResourcesNested<T> withNewResourcesLike(ResourceRequirements item) {
        return new ResourcesNested(item);
    }

    public ResourcesNested<T> editResources() {
        return this.withNewResourcesLike(this.getResources());
    }

    public SecurityContext getSecurityContext() {
        return this.securityContext != null ? (SecurityContext)this.securityContext.build() : null;
    }

    public T withSecurityContext(SecurityContext securityContext) {
        if (securityContext != null) {
            this.securityContext = new SecurityContextBuilder(securityContext);
            this._visitables.add(this.securityContext);
        }
        return (T)((Object)this);
    }

    public SecurityContextNested<T> withNewSecurityContext() {
        return new SecurityContextNested();
    }

    public SecurityContextNested<T> withNewSecurityContextLike(SecurityContext item) {
        return new SecurityContextNested(item);
    }

    public SecurityContextNested<T> editSecurityContext() {
        return this.withNewSecurityContextLike(this.getSecurityContext());
    }

    public String getTerminationMessagePath() {
        return this.terminationMessagePath;
    }

    public T withTerminationMessagePath(String terminationMessagePath) {
        this.terminationMessagePath = terminationMessagePath;
        return (T)((Object)this);
    }

    public T addToVolumeMounts(VolumeMount ... items) {
        for (VolumeMount item : items) {
            VolumeMountBuilder builder = new VolumeMountBuilder(item);
            this._visitables.add(builder);
            this.volumeMounts.add(builder);
        }
        return (T)((Object)this);
    }

    public T removeFromVolumeMounts(VolumeMount ... items) {
        for (VolumeMount item : items) {
            VolumeMountBuilder builder = new VolumeMountBuilder(item);
            this._visitables.remove((Object)builder);
            this.volumeMounts.remove((Object)builder);
        }
        return (T)((Object)this);
    }

    public List<VolumeMount> getVolumeMounts() {
        return this.build(this.volumeMounts);
    }

    public T withVolumeMounts(List<VolumeMount> volumeMounts) {
        this.volumeMounts.clear();
        if (volumeMounts != null) {
            for (VolumeMount item : volumeMounts) {
                this.addToVolumeMounts(item);
            }
        }
        return (T)((Object)this);
    }

    public T withVolumeMounts(VolumeMount ... volumeMounts) {
        this.volumeMounts.clear();
        if (volumeMounts != null) {
            for (VolumeMount item : volumeMounts) {
                this.addToVolumeMounts(item);
            }
        }
        return (T)((Object)this);
    }

    public VolumeMountsNested<T> addNewVolumeMount() {
        return new VolumeMountsNested();
    }

    public VolumeMountsNested<T> addNewVolumeMountLike(VolumeMount item) {
        return new VolumeMountsNested(item);
    }

    public T addNewVolumeMount(String mountPath, String name, Boolean readOnly) {
        return this.addToVolumeMounts(new VolumeMount(mountPath, name, readOnly));
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public T withWorkingDir(String workingDir) {
        this.workingDir = workingDir;
        return (T)((Object)this);
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)((Object)this);
    }

    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)((Object)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ContainerFluent that = (ContainerFluent)((Object)o);
        if (this.args != null ? !this.args.equals(that.args) : that.args != null) {
            return false;
        }
        if (this.command != null ? !this.command.equals(that.command) : that.command != null) {
            return false;
        }
        if (this.env != null ? !this.env.equals(that.env) : that.env != null) {
            return false;
        }
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        if (this.imagePullPolicy != null ? !this.imagePullPolicy.equals(that.imagePullPolicy) : that.imagePullPolicy != null) {
            return false;
        }
        if (this.lifecycle != null ? !this.lifecycle.equals(that.lifecycle) : that.lifecycle != null) {
            return false;
        }
        if (this.livenessProbe != null ? !this.livenessProbe.equals(that.livenessProbe) : that.livenessProbe != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.ports != null ? !this.ports.equals(that.ports) : that.ports != null) {
            return false;
        }
        if (this.readinessProbe != null ? !this.readinessProbe.equals(that.readinessProbe) : that.readinessProbe != null) {
            return false;
        }
        if (this.resources != null ? !this.resources.equals(that.resources) : that.resources != null) {
            return false;
        }
        if (this.securityContext != null ? !this.securityContext.equals(that.securityContext) : that.securityContext != null) {
            return false;
        }
        if (this.terminationMessagePath != null ? !this.terminationMessagePath.equals(that.terminationMessagePath) : that.terminationMessagePath != null) {
            return false;
        }
        if (this.volumeMounts != null ? !this.volumeMounts.equals(that.volumeMounts) : that.volumeMounts != null) {
            return false;
        }
        if (this.workingDir != null ? !this.workingDir.equals(that.workingDir) : that.workingDir != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class VolumeMountsNested<N>
    extends VolumeMountFluent<VolumeMountsNested<N>>
    implements Nested<N> {
        private final VolumeMountBuilder builder;

        VolumeMountsNested() {
            this.builder = new VolumeMountBuilder(this);
        }

        VolumeMountsNested(VolumeMount item) {
            this.builder = new VolumeMountBuilder(this, item);
        }

        public N endVolumeMount() {
            return this.and();
        }

        public N and() {
            return (N)ContainerFluent.this.addToVolumeMounts(this.builder.build());
        }
    }

    public class SecurityContextNested<N>
    extends SecurityContextFluent<SecurityContextNested<N>>
    implements Nested<N> {
        private final SecurityContextBuilder builder;

        SecurityContextNested() {
            this.builder = new SecurityContextBuilder(this);
        }

        SecurityContextNested(SecurityContext item) {
            this.builder = new SecurityContextBuilder(this, item);
        }

        public N endSecurityContext() {
            return this.and();
        }

        public N and() {
            return (N)ContainerFluent.this.withSecurityContext(this.builder.build());
        }
    }

    public class ResourcesNested<N>
    extends ResourceRequirementsFluent<ResourcesNested<N>>
    implements Nested<N> {
        private final ResourceRequirementsBuilder builder;

        ResourcesNested() {
            this.builder = new ResourceRequirementsBuilder(this);
        }

        ResourcesNested(ResourceRequirements item) {
            this.builder = new ResourceRequirementsBuilder(this, item);
        }

        public N endResources() {
            return this.and();
        }

        public N and() {
            return (N)ContainerFluent.this.withResources(this.builder.build());
        }
    }

    public class ReadinessProbeNested<N>
    extends ProbeFluent<ReadinessProbeNested<N>>
    implements Nested<N> {
        private final ProbeBuilder builder;

        ReadinessProbeNested() {
            this.builder = new ProbeBuilder(this);
        }

        ReadinessProbeNested(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        public N endReadinessProbe() {
            return this.and();
        }

        public N and() {
            return (N)ContainerFluent.this.withReadinessProbe(this.builder.build());
        }
    }

    public class PortsNested<N>
    extends ContainerPortFluent<PortsNested<N>>
    implements Nested<N> {
        private final ContainerPortBuilder builder;

        PortsNested() {
            this.builder = new ContainerPortBuilder(this);
        }

        PortsNested(ContainerPort item) {
            this.builder = new ContainerPortBuilder(this, item);
        }

        public N endPort() {
            return this.and();
        }

        public N and() {
            return (N)ContainerFluent.this.addToPorts(this.builder.build());
        }
    }

    public class LivenessProbeNested<N>
    extends ProbeFluent<LivenessProbeNested<N>>
    implements Nested<N> {
        private final ProbeBuilder builder;

        LivenessProbeNested() {
            this.builder = new ProbeBuilder(this);
        }

        LivenessProbeNested(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        public N endLivenessProbe() {
            return this.and();
        }

        public N and() {
            return (N)ContainerFluent.this.withLivenessProbe(this.builder.build());
        }
    }

    public class LifecycleNested<N>
    extends LifecycleFluent<LifecycleNested<N>>
    implements Nested<N> {
        private final LifecycleBuilder builder;

        LifecycleNested() {
            this.builder = new LifecycleBuilder(this);
        }

        LifecycleNested(Lifecycle item) {
            this.builder = new LifecycleBuilder(this, item);
        }

        public N endLifecycle() {
            return this.and();
        }

        public N and() {
            return (N)ContainerFluent.this.withLifecycle(this.builder.build());
        }
    }

    public class EnvNested<N>
    extends EnvVarFluent<EnvNested<N>>
    implements Nested<N> {
        private final EnvVarBuilder builder;

        EnvNested(EnvVar item) {
            this.builder = new EnvVarBuilder(this, item);
        }

        EnvNested() {
            this.builder = new EnvVarBuilder(this);
        }

        public N endEnv() {
            return this.and();
        }

        public N and() {
            return (N)ContainerFluent.this.addToEnv(this.builder.build());
        }
    }
}

