/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.config;

import io.fabric8.kubernetes.api.model.config.Cluster;
import io.fabric8.kubernetes.api.model.config.NamedExtension;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

public abstract class AbstractClusterAssert<S extends AbstractClusterAssert<S, A>, A extends Cluster>
extends AbstractAssert<S, A> {
    protected AbstractClusterAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasAdditionalProperties(Map additionalProperties) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Map<String, Object> actualAdditionalProperties = ((Cluster)this.actual).getAdditionalProperties();
        if (!Objects.areEqual(actualAdditionalProperties, (Object)additionalProperties)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, additionalProperties, actualAdditionalProperties});
        }
        return (S)((Object)((AbstractClusterAssert)this.myself));
    }

    public S hasApiVersion(String apiVersion) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualApiVersion = ((Cluster)this.actual).getApiVersion();
        if (!Objects.areEqual((Object)actualApiVersion, (Object)apiVersion)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, apiVersion, actualApiVersion});
        }
        return (S)((Object)((AbstractClusterAssert)this.myself));
    }

    public S hasCertificateAuthority(String certificateAuthority) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected certificateAuthority of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualCertificateAuthority = ((Cluster)this.actual).getCertificateAuthority();
        if (!Objects.areEqual((Object)actualCertificateAuthority, (Object)certificateAuthority)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, certificateAuthority, actualCertificateAuthority});
        }
        return (S)((Object)((AbstractClusterAssert)this.myself));
    }

    public S hasCertificateAuthorityData(String certificateAuthorityData) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected certificateAuthorityData of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualCertificateAuthorityData = ((Cluster)this.actual).getCertificateAuthorityData();
        if (!Objects.areEqual((Object)actualCertificateAuthorityData, (Object)certificateAuthorityData)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, certificateAuthorityData, actualCertificateAuthorityData});
        }
        return (S)((Object)((AbstractClusterAssert)this.myself));
    }

    public S hasExtensions(NamedExtension ... extensions) {
        this.isNotNull();
        if (extensions == null) {
            throw new AssertionError((Object)"Expecting extensions parameter not to be null.");
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, ((Cluster)this.actual).getExtensions(), (Object[])extensions);
        return (S)((Object)((AbstractClusterAssert)this.myself));
    }

    public S hasNoExtensions() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have extensions but had :\n  <%s>";
        if (((Cluster)this.actual).getExtensions().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((Cluster)this.actual).getExtensions()});
        }
        return (S)((Object)((AbstractClusterAssert)this.myself));
    }

    public S hasInsecureSkipTlsVerify(Boolean insecureSkipTlsVerify) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected insecureSkipTlsVerify of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Boolean actualInsecureSkipTlsVerify = ((Cluster)this.actual).getInsecureSkipTlsVerify();
        if (!Objects.areEqual((Object)actualInsecureSkipTlsVerify, (Object)insecureSkipTlsVerify)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, insecureSkipTlsVerify, actualInsecureSkipTlsVerify});
        }
        return (S)((Object)((AbstractClusterAssert)this.myself));
    }

    public S hasServer(String server) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected server of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualServer = ((Cluster)this.actual).getServer();
        if (!Objects.areEqual((Object)actualServer, (Object)server)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, server, actualServer});
        }
        return (S)((Object)((AbstractClusterAssert)this.myself));
    }
}

