/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.TLSConfig;
import io.fabric8.openshift.api.model.TLSConfigFluent;
import io.fabric8.openshift.api.model.TLSConfigFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class TLSConfigBuilder
extends TLSConfigFluentImpl<TLSConfigBuilder>
implements VisitableBuilder<TLSConfig, TLSConfigBuilder> {
    TLSConfigFluent<?> fluent;
    Boolean validationEnabled;

    public TLSConfigBuilder() {
        this(true);
    }

    public TLSConfigBuilder(Boolean validationEnabled) {
        this(new TLSConfig(), validationEnabled);
    }

    public TLSConfigBuilder(TLSConfigFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public TLSConfigBuilder(TLSConfigFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new TLSConfig(), validationEnabled);
    }

    public TLSConfigBuilder(TLSConfigFluent<?> fluent, TLSConfig instance) {
        this(fluent, instance, true);
    }

    public TLSConfigBuilder(TLSConfigFluent<?> fluent, TLSConfig instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCaCertificate(instance.getCaCertificate());
        fluent.withCertificate(instance.getCertificate());
        fluent.withDestinationCACertificate(instance.getDestinationCACertificate());
        fluent.withInsecureEdgeTerminationPolicy(instance.getInsecureEdgeTerminationPolicy());
        fluent.withKey(instance.getKey());
        fluent.withTermination(instance.getTermination());
        this.validationEnabled = validationEnabled;
    }

    public TLSConfigBuilder(TLSConfig instance) {
        this(instance, (Boolean)true);
    }

    public TLSConfigBuilder(TLSConfig instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCaCertificate(instance.getCaCertificate());
        this.withCertificate(instance.getCertificate());
        this.withDestinationCACertificate(instance.getDestinationCACertificate());
        this.withInsecureEdgeTerminationPolicy(instance.getInsecureEdgeTerminationPolicy());
        this.withKey(instance.getKey());
        this.withTermination(instance.getTermination());
        this.validationEnabled = validationEnabled;
    }

    public TLSConfig build() {
        TLSConfig buildable = new TLSConfig(this.fluent.getCaCertificate(), this.fluent.getCertificate(), this.fluent.getDestinationCACertificate(), this.fluent.getInsecureEdgeTerminationPolicy(), this.fluent.getKey(), this.fluent.getTermination());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TLSConfigBuilder that = (TLSConfigBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

