/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.ClusterPolicy;
import io.fabric8.openshift.api.model.ClusterPolicyFluent;
import io.fabric8.openshift.api.model.NamedClusterRole;
import io.fabric8.openshift.api.model.NamedClusterRoleBuilder;
import io.fabric8.openshift.api.model.NamedClusterRoleFluentImpl;
import java.util.ArrayList;
import java.util.List;

public class ClusterPolicyFluentImpl<A extends ClusterPolicyFluent<A>>
extends BaseFluent<A>
implements ClusterPolicyFluent<A> {
    private String apiVersion;
    private String kind;
    private String lastModified;
    private VisitableBuilder<? extends ObjectMeta, ?> metadata;
    private List<VisitableBuilder<? extends NamedClusterRole, ?>> roles = new ArrayList();

    public ClusterPolicyFluentImpl() {
    }

    public ClusterPolicyFluentImpl(ClusterPolicy instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withLastModified(instance.getLastModified());
        this.withMetadata(instance.getMetadata());
        this.withRoles(instance.getRoles());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public String getLastModified() {
        return this.lastModified;
    }

    @Override
    public A withLastModified(String lastModified) {
        this.lastModified = lastModified;
        return (A)this;
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public ClusterPolicyFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ClusterPolicyFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ClusterPolicyFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public A addToRoles(NamedClusterRole ... items) {
        for (NamedClusterRole item : items) {
            NamedClusterRoleBuilder builder = new NamedClusterRoleBuilder(item);
            this._visitables.add(builder);
            this.roles.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromRoles(NamedClusterRole ... items) {
        for (NamedClusterRole item : items) {
            NamedClusterRoleBuilder builder = new NamedClusterRoleBuilder(item);
            this._visitables.remove(builder);
            this.roles.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<NamedClusterRole> getRoles() {
        return ClusterPolicyFluentImpl.build(this.roles);
    }

    @Override
    public A withRoles(List<NamedClusterRole> roles) {
        this.roles.clear();
        if (roles != null) {
            for (NamedClusterRole item : roles) {
                this.addToRoles(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withRoles(NamedClusterRole ... roles) {
        this.roles.clear();
        if (roles != null) {
            for (NamedClusterRole item : roles) {
                this.addToRoles(item);
            }
        }
        return (A)this;
    }

    @Override
    public ClusterPolicyFluent.RolesNested<A> addNewRole() {
        return new RolesNestedImpl();
    }

    @Override
    public ClusterPolicyFluent.RolesNested<A> addNewRoleLike(NamedClusterRole item) {
        return new RolesNestedImpl(item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterPolicyFluentImpl that = (ClusterPolicyFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.lastModified != null ? !this.lastModified.equals(that.lastModified) : that.lastModified != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        return !(this.roles != null ? !this.roles.equals(that.roles) : that.roles != null);
    }

    public class RolesNestedImpl<N>
    extends NamedClusterRoleFluentImpl<ClusterPolicyFluent.RolesNested<N>>
    implements ClusterPolicyFluent.RolesNested<N>,
    Nested<N> {
        private final NamedClusterRoleBuilder builder;

        RolesNestedImpl(NamedClusterRole item) {
            this.builder = new NamedClusterRoleBuilder(this, item);
        }

        RolesNestedImpl() {
            this.builder = new NamedClusterRoleBuilder(this);
        }

        @Override
        public N endRole() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ClusterPolicyFluentImpl.this.addToRoles(this.builder.build());
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ClusterPolicyFluent.MetadataNested<N>>
    implements ClusterPolicyFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterPolicyFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

