/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.pipelines;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.pipelines.JobEnvironment;
import io.fabric8.kubernetes.api.pipelines.Pipeline;
import io.fabric8.kubernetes.api.pipelines.PipelineConfiguration;
import io.fabric8.kubernetes.api.pipelines.PipelineKind;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.utils.Strings;
import java.beans.IntrospectionException;
import java.util.Arrays;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pipelines {
    public static final String PIPELINE_KIND = "PIPELINE_KIND";
    public static final String JOB_NAME = "JOB_NAME";
    private static final transient Logger LOG = LoggerFactory.getLogger(Pipelines.class);

    public static Pipeline getPipeline(Map<String, String> jobEnvironment) throws IntrospectionException {
        DefaultKubernetesClient kubernetesClient = new DefaultKubernetesClient();
        String namespace = KubernetesHelper.getNamespace((KubernetesClient)kubernetesClient);
        return Pipelines.getPipeline((KubernetesClient)kubernetesClient, namespace, jobEnvironment);
    }

    public static Pipeline getPipeline(String namespace, Map<String, String> jobEnvironment) throws IntrospectionException {
        return Pipelines.getPipeline((KubernetesClient)new DefaultKubernetesClient(), namespace, jobEnvironment);
    }

    public static Pipeline getPipeline(KubernetesClient kubernetesClient, String namespace, Map<String, String> jobEnvironment) throws IntrospectionException {
        String kind = jobEnvironment.get(PIPELINE_KIND);
        String jobName = jobEnvironment.get(JOB_NAME);
        if (Strings.isNotBlank((String)jobName) && Strings.isNotBlank((String)kind)) {
            try {
                PipelineKind pipelineKind = PipelineKind.valueOf(kind);
                return new Pipeline(pipelineKind, jobName);
            }
            catch (IllegalArgumentException e) {
                LOG.warn("$PIPELINE_KIND has a value of " + kind + " which is not a valid value. Available values are: " + Arrays.asList(PipelineKind.values()) + ". " + e, (Throwable)e);
            }
        }
        PipelineConfiguration configuration = PipelineConfiguration.loadPipelineConfiguration(kubernetesClient, namespace);
        Pipeline pipeline = configuration.getPipeline(jobEnvironment);
        jobEnvironment.put(PIPELINE_KIND, pipeline.getKind().toString());
        return pipeline;
    }

    public static Pipeline getPipeline(KubernetesClient kubernetesClient, String namespace, JobEnvironment jobEnvironment) throws IntrospectionException {
        PipelineConfiguration configuration = PipelineConfiguration.loadPipelineConfiguration(kubernetesClient, namespace);
        return configuration.getPipeline(jobEnvironment);
    }
}

