/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.extensions;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.openshift.api.model.Parameter;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.utils.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Templates {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final transient Logger LOG = LoggerFactory.getLogger(Templates.class);

    public static Object combineTemplates(KubernetesList kubernetesList) {
        KubernetesList firstTemplate = null;
        List items = kubernetesList.getItems();
        for (HasMetadata item : items) {
            if (!(item instanceof Template)) continue;
            Template template = (Template)item;
            if (firstTemplate == null) {
                firstTemplate = template;
                continue;
            }
            firstTemplate = Templates.combineTemplates((Template)firstTemplate, template);
        }
        if (firstTemplate != null) {
            for (HasMetadata object : items) {
                if (object instanceof Template) continue;
                Templates.addTemplateObject((Template)firstTemplate, object);
            }
        }
        return firstTemplate != null ? firstTemplate : kubernetesList;
    }

    public static Template combineTemplates(Template firstTemplate, Template template) {
        ArrayList<Parameter> parameters;
        List objects = template.getObjects();
        if (objects != null) {
            for (HasMetadata object : objects) {
                Templates.addTemplateObject(firstTemplate, object);
            }
        }
        if ((parameters = firstTemplate.getParameters()) == null) {
            parameters = new ArrayList<Parameter>();
            firstTemplate.setParameters(parameters);
        }
        Templates.combineParameters(parameters, template.getParameters());
        String name = KubernetesHelper.getName((HasMetadata)template);
        if (Strings.isNotBlank((String)name)) {
            Map<String, String> annotations = KubernetesHelper.getOrCreateAnnotations((HasMetadata)firstTemplate);
            Map<String, String> otherAnnotations = KubernetesHelper.getOrCreateAnnotations((HasMetadata)template);
            Set<Map.Entry<String, String>> entries = otherAnnotations.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (annotations.containsKey(key)) continue;
                annotations.put(key, value);
            }
        }
        return firstTemplate;
    }

    protected static void combineParameters(List<Parameter> parameters, List<Parameter> otherParameters) {
        if (otherParameters != null && otherParameters.size() > 0) {
            HashMap<String, Parameter> map = new HashMap<String, Parameter>();
            for (Parameter parameter : parameters) {
                map.put(parameter.getName(), parameter);
            }
            for (Parameter otherParameter : otherParameters) {
                String name = otherParameter.getName();
                Parameter original = (Parameter)map.get(name);
                if (original == null) {
                    parameters.add(otherParameter);
                    continue;
                }
                if (!Strings.isNotBlank((String)original.getValue())) continue;
                original.setValue(otherParameter.getValue());
            }
        }
    }

    public static void addTemplateObject(Template template, HasMetadata object) {
        List objects = template.getObjects();
        objects.add(object);
        template.setObjects(objects);
    }

    public static Object combineTemplates(KubernetesList kubernetesList, List<HasMetadata> items) {
        Template template = null;
        for (HasMetadata item : items) {
            if (!(item instanceof Template)) continue;
            Template aTemplate = (Template)item;
            if (template == null) {
                template = aTemplate;
                continue;
            }
            template = Templates.combineTemplates(template, aTemplate);
        }
        if (template != null) {
            for (HasMetadata item : items) {
                if (item instanceof Template) continue;
                Templates.addTemplateObject(template, item);
            }
            List objects = template.getObjects();
            return template;
        }
        return kubernetesList;
    }

    public static void overrideTemplateParameters(Template template, Map<String, String> properties, String propertyNamePrefix) {
        List parameters = template.getParameters();
        if (parameters != null && properties != null) {
            boolean missingProperty = false;
            for (Parameter parameter : parameters) {
                String parameterName = parameter.getName();
                String name = propertyNamePrefix + parameterName;
                String propertyValue = properties.get(name);
                if (Strings.isNotBlank((String)propertyValue)) {
                    LOG.info("Overriding template parameter " + name + " with value: " + propertyValue);
                    parameter.setValue(propertyValue);
                    continue;
                }
                missingProperty = true;
                LOG.info("No property defined for template parameter: " + name);
            }
            if (missingProperty) {
                LOG.debug("current properties " + new TreeSet<String>(properties.keySet()));
            }
        }
    }

    public static KubernetesList processTemplatesLocally(Template entity, boolean failOnMissingParameterValue) throws IOException {
        List parameters;
        List objects = null;
        if (entity != null && ((objects = entity.getObjects()) == null || objects.isEmpty())) {
            return null;
        }
        List list = parameters = entity != null ? entity.getParameters() : null;
        if (parameters != null && !parameters.isEmpty()) {
            String json = "{\"kind\": \"List\", \"apiVersion\": \"v1\",\n  \"items\": " + KubernetesHelper.toJson(objects) + " }";
            for (int i = 0; i < 5; ++i) {
                for (Parameter parameter : parameters) {
                    String name = parameter.getName();
                    String regex = "${" + name + "}";
                    String value = parameter.getValue();
                    if (Strings.isNullOrBlank((String)value)) {
                        if (failOnMissingParameterValue) {
                            throw new IllegalArgumentException("No value available for parameter name: " + name);
                        }
                        value = "";
                    }
                    json = Strings.replaceAllWithoutRegex((String)json, (String)regex, (String)value);
                }
            }
            return (KubernetesList)OBJECT_MAPPER.reader(KubernetesList.class).readValue(json);
        }
        KubernetesList answer = new KubernetesList();
        answer.setItems(objects);
        return answer;
    }
}

