/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.extensions;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.openshift.api.model.template.Parameter;
import io.fabric8.openshift.api.model.template.Template;
import io.fabric8.utils.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Templates {
    private static final transient Logger LOG = LoggerFactory.getLogger(Templates.class);

    public static Object combineTemplates(KubernetesList kubernetesList) {
        KubernetesList firstTemplate = null;
        List items = kubernetesList.getItems();
        for (HasMetadata item : items) {
            if (!(item instanceof Template)) continue;
            Template template = (Template)item;
            if (firstTemplate == null) {
                firstTemplate = template;
                continue;
            }
            firstTemplate = Templates.combineTemplates((Template)firstTemplate, template);
        }
        if (firstTemplate != null) {
            for (HasMetadata object : items) {
                if (object instanceof Template) continue;
                Templates.addTemplateObject((Template)firstTemplate, object);
            }
        }
        return firstTemplate != null ? firstTemplate : kubernetesList;
    }

    public static Template combineTemplates(Template firstTemplate, Template template) {
        ArrayList<Parameter> parameters;
        List objects = template.getObjects();
        if (objects != null) {
            for (HasMetadata object : objects) {
                Templates.addTemplateObject(firstTemplate, object);
            }
        }
        if ((parameters = firstTemplate.getParameters()) == null) {
            parameters = new ArrayList<Parameter>();
            firstTemplate.setParameters(parameters);
        }
        Templates.combineParameters(parameters, template.getParameters());
        return firstTemplate;
    }

    protected static void combineParameters(List<Parameter> parameters, List<Parameter> otherParameters) {
        if (otherParameters != null && otherParameters.size() > 0) {
            HashMap<String, Parameter> map = new HashMap<String, Parameter>();
            for (Parameter parameter : parameters) {
                map.put(parameter.getName(), parameter);
            }
            for (Parameter otherParameter : otherParameters) {
                String name = otherParameter.getName();
                Parameter original = (Parameter)map.get(name);
                if (original == null) {
                    parameters.add(otherParameter);
                    continue;
                }
                if (!Strings.isNotBlank((String)original.getValue())) continue;
                original.setValue(otherParameter.getValue());
            }
        }
    }

    public static void addTemplateObject(Template template, HasMetadata object) {
        ArrayList<HasMetadata> objects = template.getObjects();
        if (objects == null) {
            objects = new ArrayList<HasMetadata>();
            template.setObjects(objects);
        }
        objects.add(object);
    }

    public static Object combineTemplates(KubernetesList kubernetesList, List<HasMetadata> items) {
        Template template = null;
        for (HasMetadata item : items) {
            if (!(item instanceof Template)) continue;
            Template aTemplate = (Template)item;
            if (template == null) {
                template = aTemplate;
                continue;
            }
            template = Templates.combineTemplates(template, aTemplate);
        }
        if (template != null) {
            for (HasMetadata item : items) {
                if (item instanceof Template) continue;
                Templates.addTemplateObject(template, item);
            }
            List objects = template.getObjects();
            KubernetesHelper.moveServicesToFrontOfArray(objects);
            return template;
        }
        return kubernetesList;
    }

    public static void overrideTemplateParameters(Template template, Map<String, String> properties, String propertyNamePrefix) {
        List parameters = template.getParameters();
        if (parameters != null && properties != null) {
            boolean missingProperty = false;
            for (Parameter parameter : parameters) {
                String parameterName = parameter.getName();
                String name = propertyNamePrefix + parameterName;
                String propertyValue = properties.get(name);
                if (Strings.isNotBlank((String)propertyValue)) {
                    LOG.info("Overriding template parameter " + name + " with value: " + propertyValue);
                    parameter.setValue(propertyValue);
                    continue;
                }
                missingProperty = true;
                LOG.info("No property defined for template parameter: " + name);
            }
            if (missingProperty) {
                LOG.debug("current properties " + new TreeSet<String>(properties.keySet()));
            }
        }
    }
}

