/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.fabric8.kubernetes.api.Config;
import io.fabric8.kubernetes.api.Kubernetes;
import io.fabric8.kubernetes.api.KubernetesFactory;
import io.fabric8.kubernetes.api.PodStatus;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerManifest;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodState;
import io.fabric8.kubernetes.api.model.PodTemplate;
import io.fabric8.kubernetes.api.model.Port;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.ReplicationControllerState;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.api.model.util.IntOrString;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.ImageRepository;
import io.fabric8.utils.Files;
import io.fabric8.utils.Filter;
import io.fabric8.utils.Filters;
import io.fabric8.utils.Lists;
import io.fabric8.utils.Objects;
import io.fabric8.utils.Strings;
import io.fabric8.utils.Systems;
import io.fabric8.utils.cxf.TrustEverythingSSLTrustManager;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;

public class KubernetesHelper {
    private static final transient Logger LOG = LoggerFactory.getLogger(KubernetesHelper.class);
    public static final String DEFAULT_DOCKER_HOST = "tcp://localhost:2375";
    protected static SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX");
    private static ObjectMapper objectMapper = KubernetesFactory.createObjectMapper();
    public static final String defaultApiVersion = "v1beta2";
    public static final String defaultOsApiVersion = "v1beta1";
    private static final String HOST_SUFFIX = "_SERVICE_HOST";
    private static final String PORT_SUFFIX = "_SERVICE_PORT";
    private static final String PROTO_SUFFIX = "_TCP_PROTO";
    public static final String DEFAULT_PROTO = "tcp";

    public static String getId(Pod entity) {
        if (entity != null) {
            return Strings.firstNonBlank((String[])new String[]{entity.getId(), KubernetesHelper.getAdditionalPropertyText(entity.getAdditionalProperties(), "name"), entity.getUid()});
        }
        return null;
    }

    public static String getId(ReplicationController entity) {
        if (entity != null) {
            return Strings.firstNonBlank((String[])new String[]{entity.getId(), KubernetesHelper.getAdditionalPropertyText(entity.getAdditionalProperties(), "name"), entity.getUid()});
        }
        return null;
    }

    public static String getId(Service entity) {
        if (entity != null) {
            return Strings.firstNonBlank((String[])new String[]{entity.getId(), KubernetesHelper.getAdditionalPropertyText(entity.getAdditionalProperties(), "name"), entity.getUid()});
        }
        return null;
    }

    public static String getName(Service entity) {
        if (entity != null) {
            return Strings.firstNonBlank((String[])new String[]{KubernetesHelper.getAdditionalPropertyText(entity.getAdditionalProperties(), "name"), entity.getId(), entity.getUid()});
        }
        return null;
    }

    public static String getPortalIP(Service entity) {
        String answer = null;
        if (entity == null || (answer = entity.getPortalIP()) == null) {
            // empty if block
        }
        return answer;
    }

    public static Map<String, String> getSelector(Service entity) {
        Map answer = null;
        if (entity == null || (answer = entity.getSelector()) == null) {
            // empty if block
        }
        return answer != null ? answer : Collections.EMPTY_MAP;
    }

    public static Integer getPort(Service entity) {
        Integer answer = null;
        if (entity == null || (answer = entity.getPort()) == null) {
            // empty if block
        }
        return answer;
    }

    protected static Object getAdditionalProperty(Map<String, Object> additionalProperties, String name) {
        if (additionalProperties != null) {
            return additionalProperties.get(name);
        }
        return null;
    }

    protected static String getAdditionalPropertyText(Map<String, Object> additionalProperties, String name) {
        Object value;
        if (additionalProperties != null && (value = additionalProperties.get(name)) != null) {
            return value.toString();
        }
        return null;
    }

    public static String getDockerIp() {
        String url = KubernetesHelper.resolveDockerHost();
        int idx = url.indexOf("://");
        if (idx > 0) {
            url = url.substring(idx + 3);
        }
        if ((idx = url.indexOf(":")) > 0) {
            url = url.substring(0, idx);
        }
        return url;
    }

    public static String resolveDockerHost() {
        String dockerHost = System.getenv("DOCKER_HOST");
        if (Strings.isNullOrBlank((String)dockerHost)) {
            dockerHost = System.getProperty("docker.host");
        }
        if (Strings.isNullOrBlank((String)dockerHost)) {
            return DEFAULT_DOCKER_HOST;
        }
        return dockerHost;
    }

    public static String toJson(Object dto) throws JsonProcessingException {
        Class<?> clazz = dto.getClass();
        return objectMapper.writerWithType(clazz).writeValueAsString(dto);
    }

    public static Object loadJson(File file) throws IOException {
        byte[] data = Files.readBytes((File)file);
        return KubernetesHelper.loadJson(data);
    }

    public static Object loadJson(InputStream in) throws IOException {
        byte[] data = Files.readBytes((InputStream)in);
        return KubernetesHelper.loadJson(data);
    }

    public static Object loadJson(String json) throws IOException {
        byte[] data = json.getBytes();
        return KubernetesHelper.loadJson(data);
    }

    public static Object loadJson(byte[] json) throws IOException {
        ObjectReader reader;
        JsonNode tree;
        if (json != null && json.length > 0 && (tree = (reader = objectMapper.reader()).readTree((InputStream)new ByteArrayInputStream(json))) != null) {
            JsonNode kindNode = tree.get("kind");
            if (kindNode != null) {
                String kind = kindNode.asText();
                return KubernetesHelper.loadEntity(json, kind, tree);
            }
            LOG.warn("No JSON type for: " + tree);
            return tree;
        }
        return null;
    }

    protected static Object loadEntity(byte[] json, String kind, Object defaultValue) throws IOException {
        if (Objects.equal((Object)"Pod", (Object)kind)) {
            return objectMapper.reader(Pod.class).readValue(json);
        }
        if (Objects.equal((Object)"ReplicationController", (Object)kind)) {
            return objectMapper.reader(ReplicationController.class).readValue(json);
        }
        if (Objects.equal((Object)"Service", (Object)kind)) {
            return objectMapper.reader(Service.class).readValue(json);
        }
        if (Objects.equal((Object)"BuildConfig", (Object)kind)) {
            return objectMapper.reader(BuildConfig.class).readValue(json);
        }
        if (Objects.equal((Object)"DeploymentConfig", (Object)kind)) {
            return objectMapper.reader(DeploymentConfig.class).readValue(json);
        }
        if (Objects.equal((Object)"ImageRepository", (Object)kind)) {
            return objectMapper.reader(ImageRepository.class).readValue(json);
        }
        if (Objects.equal((Object)"Config", (Object)kind) || Objects.equal((Object)"List", (Object)kind)) {
            return KubernetesHelper.loadList(json);
        }
        return defaultValue;
    }

    protected static Config loadList(byte[] data) throws IOException {
        Config config = new Config();
        ArrayList<Object> itemList = new ArrayList<Object>();
        config.setItems(itemList);
        JsonNode jsonNode = objectMapper.readTree(data);
        JsonNode items = jsonNode.get("items");
        for (JsonNode item : items) {
            JsonNode kindObject;
            if (item == null || (kindObject = item.get("kind")) == null || !kindObject.isTextual()) continue;
            String kind = kindObject.asText();
            String json = KubernetesHelper.toJson(item);
            byte[] bytes = json.getBytes();
            Object entity = KubernetesHelper.loadEntity(bytes, kind, null);
            if (entity == null) continue;
            itemList.add(entity);
        }
        return config;
    }

    public static Object getEntity(JsonNode item) throws IOException {
        String kind;
        JsonNode kindObject;
        if (item != null && (kindObject = item.get("kind")) != null && kindObject.isTextual() && (kind = kindObject.asText()) != null) {
            String json = KubernetesHelper.toJson(item);
            byte[] bytes = json.getBytes();
            Object entity = KubernetesHelper.loadEntity(bytes, kind, null);
            return entity;
        }
        return null;
    }

    public static List<Object> getEntities(Config config) throws IOException {
        return config.getItems();
    }

    public static void saveJson(File json, Object object) throws IOException {
        objectMapper.writer().writeValue(json, object);
    }

    public static Map<String, Pod> toPodMap(PodList podSchema) {
        return KubernetesHelper.toFilteredPodMap(podSchema, (Filter<Pod>)Filters.trueFilter());
    }

    protected static Map<String, Pod> toFilteredPodMap(PodList podSchema, Filter<Pod> filter) {
        List list = podSchema != null ? podSchema.getItems() : null;
        List filteredList = Filters.filter((Iterable)list, filter);
        return KubernetesHelper.toPodMap(filteredList);
    }

    public static Map<String, Pod> toPodMap(List<Pod> pods) {
        List list = Lists.notNullList(pods);
        HashMap<String, Pod> answer = new HashMap<String, Pod>();
        for (Pod pod : list) {
            String id = KubernetesHelper.getId(pod);
            if (!Strings.isNotBlank((String)id)) continue;
            answer.put(id, pod);
        }
        return answer;
    }

    public static Map<String, Service> toServiceMap(ServiceList serviceSchema) {
        return KubernetesHelper.toServiceMap(serviceSchema != null ? serviceSchema.getItems() : null);
    }

    public static Map<String, Service> toServiceMap(List<Service> services) {
        List list = Lists.notNullList(services);
        HashMap<String, Service> answer = new HashMap<String, Service>();
        for (Service service : list) {
            String id = KubernetesHelper.getId(service);
            if (!Strings.isNotBlank((String)id)) continue;
            answer.put(id, service);
        }
        return answer;
    }

    public static Map<String, Service> toFilteredServiceMap(ServiceList serviceList, Filter<Service> filter) {
        List list = serviceList != null ? serviceList.getItems() : null;
        List filteredList = Filters.filter((Iterable)list, filter);
        return KubernetesHelper.toServiceMap(filteredList);
    }

    public static Map<String, ReplicationController> toReplicationControllerMap(ReplicationControllerList replicationControllerSchema) {
        Filter<ReplicationController> filter = KubernetesHelper.createReplicationControllerFilter((String)null);
        return KubernetesHelper.toFilteredReplicationControllerMap(replicationControllerSchema, filter);
    }

    protected static Map<String, ReplicationController> toFilteredReplicationControllerMap(ReplicationControllerList replicationControllerSchema, Filter<ReplicationController> filter) {
        List list = replicationControllerSchema != null ? replicationControllerSchema.getItems() : null;
        List filteredList = Filters.filter((Iterable)list, filter);
        return KubernetesHelper.toReplicationControllerMap(filteredList);
    }

    public static Map<String, ReplicationController> toReplicationControllerMap(List<ReplicationController> replicationControllers) {
        List list = Lists.notNullList(replicationControllers);
        HashMap<String, ReplicationController> answer = new HashMap<String, ReplicationController>();
        for (ReplicationController replicationControllerSchema : list) {
            String id = KubernetesHelper.getId(replicationControllerSchema);
            if (!Strings.isNotBlank((String)id)) continue;
            answer.put(id, replicationControllerSchema);
        }
        return answer;
    }

    public static Map<String, Pod> getPodMap(Kubernetes kubernetes) {
        return KubernetesHelper.getPodMap(kubernetes, "");
    }

    public static Map<String, Pod> getPodMap(Kubernetes kubernetes, String namespace) {
        return KubernetesHelper.toPodMap(kubernetes.getPods(namespace));
    }

    public static Map<String, Pod> getSelectedPodMap(Kubernetes kubernetes, String selector) {
        return KubernetesHelper.getSelectedPodMap(kubernetes, "", selector);
    }

    public static Map<String, Pod> getSelectedPodMap(Kubernetes kubernetes, String namespace, String selector) {
        Filter<Pod> filter = KubernetesHelper.createPodFilter(selector);
        return KubernetesHelper.getFilteredPodMap(kubernetes, namespace, filter);
    }

    public static Map<String, Pod> getFilteredPodMap(Kubernetes kubernetes, Filter<Pod> filter) {
        return KubernetesHelper.getFilteredPodMap(kubernetes, "", filter);
    }

    public static Map<String, Pod> getFilteredPodMap(Kubernetes kubernetes, String namespace, Filter<Pod> filter) {
        PodList podSchema = kubernetes.getPods(namespace);
        return KubernetesHelper.toFilteredPodMap(podSchema, filter);
    }

    public static Map<String, Service> getServiceMap(Kubernetes kubernetes) {
        return KubernetesHelper.getServiceMap(kubernetes, "");
    }

    public static Map<String, Service> getServiceMap(Kubernetes kubernetes, String namespace) {
        return KubernetesHelper.toServiceMap(kubernetes.getServices(namespace));
    }

    public static Map<String, ReplicationController> getReplicationControllerMap(Kubernetes kubernetes) {
        return KubernetesHelper.getReplicationControllerMap(kubernetes, "");
    }

    public static Map<String, ReplicationController> getReplicationControllerMap(Kubernetes kubernetes, String namespace) {
        return KubernetesHelper.toReplicationControllerMap(kubernetes.getReplicationControllers(namespace));
    }

    public static Map<String, ReplicationController> getSelectedReplicationControllerMap(Kubernetes kubernetes, String selector) {
        return KubernetesHelper.getSelectedReplicationControllerMap(kubernetes, "", selector);
    }

    public static Map<String, ReplicationController> getSelectedReplicationControllerMap(Kubernetes kubernetes, String namespace, String selector) {
        Filter<ReplicationController> filter = KubernetesHelper.createReplicationControllerFilter(selector);
        return KubernetesHelper.toFilteredReplicationControllerMap(kubernetes.getReplicationControllers(namespace), filter);
    }

    public static void removeEmptyPods(PodList podSchema) {
        List list = Lists.notNullList((List)podSchema.getItems());
        ArrayList<Pod> removeItems = new ArrayList<Pod>();
        for (Pod pod : list) {
            if (!StringUtils.isEmpty((String)KubernetesHelper.getId(pod))) continue;
            removeItems.add(pod);
        }
        list.removeAll(removeItems);
    }

    public static String containerNameToPodId(String containerName) {
        return containerName;
    }

    public static String toLabelsString(Map<String, String> labelMap) {
        StringBuilder buffer = new StringBuilder();
        if (labelMap != null) {
            Set<Map.Entry<String, String>> entries = labelMap.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                if (buffer.length() > 0) {
                    buffer.append(",");
                }
                buffer.append(entry.getKey());
                buffer.append("=");
                buffer.append(entry.getValue());
            }
        }
        return buffer.toString();
    }

    public static Map<String, String> toLabelsMap(String labels) {
        String[] elements;
        HashMap<String, String> map = new HashMap<String, String>();
        if (labels != null && !labels.isEmpty() && (elements = labels.split(",")).length > 0) {
            for (String str : elements) {
                String[] keyValue = str.split("=");
                if (keyValue.length != 2) continue;
                String key = keyValue[0];
                String value = keyValue[1];
                if (key == null || value == null) continue;
                map.put(key.trim(), value.trim());
            }
        }
        return map;
    }

    public static Filter<Pod> createPodFilter(final String textFilter) {
        if (Strings.isNullOrBlank((String)textFilter)) {
            return Filters.trueFilter();
        }
        return new Filter<Pod>(){

            public String toString() {
                return "PodFilter(" + textFilter + ")";
            }

            public boolean matches(Pod entity) {
                return KubernetesHelper.filterMatchesIdOrLabels(textFilter, KubernetesHelper.getId(entity), entity.getLabels());
            }
        };
    }

    public static Filter<Pod> createPodFilter(final Map<String, String> labelSelector) {
        if (labelSelector == null || labelSelector.isEmpty()) {
            return Filters.trueFilter();
        }
        return new Filter<Pod>(){

            public String toString() {
                return "PodFilter(" + labelSelector + ")";
            }

            public boolean matches(Pod entity) {
                return KubernetesHelper.filterLabels(labelSelector, entity.getLabels());
            }
        };
    }

    public static Filter<Pod> createPodAnnotationFilter(final Map<String, String> annotationSelector) {
        if (annotationSelector == null || annotationSelector.isEmpty()) {
            return Filters.trueFilter();
        }
        return new Filter<Pod>(){

            public String toString() {
                return "PodAnnotationFilter(" + annotationSelector + ")";
            }

            public boolean matches(Pod entity) {
                return KubernetesHelper.filterLabels(annotationSelector, entity.getAnnotations());
            }
        };
    }

    public static Filter<Service> createServiceFilter(final String textFilter) {
        if (Strings.isNullOrBlank((String)textFilter)) {
            return Filters.trueFilter();
        }
        return new Filter<Service>(){

            public String toString() {
                return "ServiceFilter(" + textFilter + ")";
            }

            public boolean matches(Service entity) {
                return KubernetesHelper.filterMatchesIdOrLabels(textFilter, KubernetesHelper.getId(entity), entity.getLabels());
            }
        };
    }

    public static Filter<Service> createNamespaceServiceFilter(final String namespace) {
        if (Strings.isNullOrBlank((String)namespace)) {
            return Filters.trueFilter();
        }
        return new Filter<Service>(){

            public String toString() {
                return "NamespaceServiceFilter(" + namespace + ")";
            }

            public boolean matches(Service entity) {
                return Objects.equal((Object)namespace, (Object)entity.getNamespace());
            }
        };
    }

    public static Filter<Service> createServiceFilter(final Map<String, String> labelSelector) {
        if (labelSelector == null || labelSelector.isEmpty()) {
            return Filters.trueFilter();
        }
        return new Filter<Service>(){

            public String toString() {
                return "ServiceFilter(" + labelSelector + ")";
            }

            public boolean matches(Service entity) {
                return KubernetesHelper.filterLabels(labelSelector, entity.getLabels());
            }
        };
    }

    public static Filter<ReplicationController> createReplicationControllerFilter(final String textFilter) {
        if (Strings.isNullOrBlank((String)textFilter)) {
            return Filters.trueFilter();
        }
        return new Filter<ReplicationController>(){

            public String toString() {
                return "ReplicationControllerFilter(" + textFilter + ")";
            }

            public boolean matches(ReplicationController entity) {
                return KubernetesHelper.filterMatchesIdOrLabels(textFilter, KubernetesHelper.getId(entity), entity.getLabels());
            }
        };
    }

    public static Filter<ReplicationController> createReplicationControllerFilter(final Map<String, String> labelSelector) {
        if (labelSelector == null || labelSelector.isEmpty()) {
            return Filters.trueFilter();
        }
        return new Filter<ReplicationController>(){

            public String toString() {
                return "ReplicationControllerFilter(" + labelSelector + ")";
            }

            public boolean matches(ReplicationController entity) {
                return KubernetesHelper.filterLabels(labelSelector, entity.getLabels());
            }
        };
    }

    public static boolean filterMatchesIdOrLabels(String textFilter, String id, Map<String, String> labels) {
        Map<String, String> selectorMap;
        boolean result;
        String text = KubernetesHelper.toLabelsString(labels);
        boolean bl = result = text != null && text.contains(textFilter) || id != null && id.contains(textFilter);
        if (!(result || (selectorMap = KubernetesHelper.toLabelsMap(textFilter)).isEmpty() || labels == null || labels.isEmpty())) {
            result = true;
            for (Map.Entry<String, String> entry : selectorMap.entrySet()) {
                String value = labels.get(entry.getKey());
                if (value != null && value.matches(entry.getValue())) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public static boolean filterLabels(Map<String, String> filterLabels, Map<String, String> labels) {
        if (labels == null) {
            return false;
        }
        Set<Map.Entry<String, String>> entries = filterLabels.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String actualValue;
            String key = entry.getKey();
            String expectedValue = entry.getValue();
            if (Objects.equal((Object)expectedValue, (Object)(actualValue = labels.get(key)))) continue;
            return false;
        }
        return true;
    }

    public static String toPositiveNonZeroText(Integer port) {
        int value;
        if (port != null && (value = port.intValue()) > 0) {
            return "" + value;
        }
        return "";
    }

    public static List<Container> getContainers(Pod pod) {
        if (pod != null) {
            PodState desiredState = pod.getDesiredState();
            return KubernetesHelper.getContainers(desiredState);
        }
        return Collections.EMPTY_LIST;
    }

    public static List<Container> getContainers(ReplicationController replicationController) {
        if (replicationController != null) {
            ReplicationControllerState desiredState = replicationController.getDesiredState();
            return KubernetesHelper.getContainers(desiredState);
        }
        return Collections.EMPTY_LIST;
    }

    public static List<Container> getContainers(ReplicationControllerState desiredState) {
        if (desiredState != null) {
            PodTemplate podTemplate = desiredState.getPodTemplate();
            return KubernetesHelper.getContainers(podTemplate);
        }
        return Collections.EMPTY_LIST;
    }

    public static List<Container> getContainers(PodTemplate podTemplate) {
        if (podTemplate != null) {
            PodState desiredState = podTemplate.getDesiredState();
            return KubernetesHelper.getContainers(desiredState);
        }
        return Collections.EMPTY_LIST;
    }

    public static List<Container> getContainers(ContainerManifest manifest) {
        List containers;
        if (manifest != null && (containers = manifest.getContainers()) != null) {
            return containers;
        }
        return Collections.EMPTY_LIST;
    }

    public static List<Container> getCurrentContainers(ReplicationController replicationController) {
        if (replicationController != null) {
            // empty if block
        }
        return Collections.EMPTY_LIST;
    }

    public static List<Container> getContainers(PodState desiredState) {
        List containers;
        ContainerManifest manifest;
        if (desiredState != null && (manifest = desiredState.getManifest()) != null && (containers = manifest.getContainers()) != null) {
            return containers;
        }
        return Collections.EMPTY_LIST;
    }

    public static Map<String, ContainerStatus> getCurrentContainers(Pod pod) {
        if (pod != null) {
            PodState currentState = pod.getCurrentState();
            return KubernetesHelper.getCurrentContainers(currentState);
        }
        return Collections.EMPTY_MAP;
    }

    public static Map<String, ContainerStatus> getCurrentContainers(PodState currentState) {
        Map info;
        if (currentState != null && (info = currentState.getInfo()) != null) {
            return info;
        }
        return Collections.EMPTY_MAP;
    }

    public static String getHost(Pod pod) {
        PodState currentState;
        if (pod != null && (currentState = pod.getCurrentState()) != null) {
            return currentState.getHost();
        }
        return null;
    }

    public static int getContainerPort(Service service) {
        int answer = -1;
        String id = KubernetesHelper.getId(service);
        Service spec = service;
        if (spec != null) {
            IntOrString containerPort = spec.getContainerPort();
            Objects.notNull((Object)containerPort, (String)("containerPort for service " + id));
            Integer intValue = containerPort.getIntVal();
            if (intValue != null) {
                answer = intValue;
            } else {
                String containerPortText = containerPort.getStrVal();
                if (Strings.isNullOrBlank((String)containerPortText)) {
                    throw new IllegalArgumentException("No containerPort for service " + id);
                }
                try {
                    answer = Integer.parseInt(containerPortText);
                }
                catch (NumberFormatException e) {
                    throw new IllegalStateException("Invalid containerPort expression " + containerPortText + " for service " + id + ". " + e, e);
                }
            }
        }
        if (answer <= 0) {
            throw new IllegalArgumentException("Invalid port number for service " + id + ". " + answer);
        }
        return answer;
    }

    public static String getContainerPortString(Service service) {
        String answer = null;
        String id = KubernetesHelper.getId(service);
        Service spec = service;
        if (spec != null) {
            IntOrString containerPort = spec.getContainerPort();
            Objects.notNull((Object)containerPort, (String)("containerPort for service " + id));
            String strValue = containerPort.getStrVal();
            if (strValue != null) {
                answer = strValue;
            } else {
                Integer containerPortInt = containerPort.getIntVal();
                if (containerPortInt == null) {
                    throw new IllegalArgumentException("No containerPort for service " + id);
                }
                answer = containerPortInt.toString();
            }
        }
        if (answer == null) {
            throw new IllegalArgumentException("Invalid port number for service " + id + ". " + answer);
        }
        return answer;
    }

    public static JsonNode combineJson(Object ... objects) throws IOException {
        ArrayNode itemArray;
        JsonNode config = KubernetesHelper.findOrCreateConfig(objects);
        JsonNode items = config.get("items");
        if (items instanceof ArrayNode) {
            itemArray = (ArrayNode)items;
        } else {
            itemArray = new ArrayNode(KubernetesHelper.createNodeFactory());
            if (config instanceof ObjectNode) {
                ObjectNode objectNode = (ObjectNode)config;
                objectNode.set("items", (JsonNode)itemArray);
            } else {
                throw new IllegalArgumentException("config " + config + " is not a ObjectNode");
            }
        }
        for (Object object : objects) {
            if (object == config) continue;
            KubernetesHelper.addObjectsToItemArray(itemArray, object);
        }
        return config;
    }

    protected static void addObjectsToItemArray(ArrayNode itemArray, Object object) throws IOException {
        JsonNode node = KubernetesHelper.toJsonNode(object);
        JsonNode items = node.get("items");
        if (items != null && items.isArray()) {
            Iterator iter = items.iterator();
            for (JsonNode item : items) {
                itemArray.add(item);
            }
        } else {
            itemArray.add(node);
        }
    }

    protected static JsonNodeFactory createNodeFactory() {
        return new JsonNodeFactory(false);
    }

    protected static JsonNode findOrCreateConfig(Object[] objects) {
        for (Object object : objects) {
            JsonNode jsonNode;
            JsonNode items;
            if (!(object instanceof JsonNode) || (items = (jsonNode = (JsonNode)object).get("items")) == null || !items.isArray()) continue;
            return jsonNode;
        }
        JsonNodeFactory factory = KubernetesHelper.createNodeFactory();
        ObjectNode config = factory.objectNode();
        config.set("apiVersion", (JsonNode)factory.textNode(defaultApiVersion));
        config.set("kind", (JsonNode)factory.textNode("List"));
        config.set("items", (JsonNode)factory.arrayNode());
        return config;
    }

    public static JsonNode toJsonNode(Object object) throws IOException {
        if (object instanceof JsonNode) {
            return (JsonNode)object;
        }
        if (object == null) {
            return null;
        }
        String json = KubernetesHelper.toJson(object);
        return objectMapper.reader().readTree(json);
    }

    public static String getServiceURL(Service service) {
        String portalIP;
        Service spec;
        if (service != null && (spec = service) != null && (portalIP = spec.getPortalIP()) != null) {
            Integer port = spec.getPort();
            if (port != null && port > 0) {
                portalIP = portalIP + ":" + port;
            }
            String protocol = "http://";
            if (KubernetesHelper.isServiceSsl(spec.getPortalIP(), port, Boolean.valueOf(System.getenv("KUBERNETES_TRUST_CERT")))) {
                protocol = "https://";
            }
            return protocol + portalIP;
        }
        return null;
    }

    public static String serviceToHost(String id) {
        return Systems.getEnvVarOrSystemProperty((String)KubernetesHelper.toEnvVariable(id + HOST_SUFFIX), (String)"");
    }

    public static String serviceToPort(String id) {
        return Systems.getEnvVarOrSystemProperty((String)KubernetesHelper.toEnvVariable(id + PORT_SUFFIX), (String)"");
    }

    public static String serviceToProtocol(String id, String servicePort) {
        return Systems.getEnvVarOrSystemProperty((String)KubernetesHelper.toEnvVariable(id + PORT_SUFFIX + "_" + servicePort + PROTO_SUFFIX), (String)DEFAULT_PROTO);
    }

    public static String toEnvVariable(String str) {
        return str.toUpperCase().replaceAll("-", "_");
    }

    public static Port findContainerPort(Pod pod, Integer portNumber) {
        List<Container> containers = KubernetesHelper.getContainers(pod);
        for (Container container : containers) {
            List ports = container.getPorts();
            for (Port port : ports) {
                if (!Objects.equal((Object)portNumber, (Object)port.getContainerPort())) continue;
                return port;
            }
        }
        return null;
    }

    public static Port findContainerPortByName(Pod pod, String name) {
        List<Container> containers = KubernetesHelper.getContainers(pod);
        for (Container container : containers) {
            List ports = container.getPorts();
            for (Port port : ports) {
                if (!Objects.equal((Object)name, (Object)port.getName())) continue;
                return port;
            }
        }
        return null;
    }

    public static Port findContainerPortByNumberOrName(Pod pod, String numberOrName) {
        Integer portNumber = KubernetesHelper.toOptionalNumber(numberOrName);
        if (portNumber != null) {
            return KubernetesHelper.findContainerPort(pod, portNumber);
        }
        return KubernetesHelper.findContainerPortByName(pod, numberOrName);
    }

    protected static Integer toOptionalNumber(String text) {
        if (Strings.isNotBlank((String)text)) {
            try {
                return Integer.parseInt(text);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static PodState getPodState(ReplicationController replicationController) {
        if (replicationController != null) {
            return KubernetesHelper.getPodState(replicationController.getDesiredState());
        }
        return null;
    }

    public static PodState getPodState(ReplicationControllerState desiredState) {
        PodTemplate podTemplate;
        PodState podTemplatePodState = null;
        if (desiredState != null && (podTemplate = desiredState.getPodTemplate()) != null) {
            podTemplatePodState = podTemplate.getDesiredState();
        }
        return podTemplatePodState;
    }

    public static PodStatus getPodStatus(Pod pod) {
        String text = KubernetesHelper.getPodStatusText(pod);
        if (Strings.isNotBlank((String)text)) {
            if ((text = text.toLowerCase()).startsWith("run")) {
                return PodStatus.OK;
            }
            if (text.startsWith("wait")) {
                return PodStatus.WAIT;
            }
            return PodStatus.ERROR;
        }
        return PodStatus.WAIT;
    }

    public static boolean isPodRunning(Pod pod) {
        PodStatus status = KubernetesHelper.getPodStatus(pod);
        return Objects.equal((Object)((Object)status), (Object)((Object)PodStatus.OK));
    }

    public static String getPodStatusText(Pod pod) {
        PodState currentState;
        if (pod != null && (currentState = pod.getCurrentState()) != null) {
            return currentState.getStatus();
        }
        return null;
    }

    public static List<Pod> getPodsForReplicationController(ReplicationController replicationController, Iterable<Pod> pods) {
        PodState podTemplatePodState = KubernetesHelper.getPodState(replicationController);
        if (podTemplatePodState == null) {
            LOG.warn("Cannot instantiate replication controller: " + KubernetesHelper.getId(replicationController) + " due to missing PodTemplate.PodState!");
        } else {
            ReplicationControllerState desiredState = replicationController.getDesiredState();
            if (desiredState != null) {
                Map replicaSelector = desiredState.getReplicaSelector();
                Filter<Pod> podFilter = KubernetesHelper.createPodFilter(replicaSelector);
                return Filters.filter(pods, podFilter);
            }
        }
        return Collections.EMPTY_LIST;
    }

    public static List<Pod> getPodsForService(Service service, Iterable<Pod> pods) {
        Map<String, String> selector = KubernetesHelper.getSelector(service);
        Filter<Pod> podFilter = KubernetesHelper.createPodFilter(selector);
        return Filters.filter(pods, podFilter);
    }

    public static Set<String> lookupServiceInDns(String serviceName) throws IllegalArgumentException, UnknownHostException {
        try {
            Lookup l = new Lookup(serviceName);
            Record[] records = l.run();
            if (l.getResult() == 0) {
                HashSet<String> endpointAddresses = new HashSet<String>(records.length);
                for (int i = 0; i < records.length; ++i) {
                    ARecord aRecord = (ARecord)records[i];
                    endpointAddresses.add(aRecord.getAddress().getHostAddress());
                }
                return endpointAddresses;
            }
            LOG.warn("Lookup {} result: {}", (Object)serviceName, (Object)l.getErrorString());
        }
        catch (TextParseException e) {
            LOG.error("Unparseable service name: {}", (Object)serviceName, (Object)e);
        }
        catch (ClassCastException e) {
            LOG.error("Invalid response from DNS server - should have been A records", (Throwable)e);
        }
        return Collections.EMPTY_SET;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isServiceSsl(String host, int port, boolean trustAllCerts) {
        block11: {
            boolean bl;
            SSLSocketFactory sslsocketfactory = null;
            sslsocketfactory = trustAllCerts ? TrustEverythingSSLTrustManager.getTrustingSSLSocketFactory() : (SSLSocketFactory)SSLSocketFactory.getDefault();
            Socket socket = sslsocketfactory.createSocket();
            socket.connect(new InetSocketAddress(host, port), 1000);
            try {
                InputStream in = socket.getInputStream();
                OutputStream out = socket.getOutputStream();
                out.write(1);
                while (in.available() > 0) {
                    System.out.print(in.read());
                }
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    socket.close();
                    throw throwable;
                }
                catch (SSLHandshakeException e) {
                    LOG.error("SSL handshake failed - this probably means that you need to trust the kubernetes root SSL certificate or set the environment variable KUBERNETES_TRUST_CERT", (Throwable)e);
                    break block11;
                }
                catch (SSLProtocolException e) {
                    LOG.error("SSL protocol error", (Throwable)e);
                    break block11;
                }
                catch (SSLKeyException e) {
                    LOG.error("Bad SSL key", (Throwable)e);
                    break block11;
                }
                catch (SSLPeerUnverifiedException e) {
                    LOG.error("Could not verify server", (Throwable)e);
                    break block11;
                }
                catch (SSLException e) {
                    LOG.debug("Address does not appear to be SSL-enabled - falling back to http", (Throwable)e);
                    break block11;
                }
                catch (IOException e) {
                    LOG.debug("Failed to validate service", (Throwable)e);
                }
            }
            socket.close();
            return bl;
        }
        return false;
    }

    public static String validateKubernetesId(String currentValue, String description) throws IllegalArgumentException {
        if (Strings.isNullOrBlank((String)currentValue)) {
            throw new IllegalArgumentException("No " + description + " is specified!");
        }
        int size = currentValue.length();
        for (int i = 0; i < size; ++i) {
            char ch = currentValue.charAt(i);
            if (!Character.isUpperCase(ch)) continue;
            throw new IllegalArgumentException("Invalid upper case letter '" + Character.valueOf(ch) + "' at index " + i + " for " + description + " value: " + currentValue);
        }
        return currentValue;
    }

    public static Date parseDate(String text) {
        try {
            return dateTimeFormat.parse(text);
        }
        catch (ParseException e) {
            LOG.warn("Failed to parse date: " + text + ". Reason: " + e);
            return null;
        }
    }
}

