/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.mbeans;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.fabric8.kubernetes.api.KubernetesClient;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.mbeans.AppSummaryDTO;
import io.fabric8.kubernetes.api.mbeans.AppViewDetails;
import io.fabric8.kubernetes.api.mbeans.AppViewMXBean;
import io.fabric8.kubernetes.api.mbeans.AppViewSnapshot;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.utils.JMXUtils;
import io.fabric8.utils.Objects;
import io.fabric8.utils.Strings;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppView
implements AppViewMXBean {
    private static final transient Logger LOG = LoggerFactory.getLogger(AppView.class);
    public static ObjectName OBJECT_NAME;
    public static ObjectName KUBERNETES_OBJECT_NAME;
    private final AtomicReference<AppViewSnapshot> snapshotCache = new AtomicReference();
    private long pollPeriod = 3000L;
    private Timer timer = new Timer();
    private MBeanServer mbeanServer;
    private KubernetesClient kubernetes = new KubernetesClient();
    private TimerTask task = new TimerTask(){

        @Override
        public void run() {
            AppView.this.refreshData();
        }
    };

    public void init() {
        if (this.pollPeriod > 0L) {
            this.timer.schedule(this.task, this.pollPeriod, this.pollPeriod);
            JMXUtils.registerMBean((Object)this, (ObjectName)OBJECT_NAME);
        }
    }

    public void destroy() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        JMXUtils.unregisterMBean((ObjectName)OBJECT_NAME);
    }

    @Override
    public String getKubernetesAddress() {
        return this.kubernetes.getAddress();
    }

    public long getPollPeriod() {
        return this.pollPeriod;
    }

    public void setPollPeriod(long pollPeriod) {
        this.pollPeriod = pollPeriod;
    }

    public AppViewSnapshot getSnapshot() {
        return this.snapshotCache.get();
    }

    public List<AppSummaryDTO> getAppSummaries() {
        ArrayList<AppSummaryDTO> answer = new ArrayList<AppSummaryDTO>();
        AppViewSnapshot snapshot = this.getSnapshot();
        if (snapshot != null) {
            List<AppViewDetails> apps = snapshot.getApps();
            for (AppViewDetails app : apps) {
                AppSummaryDTO summary = app.getSummary();
                if (summary == null) continue;
                answer.add(summary);
            }
        }
        return answer;
    }

    @Override
    public String findAppSummariesJson() throws JsonProcessingException {
        return KubernetesHelper.toJson(this.getAppSummaries());
    }

    protected void refreshData() {
        try {
            AppViewSnapshot snapshot = this.createSnapshot();
            if (snapshot != null) {
                this.snapshotCache.set(snapshot);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to create snapshot: " + e, (Throwable)e);
        }
    }

    public AppViewSnapshot createSnapshot() {
        AppViewDetails dto;
        String appPath;
        Map<String, Service> servicesMap = KubernetesHelper.getServiceMap(this.kubernetes);
        Map<String, ReplicationController> controllerMap = KubernetesHelper.getReplicationControllerMap(this.kubernetes);
        Map<String, Pod> podMap = KubernetesHelper.getPodMap(this.kubernetes);
        AppViewSnapshot snapshot = new AppViewSnapshot(servicesMap, controllerMap, podMap);
        for (Service service : servicesMap.values()) {
            appPath = this.getAppPath(KubernetesHelper.getId(service));
            if (appPath == null) continue;
            dto = snapshot.getOrCreateAppView(appPath, service.getNamespace());
            dto.addService(service);
        }
        for (ReplicationController controller : controllerMap.values()) {
            appPath = this.getAppPath(KubernetesHelper.getId(controller));
            if (appPath == null) continue;
            dto = snapshot.getOrCreateAppView(appPath, controller.getNamespace());
            dto.addController(controller);
        }
        HashSet<ReplicationController> remainingControllers = new HashSet<ReplicationController>(controllerMap.values());
        List<AppViewDetails> appViews = snapshot.getApps();
        for (AppViewDetails appView : appViews) {
            remainingControllers.removeAll(appView.getControllers().values());
        }
        for (ReplicationController controller : remainingControllers) {
            AppViewDetails dto2 = snapshot.createApp(controller.getNamespace());
            dto2.addController(controller);
        }
        HashSet<Pod> remainingPods = new HashSet<Pod>(podMap.values());
        for (AppViewDetails appView : appViews) {
            remainingPods.removeAll(appView.getPods().values());
        }
        for (Pod pod : remainingPods) {
            AppViewDetails dto3 = snapshot.createApp(pod.getNamespace());
            dto3.addPod(pod);
        }
        this.snapshotCache.set(snapshot);
        return snapshot;
    }

    protected String getAppPath(String serviceId) {
        if (Strings.isNullOrBlank((String)serviceId)) {
            return null;
        }
        MBeanServer beanServer = this.getMBeanServer();
        Objects.notNull((Object)beanServer, (String)"MBeanServer");
        if (!beanServer.isRegistered(KUBERNETES_OBJECT_NAME)) {
            LOG.warn("No MBean is available for: " + KUBERNETES_OBJECT_NAME);
            return null;
        }
        String branch = "master";
        Object[] params = new Object[]{branch, serviceId};
        String[] signature = new String[]{String.class.getName(), String.class.getName()};
        if (LOG.isDebugEnabled()) {
            LOG.debug("About to invoke " + KUBERNETES_OBJECT_NAME + " appPath" + Arrays.asList(params) + " signature" + Arrays.asList(signature));
        }
        try {
            Object answer = beanServer.invoke(KUBERNETES_OBJECT_NAME, "appPath", params, signature);
            if (answer != null) {
                return answer.toString();
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to invoke " + KUBERNETES_OBJECT_NAME + " appPath" + Arrays.asList(params) + ". " + e, (Throwable)e);
        }
        return null;
    }

    public MBeanServer getMBeanServer() {
        if (this.mbeanServer == null) {
            this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        return this.mbeanServer;
    }

    public void setMBeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    static {
        try {
            OBJECT_NAME = new ObjectName("io.fabric8:type=AppView");
        }
        catch (MalformedObjectNameException e) {
            // empty catch block
        }
        try {
            KUBERNETES_OBJECT_NAME = new ObjectName("io.fabric8:type=Kubernetes");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
    }
}

