/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.mbeans;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.Service;
import java.util.Map;

public class AppServiceSummaryDTO {
    private final String id;
    private final String name;
    private final String namespace;
    private final String portalIP;
    private final Integer port;
    private final Map<String, String> labels;

    public AppServiceSummaryDTO(Service service) {
        this.id = KubernetesHelper.getId(service);
        this.name = KubernetesHelper.getName(service);
        this.namespace = service.getNamespace();
        this.portalIP = KubernetesHelper.getPortalIP(service);
        this.port = KubernetesHelper.getPort(service);
        this.labels = service.getLabels();
    }

    public String toString() {
        return "AppServiceSummaryDTO{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", namespace='" + this.namespace + '\'' + '}';
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getPortalIP() {
        return this.portalIP;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }
}

