/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.mbeans;

import io.fabric8.kubernetes.api.mbeans.AppPodSummaryDTO;
import io.fabric8.kubernetes.api.mbeans.AppReplicationControllerSummaryDTO;
import io.fabric8.kubernetes.api.mbeans.AppServiceSummaryDTO;
import io.fabric8.kubernetes.api.mbeans.AppSummaryDTO;
import io.fabric8.kubernetes.api.mbeans.AppViewSnapshot;
import io.fabric8.kubernetes.api.model.PodSchema;
import io.fabric8.kubernetes.api.model.ReplicationControllerSchema;
import io.fabric8.kubernetes.api.model.ServiceSchema;
import io.fabric8.utils.Strings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AppViewDetails {
    private final AppViewSnapshot snapshot;
    private final String appPath;
    private final String namespace;
    private final Map<String, ServiceSchema> services = new HashMap<String, ServiceSchema>();
    private final Map<String, ReplicationControllerSchema> controllers = new HashMap<String, ReplicationControllerSchema>();
    private final Map<String, PodSchema> pods = new HashMap<String, PodSchema>();

    public AppViewDetails(AppViewSnapshot snapshot, String appPath, String namespace) {
        this.snapshot = snapshot;
        this.appPath = appPath;
        this.namespace = namespace;
    }

    public AppViewSnapshot getSnapshot() {
        return this.snapshot;
    }

    public String getAppPath() {
        return this.appPath;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Map<String, ServiceSchema> getServices() {
        return this.services;
    }

    public Map<String, ReplicationControllerSchema> getControllers() {
        return this.controllers;
    }

    public Map<String, PodSchema> getPods() {
        return this.pods;
    }

    public void addService(ServiceSchema service) {
        String id = service.getId();
        if (Strings.isNotBlank((String)id)) {
            this.services.put(id, service);
        }
    }

    public void addController(ReplicationControllerSchema controller) {
        String id = controller.getId();
        if (Strings.isNotBlank((String)id)) {
            this.controllers.put(id, controller);
            List<PodSchema> pods = this.snapshot.podsForReplicationController(controller);
            for (PodSchema pod : pods) {
                this.addPod(pod);
            }
        }
    }

    public void addPod(PodSchema pod) {
        String id = pod.getId();
        if (Strings.isNotBlank((String)id)) {
            this.pods.put(id, pod);
        }
    }

    public AppSummaryDTO getSummary() {
        AppSummaryDTO answer = new AppSummaryDTO(this.appPath, this.namespace);
        for (ServiceSchema service : this.getServices().values()) {
            answer.addServiceSummary(new AppServiceSummaryDTO(service));
        }
        for (ReplicationControllerSchema controller : this.getControllers().values()) {
            answer.addReplicationControllerSummary(new AppReplicationControllerSummaryDTO(controller));
        }
        for (PodSchema pod : this.getPods().values()) {
            answer.addPodSummary(new AppPodSummaryDTO(pod));
        }
        return answer;
    }
}

