/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(using=Deserializer.class)
@JsonSerialize(using=Serializer.class)
@JsonPropertyOrder(value={"stringValue", "intValue"})
public class IntOrString {
    @JsonProperty(value="stringValue")
    private String stringValue;
    @JsonProperty(value="intValue")
    private Integer intValue;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @JsonProperty(value="stringValue")
    public String getStringValue() {
        return this.stringValue;
    }

    @JsonProperty(value="stringValue")
    public void setStringValue(String stringValue) {
        this.stringValue = stringValue;
    }

    @JsonProperty(value="intValue")
    public Integer getIntValue() {
        return this.intValue;
    }

    @JsonProperty(value="intValue")
    public void setIntValue(Integer intValue) {
        this.intValue = intValue;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public static class Deserializer
    extends JsonDeserializer<IntOrString> {
        public IntOrString deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ObjectCodec oc = jsonParser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jsonParser);
            IntOrString intOrString = new IntOrString();
            int asInt = node.asInt();
            if (asInt != 0) {
                intOrString.setIntValue(asInt);
            } else {
                intOrString.setStringValue(node.asText());
            }
            return intOrString;
        }
    }

    public static class Serializer
    extends JsonSerializer<IntOrString> {
        public void serialize(IntOrString value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            if (value != null) {
                Integer intValue = value.getIntValue();
                if (intValue != null) {
                    jgen.writeNumber(intValue.intValue());
                } else {
                    String stringValue = value.getStringValue();
                    if (stringValue != null) {
                        jgen.writeString(stringValue);
                    } else {
                        jgen.writeNull();
                    }
                }
            } else {
                jgen.writeNull();
            }
        }
    }
}

