/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api;

import com.fasterxml.jackson.databind.JsonNode;
import io.fabric8.kubernetes.api.KubernetesClient;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.PodSchema;
import io.fabric8.kubernetes.api.model.ReplicationControllerSchema;
import io.fabric8.kubernetes.api.model.ServiceSchema;
import io.fabric8.utils.Objects;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Controller {
    private static final transient Logger LOG = LoggerFactory.getLogger(Controller.class);
    private final KubernetesClient kubernetes;
    private Map<String, PodSchema> podMap = null;
    private Map<String, ReplicationControllerSchema> replicationControllerMap = null;
    private Map<String, ServiceSchema> serviceMap = null;

    public Controller() {
        this(new KubernetesClient());
    }

    public Controller(KubernetesClient kubernetes) {
        this.kubernetes = kubernetes;
    }

    public String applyJson(byte[] json) throws IOException {
        Object dto = KubernetesHelper.loadJson(json);
        this.apply(dto, "REST call");
        return "";
    }

    public String applyJson(String json) throws IOException {
        Object dto = KubernetesHelper.loadJson(json);
        this.apply(dto, "REST call");
        return "";
    }

    public String applyJson(File json) throws IOException {
        Object dto = KubernetesHelper.loadJson(json);
        this.apply(dto, "REST call");
        return "";
    }

    public String applyJson(InputStream json) throws IOException {
        Object dto = KubernetesHelper.loadJson(json);
        this.apply(dto, "REST call");
        return "";
    }

    public void apply(Object dto, String sourceName) {
        if (dto instanceof PodSchema) {
            this.applyPod((PodSchema)dto, sourceName);
        } else if (dto instanceof ReplicationControllerSchema) {
            this.applyReplicationController((ReplicationControllerSchema)dto, sourceName);
        } else if (dto instanceof ServiceSchema) {
            this.applyService((ServiceSchema)dto, sourceName);
        } else if (dto instanceof JsonNode) {
            JsonNode tree = (JsonNode)dto;
            JsonNode kindNode = tree.get("kind");
            if (kindNode != null) {
                String kind = kindNode.asText();
                if (Objects.equal((Object)"Config", (Object)kind)) {
                    this.applyConfig(tree, sourceName);
                } else if (Objects.equal((Object)"Template", (Object)kind)) {
                    this.applyTemplateConfig(tree, sourceName);
                } else {
                    LOG.warn("Unknown JSON type " + kindNode + ". JSON: " + tree);
                }
            } else {
                LOG.warn("No JSON kind for: " + tree);
            }
        } else {
            LOG.warn("Unknown Kublelet from " + sourceName + ". Object: " + dto);
        }
    }

    public void applyTemplateConfig(JsonNode entity, String sourceName) {
        try {
            this.kubernetes.createTemplate(entity);
        }
        catch (Exception e) {
            LOG.error("Failed to create controller from " + sourceName + ". " + e, (Throwable)e);
        }
    }

    public void applyConfig(JsonNode entity, String sourceName) {
        JsonNode items = entity.get("items");
        if (items != null) {
            for (JsonNode item : items) {
                String json = item.toString();
                System.out.println("Got item: " + json);
                Object dto = null;
                try {
                    dto = KubernetesHelper.loadJson(json);
                }
                catch (IOException e) {
                    LOG.error("Failed to process " + json + ". " + e, (Throwable)e);
                }
                if (dto == null) continue;
                this.apply(dto, sourceName);
            }
        }
    }

    public void applyService(ServiceSchema serviceSchema, String sourceName) {
        String id;
        ServiceSchema old;
        if (this.serviceMap == null) {
            this.serviceMap = KubernetesHelper.getServiceMap(this.kubernetes);
        }
        if (this.isRunning(old = this.serviceMap.get(id = serviceSchema.getId()))) {
            LOG.info("Updating a service from " + sourceName);
            try {
                String answer = this.kubernetes.updateService(id, serviceSchema);
                LOG.info("Updated service: " + answer);
            }
            catch (Exception e) {
                LOG.error("Failed to update controller from " + sourceName + ". " + e + ". " + serviceSchema, (Throwable)e);
            }
        } else {
            LOG.info("Creating a service from " + sourceName);
            try {
                String answer = this.kubernetes.createService(serviceSchema);
                LOG.info("Created service: " + answer);
            }
            catch (Exception e) {
                LOG.error("Failed to create controller from " + sourceName + ". " + e + ". " + serviceSchema, (Throwable)e);
            }
        }
    }

    public void applyReplicationController(ReplicationControllerSchema replicationControllerSchema, String sourceName) {
        String id;
        ReplicationControllerSchema old;
        if (this.replicationControllerMap == null) {
            this.replicationControllerMap = KubernetesHelper.getReplicationControllerMap(this.kubernetes);
        }
        if (this.isRunning(old = this.replicationControllerMap.get(id = replicationControllerSchema.getId()))) {
            LOG.info("Updating replicationController from " + sourceName);
            try {
                String answer = this.kubernetes.updateReplicationController(id, replicationControllerSchema);
                LOG.info("Updated replicationController: " + answer);
            }
            catch (Exception e) {
                LOG.error("Failed to update replicationController from " + sourceName + ". " + e + ". " + replicationControllerSchema, (Throwable)e);
            }
        } else {
            LOG.info("Creating a replicationController from " + sourceName);
            try {
                String answer = this.kubernetes.createReplicationController(replicationControllerSchema);
                LOG.info("Created replicationController: " + answer);
            }
            catch (Exception e) {
                LOG.error("Failed to create replicationController from " + sourceName + ". " + e + ". " + replicationControllerSchema, (Throwable)e);
            }
        }
    }

    public void applyPod(PodSchema podSchema, String sourceName) {
        String id;
        PodSchema old;
        if (this.podMap == null) {
            this.podMap = KubernetesHelper.getPodMap(this.kubernetes);
        }
        if (this.isRunning(old = this.podMap.get(id = podSchema.getId()))) {
            LOG.info("Updating a pod from " + sourceName);
            try {
                String answer = this.kubernetes.updatePod(id, podSchema);
                LOG.info("Updated pod result: " + answer);
            }
            catch (Exception e) {
                LOG.error("Failed to update pod from " + sourceName + ". " + e + ". " + podSchema, (Throwable)e);
            }
        } else {
            LOG.info("Creating a pod from " + sourceName);
            try {
                String answer = this.kubernetes.createPod(podSchema);
                LOG.info("Created pod result: " + answer);
            }
            catch (Exception e) {
                LOG.error("Failed to create pod from " + sourceName + ". " + e + ". " + podSchema, (Throwable)e);
            }
        }
    }

    protected boolean isRunning(PodSchema entity) {
        return entity != null;
    }

    protected boolean isRunning(ReplicationControllerSchema entity) {
        return entity != null;
    }

    protected boolean isRunning(ServiceSchema entity) {
        return entity != null;
    }
}

