/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubeapitest.kubeconfig;

import io.fabric8.kubeapitest.KubeAPITestException;
import io.fabric8.kubeapitest.binary.BinaryManager;
import io.fabric8.kubeapitest.cert.CertManager;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubeConfig {
    private static final Logger log = LoggerFactory.getLogger(KubeConfig.class);
    public static final String KUBE_API_TEST = "kubeapitest";
    private final CertManager certManager;
    private final BinaryManager binaryManager;
    private String previousCurrentContext;

    public KubeConfig(CertManager certManager, BinaryManager binaryManager) {
        this.certManager = certManager;
        this.binaryManager = binaryManager;
    }

    public void updateKubeConfig(int apiServerPort) {
        log.debug("Updating kubeconfig");
        this.previousCurrentContext = this.execWithKubectlConfigAndWait("current-context").trim();
        this.execWithKubectlConfigAndWait("set-cluster", KUBE_API_TEST, "--server=https://127.0.0.1:" + apiServerPort, "--certificate-authority=" + this.certManager.getAPIServerCertPath());
        this.execWithKubectlConfigAndWait("set-credentials", KUBE_API_TEST, "--client-certificate=" + this.certManager.getClientCertPath(), "--client-key=" + this.certManager.getClientKeyPath());
        this.execWithKubectlConfigAndWait("set-context", KUBE_API_TEST, "--cluster=kubeapitest", "--namespace=default", "--user=kubeapitest");
        this.execWithKubectlConfigAndWait("use-context", KUBE_API_TEST);
    }

    public void restoreKubeConfig() {
        log.debug("Cleanig up kubeconfig");
        this.unset("contexts.kubeapitest");
        this.unset("clusters.kubeapitest");
        this.unset("users.kubeapitest");
        this.unset("current-context");
        if (this.previousCurrentContext != null && !this.previousCurrentContext.isEmpty()) {
            this.execWithKubectlConfigAndWait("use-context", this.previousCurrentContext);
        }
    }

    private void unset(String target) {
        this.execWithKubectlConfigAndWait("unset", target);
    }

    public String generateKubeConfigYaml(int apiServerPort) {
        String string;
        block8: {
            InputStream is = KubeConfig.class.getResourceAsStream("/kubeconfig-template.yaml");
            try {
                String template = new String(is.readAllBytes(), StandardCharsets.UTF_8);
                Object[] args = new Object[]{this.certManager.getAPIServerCertPath(), apiServerPort, this.certManager.getClientCertPath(), this.certManager.getClientKeyPath()};
                MessageFormat format = new MessageFormat(template);
                string = format.format(args);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new KubeAPITestException(e);
                }
            }
            is.close();
        }
        return string;
    }

    private String execWithKubectlConfigAndWait(String ... arguments) {
        try {
            String stdout;
            ArrayList<String> args = new ArrayList<String>(arguments.length + 2);
            args.add(this.binaryManager.binaries().getKubectl().getPath());
            args.add("config");
            args.addAll(Arrays.asList(arguments));
            Process process = new ProcessBuilder(args).start();
            try (InputStream is = process.getInputStream();){
                stdout = new String(is.readAllBytes(), Charset.defaultCharset());
            }
            process.waitFor();
            return stdout;
        }
        catch (IOException e) {
            throw new KubeAPITestException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new KubeAPITestException(e);
        }
    }
}

