/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.java.generator.gradle.plugin;

import io.fabric8.java.generator.Config;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;

public abstract class JavaGeneratorPluginExtension {
    public static final String NAME = "javaGen";
    protected final ProjectLayout layout;
    private Config javaGeneratorConfig = Config.builder().build();

    public JavaGeneratorPluginExtension(ProjectLayout layout) {
        this.layout = layout;
    }

    public Config getConfig() {
        return this.javaGeneratorConfig;
    }

    public abstract RegularFileProperty getSource();

    public File getSourceOrDefault() {
        return (File)this.getSource().getAsFile().getOrElse(null);
    }

    public abstract ListProperty<String> getUrls();

    public List<String> getUrlsOrDefault() {
        return (List)this.getUrls().getOrElse(new ArrayList());
    }

    public abstract DirectoryProperty getDownloadTarget();

    public File getDownloadTargetOrDefault() {
        return (File)this.getDownloadTarget().getAsFile().getOrElse((Object)this.layout.getProjectDirectory().dir("build").dir("crds").getAsFile());
    }

    public abstract DirectoryProperty getTarget();

    public File getTargetOrDefault() {
        return (File)this.getTarget().getAsFile().getOrElse((Object)this.layout.getProjectDirectory().dir("build").dir("generated").dir("sources").getAsFile());
    }

    public Boolean getEnumUppercase() {
        return this.javaGeneratorConfig.isUppercaseEnums();
    }

    public void setEnumUppercase(Boolean isEnumUppercase) {
        this.javaGeneratorConfig = new Config(isEnumUppercase, Boolean.valueOf(this.javaGeneratorConfig.isObjectExtraAnnotations()), Boolean.valueOf(this.javaGeneratorConfig.isGeneratedAnnotations()), Boolean.valueOf(this.javaGeneratorConfig.isAlwaysPreserveUnknown()), this.javaGeneratorConfig.getPackageOverrides(), this.javaGeneratorConfig.getFilesSuffixes(), this.javaGeneratorConfig.getSerDatetimeFormat(), this.javaGeneratorConfig.getDeserDatetimeFormat(), this.javaGeneratorConfig.getExistingJavaTypes());
    }

    public Boolean getExtraAnnotations() {
        return this.javaGeneratorConfig.isObjectExtraAnnotations();
    }

    public void setExtraAnnotations(Boolean isExtraAnnotations) {
        this.javaGeneratorConfig = new Config(Boolean.valueOf(this.javaGeneratorConfig.isUppercaseEnums()), isExtraAnnotations, Boolean.valueOf(this.javaGeneratorConfig.isGeneratedAnnotations()), Boolean.valueOf(this.javaGeneratorConfig.isAlwaysPreserveUnknown()), this.javaGeneratorConfig.getPackageOverrides(), this.javaGeneratorConfig.getFilesSuffixes(), this.javaGeneratorConfig.getSerDatetimeFormat(), this.javaGeneratorConfig.getDeserDatetimeFormat(), this.javaGeneratorConfig.getExistingJavaTypes());
    }

    public Boolean getGeneratedAnnotations() {
        return this.javaGeneratorConfig.isGeneratedAnnotations();
    }

    public void setGeneratedAnnotations(Boolean isGeneratedAnnotations) {
        this.javaGeneratorConfig = new Config(Boolean.valueOf(this.javaGeneratorConfig.isUppercaseEnums()), Boolean.valueOf(this.javaGeneratorConfig.isObjectExtraAnnotations()), isGeneratedAnnotations, Boolean.valueOf(this.javaGeneratorConfig.isAlwaysPreserveUnknown()), this.javaGeneratorConfig.getPackageOverrides(), this.javaGeneratorConfig.getFilesSuffixes(), this.javaGeneratorConfig.getSerDatetimeFormat(), this.javaGeneratorConfig.getDeserDatetimeFormat(), this.javaGeneratorConfig.getExistingJavaTypes());
    }

    public Boolean getAlwaysPreserveUnknown() {
        return this.javaGeneratorConfig.isAlwaysPreserveUnknown();
    }

    public void setAlwaysPreserveUnknown(Boolean isAlwaysPreserveUnknown) {
        this.javaGeneratorConfig = new Config(Boolean.valueOf(this.javaGeneratorConfig.isUppercaseEnums()), Boolean.valueOf(this.javaGeneratorConfig.isObjectExtraAnnotations()), Boolean.valueOf(this.javaGeneratorConfig.isGeneratedAnnotations()), isAlwaysPreserveUnknown, this.javaGeneratorConfig.getPackageOverrides(), this.javaGeneratorConfig.getFilesSuffixes(), this.javaGeneratorConfig.getSerDatetimeFormat(), this.javaGeneratorConfig.getDeserDatetimeFormat(), this.javaGeneratorConfig.getExistingJavaTypes());
    }

    public Map<String, String> getPackageOverrides() {
        return this.javaGeneratorConfig.getPackageOverrides();
    }

    public void setPackageOverrides(Map<String, String> packageOverrides) {
        this.javaGeneratorConfig = new Config(Boolean.valueOf(this.javaGeneratorConfig.isUppercaseEnums()), Boolean.valueOf(this.javaGeneratorConfig.isObjectExtraAnnotations()), Boolean.valueOf(this.javaGeneratorConfig.isGeneratedAnnotations()), Boolean.valueOf(this.javaGeneratorConfig.isAlwaysPreserveUnknown()), packageOverrides, this.javaGeneratorConfig.getFilesSuffixes(), this.javaGeneratorConfig.getSerDatetimeFormat(), this.javaGeneratorConfig.getDeserDatetimeFormat(), this.javaGeneratorConfig.getExistingJavaTypes());
    }

    public List<String> getFilesSuffixes() {
        return this.javaGeneratorConfig.getFilesSuffixes();
    }

    public void setFilesSuffixes(List<String> filesSuffixes) {
        this.javaGeneratorConfig = new Config(Boolean.valueOf(this.javaGeneratorConfig.isUppercaseEnums()), Boolean.valueOf(this.javaGeneratorConfig.isObjectExtraAnnotations()), Boolean.valueOf(this.javaGeneratorConfig.isGeneratedAnnotations()), Boolean.valueOf(this.javaGeneratorConfig.isAlwaysPreserveUnknown()), this.javaGeneratorConfig.getPackageOverrides(), filesSuffixes, this.javaGeneratorConfig.getSerDatetimeFormat(), this.javaGeneratorConfig.getDeserDatetimeFormat(), this.javaGeneratorConfig.getExistingJavaTypes());
    }

    public String getSerializationDatetimeFormat() {
        return this.javaGeneratorConfig.getSerDatetimeFormat();
    }

    public void setSerializationDatetimeFormat(String serDatetimeFmt) {
        this.javaGeneratorConfig = new Config(Boolean.valueOf(this.javaGeneratorConfig.isUppercaseEnums()), Boolean.valueOf(this.javaGeneratorConfig.isObjectExtraAnnotations()), Boolean.valueOf(this.javaGeneratorConfig.isGeneratedAnnotations()), Boolean.valueOf(this.javaGeneratorConfig.isAlwaysPreserveUnknown()), this.javaGeneratorConfig.getPackageOverrides(), this.javaGeneratorConfig.getFilesSuffixes(), serDatetimeFmt, this.javaGeneratorConfig.getDeserDatetimeFormat(), this.javaGeneratorConfig.getExistingJavaTypes());
    }

    public String getDeserializationDatetimeFormat() {
        return this.javaGeneratorConfig.getDeserDatetimeFormat();
    }

    public void setDeserializationDatetimeFormat(String deserDatetimeFmt) {
        this.javaGeneratorConfig = new Config(Boolean.valueOf(this.javaGeneratorConfig.isUppercaseEnums()), Boolean.valueOf(this.javaGeneratorConfig.isObjectExtraAnnotations()), Boolean.valueOf(this.javaGeneratorConfig.isGeneratedAnnotations()), Boolean.valueOf(this.javaGeneratorConfig.isAlwaysPreserveUnknown()), this.javaGeneratorConfig.getPackageOverrides(), this.javaGeneratorConfig.getFilesSuffixes(), this.javaGeneratorConfig.getSerDatetimeFormat(), deserDatetimeFmt, this.javaGeneratorConfig.getExistingJavaTypes());
    }

    public Map<String, String> getExistingJavaTypes() {
        return this.javaGeneratorConfig.getExistingJavaTypes();
    }

    public void setExistingJavaTypes(Map<String, String> existingJavaTypes) {
        this.javaGeneratorConfig = new Config(Boolean.valueOf(this.javaGeneratorConfig.isUppercaseEnums()), Boolean.valueOf(this.javaGeneratorConfig.isObjectExtraAnnotations()), Boolean.valueOf(this.javaGeneratorConfig.isGeneratedAnnotations()), Boolean.valueOf(this.javaGeneratorConfig.isAlwaysPreserveUnknown()), this.javaGeneratorConfig.getPackageOverrides(), this.javaGeneratorConfig.getFilesSuffixes(), this.javaGeneratorConfig.getSerDatetimeFormat(), this.javaGeneratorConfig.getDeserDatetimeFormat(), existingJavaTypes);
    }
}

