/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.batch.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.batch.v1.Job;
import io.fabric8.kubernetes.api.model.batch.v1.JobFluent;

public class JobBuilder
extends JobFluent<JobBuilder>
implements VisitableBuilder<Job, JobBuilder> {
    JobFluent<?> fluent;
    Boolean validationEnabled;

    public JobBuilder() {
        this(false);
    }

    public JobBuilder(Boolean validationEnabled) {
        this(new Job(), validationEnabled);
    }

    public JobBuilder(JobFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public JobBuilder(JobFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Job(), validationEnabled);
    }

    public JobBuilder(JobFluent<?> fluent, Job instance) {
        this(fluent, instance, false);
    }

    public JobBuilder(JobFluent<?> fluent, Job instance, Boolean validationEnabled) {
        this.fluent = fluent;
        Job job = instance = instance != null ? instance : new Job();
        if (instance != null) {
            fluent.withApiVersion(instance.getApiVersion());
            fluent.withKind(instance.getKind());
            fluent.withMetadata(instance.getMetadata());
            fluent.withSpec(instance.getSpec());
            fluent.withStatus(instance.getStatus());
            fluent.withApiVersion(instance.getApiVersion());
            fluent.withKind(instance.getKind());
            fluent.withMetadata(instance.getMetadata());
            fluent.withSpec(instance.getSpec());
            fluent.withStatus(instance.getStatus());
            fluent.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public JobBuilder(Job instance) {
        this(instance, (Boolean)false);
    }

    public JobBuilder(Job instance, Boolean validationEnabled) {
        this.fluent = this;
        Job job = instance = instance != null ? instance : new Job();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withSpec(instance.getSpec());
            this.withStatus(instance.getStatus());
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withSpec(instance.getSpec());
            this.withStatus(instance.getStatus());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Job build() {
        Job buildable = new Job(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.buildMetadata(), this.fluent.buildSpec(), this.fluent.buildStatus());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

