/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.gatewayapi.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.HTTPHeaderMatch;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.HTTPHeaderMatchBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.HTTPHeaderMatchFluent;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.HTTPPathMatch;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.HTTPPathMatchBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.HTTPPathMatchFluent;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.HTTPQueryParamMatch;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.HTTPQueryParamMatchBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.HTTPQueryParamMatchFluent;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.HTTPRouteMatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class HTTPRouteMatchFluent<A extends HTTPRouteMatchFluent<A>>
extends BaseFluent<A> {
    private ArrayList<HTTPHeaderMatchBuilder> headers = new ArrayList();
    private String method;
    private HTTPPathMatchBuilder path;
    private ArrayList<HTTPQueryParamMatchBuilder> queryParams = new ArrayList();
    private Map<String, Object> additionalProperties;

    public HTTPRouteMatchFluent() {
    }

    public HTTPRouteMatchFluent(HTTPRouteMatch instance) {
        HTTPRouteMatch hTTPRouteMatch = instance = instance != null ? instance : new HTTPRouteMatch();
        if (instance != null) {
            this.withHeaders(instance.getHeaders());
            this.withMethod(instance.getMethod());
            this.withPath(instance.getPath());
            this.withQueryParams(instance.getQueryParams());
            this.withHeaders(instance.getHeaders());
            this.withMethod(instance.getMethod());
            this.withPath(instance.getPath());
            this.withQueryParams(instance.getQueryParams());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToHeaders(int index, HTTPHeaderMatch item) {
        if (this.headers == null) {
            this.headers = new ArrayList();
        }
        HTTPHeaderMatchBuilder builder = new HTTPHeaderMatchBuilder(item);
        if (index < 0 || index >= this.headers.size()) {
            this._visitables.get("headers").add(builder);
            this.headers.add(builder);
        } else {
            this._visitables.get("headers").add(index, builder);
            this.headers.add(index, builder);
        }
        return (A)this;
    }

    public A setToHeaders(int index, HTTPHeaderMatch item) {
        if (this.headers == null) {
            this.headers = new ArrayList();
        }
        HTTPHeaderMatchBuilder builder = new HTTPHeaderMatchBuilder(item);
        if (index < 0 || index >= this.headers.size()) {
            this._visitables.get("headers").add(builder);
            this.headers.add(builder);
        } else {
            this._visitables.get("headers").set(index, builder);
            this.headers.set(index, builder);
        }
        return (A)this;
    }

    public A addToHeaders(HTTPHeaderMatch ... items) {
        if (this.headers == null) {
            this.headers = new ArrayList();
        }
        for (HTTPHeaderMatch item : items) {
            HTTPHeaderMatchBuilder builder = new HTTPHeaderMatchBuilder(item);
            this._visitables.get("headers").add(builder);
            this.headers.add(builder);
        }
        return (A)this;
    }

    public A addAllToHeaders(Collection<HTTPHeaderMatch> items) {
        if (this.headers == null) {
            this.headers = new ArrayList();
        }
        for (HTTPHeaderMatch item : items) {
            HTTPHeaderMatchBuilder builder = new HTTPHeaderMatchBuilder(item);
            this._visitables.get("headers").add(builder);
            this.headers.add(builder);
        }
        return (A)this;
    }

    public A removeFromHeaders(HTTPHeaderMatch ... items) {
        if (this.headers == null) {
            return (A)this;
        }
        for (HTTPHeaderMatch item : items) {
            HTTPHeaderMatchBuilder builder = new HTTPHeaderMatchBuilder(item);
            this._visitables.get("headers").remove(builder);
            this.headers.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromHeaders(Collection<HTTPHeaderMatch> items) {
        if (this.headers == null) {
            return (A)this;
        }
        for (HTTPHeaderMatch item : items) {
            HTTPHeaderMatchBuilder builder = new HTTPHeaderMatchBuilder(item);
            this._visitables.get("headers").remove(builder);
            this.headers.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromHeaders(Predicate<HTTPHeaderMatchBuilder> predicate) {
        if (this.headers == null) {
            return (A)this;
        }
        Iterator<HTTPHeaderMatchBuilder> each = this.headers.iterator();
        Object visitables = this._visitables.get("headers");
        while (each.hasNext()) {
            HTTPHeaderMatchBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<HTTPHeaderMatch> buildHeaders() {
        return this.headers != null ? HTTPRouteMatchFluent.build(this.headers) : null;
    }

    public HTTPHeaderMatch buildHeader(int index) {
        return this.headers.get(index).build();
    }

    public HTTPHeaderMatch buildFirstHeader() {
        return this.headers.get(0).build();
    }

    public HTTPHeaderMatch buildLastHeader() {
        return this.headers.get(this.headers.size() - 1).build();
    }

    public HTTPHeaderMatch buildMatchingHeader(Predicate<HTTPHeaderMatchBuilder> predicate) {
        for (HTTPHeaderMatchBuilder item : this.headers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingHeader(Predicate<HTTPHeaderMatchBuilder> predicate) {
        for (HTTPHeaderMatchBuilder item : this.headers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withHeaders(List<HTTPHeaderMatch> headers) {
        if (this.headers != null) {
            this._visitables.get("headers").clear();
        }
        if (headers != null) {
            this.headers = new ArrayList();
            for (HTTPHeaderMatch item : headers) {
                this.addToHeaders(item);
            }
        } else {
            this.headers = null;
        }
        return (A)this;
    }

    public A withHeaders(HTTPHeaderMatch ... headers) {
        if (this.headers != null) {
            this.headers.clear();
            this._visitables.remove("headers");
        }
        if (headers != null) {
            for (HTTPHeaderMatch item : headers) {
                this.addToHeaders(item);
            }
        }
        return (A)this;
    }

    public boolean hasHeaders() {
        return this.headers != null && !this.headers.isEmpty();
    }

    public A addNewHeader(String name, String type, String value) {
        return this.addToHeaders(new HTTPHeaderMatch(name, type, value));
    }

    public HeadersNested<A> addNewHeader() {
        return new HeadersNested(-1, null);
    }

    public HeadersNested<A> addNewHeaderLike(HTTPHeaderMatch item) {
        return new HeadersNested(-1, item);
    }

    public HeadersNested<A> setNewHeaderLike(int index, HTTPHeaderMatch item) {
        return new HeadersNested(index, item);
    }

    public HeadersNested<A> editHeader(int index) {
        if (this.headers.size() <= index) {
            throw new RuntimeException("Can't edit headers. Index exceeds size.");
        }
        return this.setNewHeaderLike(index, this.buildHeader(index));
    }

    public HeadersNested<A> editFirstHeader() {
        if (this.headers.size() == 0) {
            throw new RuntimeException("Can't edit first headers. The list is empty.");
        }
        return this.setNewHeaderLike(0, this.buildHeader(0));
    }

    public HeadersNested<A> editLastHeader() {
        int index = this.headers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last headers. The list is empty.");
        }
        return this.setNewHeaderLike(index, this.buildHeader(index));
    }

    public HeadersNested<A> editMatchingHeader(Predicate<HTTPHeaderMatchBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.headers.size(); ++i) {
            if (!predicate.test(this.headers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching headers. No match found.");
        }
        return this.setNewHeaderLike(index, this.buildHeader(index));
    }

    public String getMethod() {
        return this.method;
    }

    public A withMethod(String method) {
        this.method = method;
        return (A)this;
    }

    public boolean hasMethod() {
        return this.method != null;
    }

    public HTTPPathMatch buildPath() {
        return this.path != null ? this.path.build() : null;
    }

    public A withPath(HTTPPathMatch path) {
        this._visitables.get("path").remove(this.path);
        if (path != null) {
            this.path = new HTTPPathMatchBuilder(path);
            this._visitables.get("path").add(this.path);
        } else {
            this.path = null;
            this._visitables.get("path").remove(this.path);
        }
        return (A)this;
    }

    public boolean hasPath() {
        return this.path != null;
    }

    public A withNewPath(String type, String value) {
        return this.withPath(new HTTPPathMatch(type, value));
    }

    public PathNested<A> withNewPath() {
        return new PathNested(null);
    }

    public PathNested<A> withNewPathLike(HTTPPathMatch item) {
        return new PathNested(item);
    }

    public PathNested<A> editPath() {
        return this.withNewPathLike(Optional.ofNullable(this.buildPath()).orElse(null));
    }

    public PathNested<A> editOrNewPath() {
        return this.withNewPathLike(Optional.ofNullable(this.buildPath()).orElse(new HTTPPathMatchBuilder().build()));
    }

    public PathNested<A> editOrNewPathLike(HTTPPathMatch item) {
        return this.withNewPathLike(Optional.ofNullable(this.buildPath()).orElse(item));
    }

    public A addToQueryParams(int index, HTTPQueryParamMatch item) {
        if (this.queryParams == null) {
            this.queryParams = new ArrayList();
        }
        HTTPQueryParamMatchBuilder builder = new HTTPQueryParamMatchBuilder(item);
        if (index < 0 || index >= this.queryParams.size()) {
            this._visitables.get("queryParams").add(builder);
            this.queryParams.add(builder);
        } else {
            this._visitables.get("queryParams").add(index, builder);
            this.queryParams.add(index, builder);
        }
        return (A)this;
    }

    public A setToQueryParams(int index, HTTPQueryParamMatch item) {
        if (this.queryParams == null) {
            this.queryParams = new ArrayList();
        }
        HTTPQueryParamMatchBuilder builder = new HTTPQueryParamMatchBuilder(item);
        if (index < 0 || index >= this.queryParams.size()) {
            this._visitables.get("queryParams").add(builder);
            this.queryParams.add(builder);
        } else {
            this._visitables.get("queryParams").set(index, builder);
            this.queryParams.set(index, builder);
        }
        return (A)this;
    }

    public A addToQueryParams(HTTPQueryParamMatch ... items) {
        if (this.queryParams == null) {
            this.queryParams = new ArrayList();
        }
        for (HTTPQueryParamMatch item : items) {
            HTTPQueryParamMatchBuilder builder = new HTTPQueryParamMatchBuilder(item);
            this._visitables.get("queryParams").add(builder);
            this.queryParams.add(builder);
        }
        return (A)this;
    }

    public A addAllToQueryParams(Collection<HTTPQueryParamMatch> items) {
        if (this.queryParams == null) {
            this.queryParams = new ArrayList();
        }
        for (HTTPQueryParamMatch item : items) {
            HTTPQueryParamMatchBuilder builder = new HTTPQueryParamMatchBuilder(item);
            this._visitables.get("queryParams").add(builder);
            this.queryParams.add(builder);
        }
        return (A)this;
    }

    public A removeFromQueryParams(HTTPQueryParamMatch ... items) {
        if (this.queryParams == null) {
            return (A)this;
        }
        for (HTTPQueryParamMatch item : items) {
            HTTPQueryParamMatchBuilder builder = new HTTPQueryParamMatchBuilder(item);
            this._visitables.get("queryParams").remove(builder);
            this.queryParams.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromQueryParams(Collection<HTTPQueryParamMatch> items) {
        if (this.queryParams == null) {
            return (A)this;
        }
        for (HTTPQueryParamMatch item : items) {
            HTTPQueryParamMatchBuilder builder = new HTTPQueryParamMatchBuilder(item);
            this._visitables.get("queryParams").remove(builder);
            this.queryParams.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromQueryParams(Predicate<HTTPQueryParamMatchBuilder> predicate) {
        if (this.queryParams == null) {
            return (A)this;
        }
        Iterator<HTTPQueryParamMatchBuilder> each = this.queryParams.iterator();
        Object visitables = this._visitables.get("queryParams");
        while (each.hasNext()) {
            HTTPQueryParamMatchBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<HTTPQueryParamMatch> buildQueryParams() {
        return this.queryParams != null ? HTTPRouteMatchFluent.build(this.queryParams) : null;
    }

    public HTTPQueryParamMatch buildQueryParam(int index) {
        return this.queryParams.get(index).build();
    }

    public HTTPQueryParamMatch buildFirstQueryParam() {
        return this.queryParams.get(0).build();
    }

    public HTTPQueryParamMatch buildLastQueryParam() {
        return this.queryParams.get(this.queryParams.size() - 1).build();
    }

    public HTTPQueryParamMatch buildMatchingQueryParam(Predicate<HTTPQueryParamMatchBuilder> predicate) {
        for (HTTPQueryParamMatchBuilder item : this.queryParams) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingQueryParam(Predicate<HTTPQueryParamMatchBuilder> predicate) {
        for (HTTPQueryParamMatchBuilder item : this.queryParams) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withQueryParams(List<HTTPQueryParamMatch> queryParams) {
        if (this.queryParams != null) {
            this._visitables.get("queryParams").clear();
        }
        if (queryParams != null) {
            this.queryParams = new ArrayList();
            for (HTTPQueryParamMatch item : queryParams) {
                this.addToQueryParams(item);
            }
        } else {
            this.queryParams = null;
        }
        return (A)this;
    }

    public A withQueryParams(HTTPQueryParamMatch ... queryParams) {
        if (this.queryParams != null) {
            this.queryParams.clear();
            this._visitables.remove("queryParams");
        }
        if (queryParams != null) {
            for (HTTPQueryParamMatch item : queryParams) {
                this.addToQueryParams(item);
            }
        }
        return (A)this;
    }

    public boolean hasQueryParams() {
        return this.queryParams != null && !this.queryParams.isEmpty();
    }

    public A addNewQueryParam(String name, String type, String value) {
        return this.addToQueryParams(new HTTPQueryParamMatch(name, type, value));
    }

    public QueryParamsNested<A> addNewQueryParam() {
        return new QueryParamsNested(-1, null);
    }

    public QueryParamsNested<A> addNewQueryParamLike(HTTPQueryParamMatch item) {
        return new QueryParamsNested(-1, item);
    }

    public QueryParamsNested<A> setNewQueryParamLike(int index, HTTPQueryParamMatch item) {
        return new QueryParamsNested(index, item);
    }

    public QueryParamsNested<A> editQueryParam(int index) {
        if (this.queryParams.size() <= index) {
            throw new RuntimeException("Can't edit queryParams. Index exceeds size.");
        }
        return this.setNewQueryParamLike(index, this.buildQueryParam(index));
    }

    public QueryParamsNested<A> editFirstQueryParam() {
        if (this.queryParams.size() == 0) {
            throw new RuntimeException("Can't edit first queryParams. The list is empty.");
        }
        return this.setNewQueryParamLike(0, this.buildQueryParam(0));
    }

    public QueryParamsNested<A> editLastQueryParam() {
        int index = this.queryParams.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last queryParams. The list is empty.");
        }
        return this.setNewQueryParamLike(index, this.buildQueryParam(index));
    }

    public QueryParamsNested<A> editMatchingQueryParam(Predicate<HTTPQueryParamMatchBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.queryParams.size(); ++i) {
            if (!predicate.test(this.queryParams.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching queryParams. No match found.");
        }
        return this.setNewQueryParamLike(index, this.buildQueryParam(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HTTPRouteMatchFluent that = (HTTPRouteMatchFluent)o;
        if (!Objects.equals(this.headers, that.headers)) {
            return false;
        }
        if (!Objects.equals(this.method, that.method)) {
            return false;
        }
        if (!Objects.equals(this.path, that.path)) {
            return false;
        }
        if (!Objects.equals(this.queryParams, that.queryParams)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.headers, this.method, this.path, this.queryParams, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.headers != null && !this.headers.isEmpty()) {
            sb.append("headers:");
            sb.append(this.headers + ",");
        }
        if (this.method != null) {
            sb.append("method:");
            sb.append(this.method + ",");
        }
        if (this.path != null) {
            sb.append("path:");
            sb.append(this.path + ",");
        }
        if (this.queryParams != null && !this.queryParams.isEmpty()) {
            sb.append("queryParams:");
            sb.append(this.queryParams + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class QueryParamsNested<N>
    extends HTTPQueryParamMatchFluent<QueryParamsNested<N>>
    implements Nested<N> {
        HTTPQueryParamMatchBuilder builder;
        int index;

        QueryParamsNested(int index, HTTPQueryParamMatch item) {
            this.index = index;
            this.builder = new HTTPQueryParamMatchBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)HTTPRouteMatchFluent.this.setToQueryParams(this.index, this.builder.build());
        }

        public N endQueryParam() {
            return this.and();
        }
    }

    public class PathNested<N>
    extends HTTPPathMatchFluent<PathNested<N>>
    implements Nested<N> {
        HTTPPathMatchBuilder builder;

        PathNested(HTTPPathMatch item) {
            this.builder = new HTTPPathMatchBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)HTTPRouteMatchFluent.this.withPath(this.builder.build());
        }

        public N endPath() {
            return this.and();
        }
    }

    public class HeadersNested<N>
    extends HTTPHeaderMatchFluent<HeadersNested<N>>
    implements Nested<N> {
        HTTPHeaderMatchBuilder builder;
        int index;

        HeadersNested(int index, HTTPHeaderMatch item) {
            this.index = index;
            this.builder = new HTTPHeaderMatchBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)HTTPRouteMatchFluent.this.setToHeaders(this.index, this.builder.build());
        }

        public N endHeader() {
            return this.and();
        }
    }
}

