/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.http;

import io.fabric8.kubernetes.client.RequestConfig;
import io.fabric8.kubernetes.client.http.AsyncBody;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.http.Interceptor;
import io.fabric8.kubernetes.client.http.StandardHttpClientBuilder;
import io.fabric8.kubernetes.client.http.StandardHttpRequest;
import io.fabric8.kubernetes.client.http.StandardWebSocketBuilder;
import io.fabric8.kubernetes.client.http.WebSocket;
import io.fabric8.kubernetes.client.http.WebSocketHandshakeException;
import io.fabric8.kubernetes.client.http.WebSocketResponse;
import io.fabric8.kubernetes.client.utils.ExponentialBackoffIntervalCalculator;
import io.fabric8.kubernetes.client.utils.Utils;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StandardHttpClient<C extends HttpClient, F extends HttpClient.Factory, T extends StandardHttpClientBuilder<C, F, ?>>
implements HttpClient,
Interceptor.RequestTags {
    private static final long ADDITIONAL_REQEUST_TIMEOUT = TimeUnit.SECONDS.toMillis(5L);
    private static final Logger LOG = LoggerFactory.getLogger(StandardHttpClient.class);
    protected StandardHttpClientBuilder<C, F, T> builder;

    protected StandardHttpClient(StandardHttpClientBuilder<C, F, T> builder) {
        this.builder = builder;
    }

    public abstract CompletableFuture<WebSocketResponse> buildWebSocketDirect(StandardWebSocketBuilder var1, WebSocket.Listener var2);

    public abstract CompletableFuture<HttpResponse<AsyncBody>> consumeBytesDirect(StandardHttpRequest var1, AsyncBody.Consumer<List<ByteBuffer>> var2);

    @Override
    public HttpClient.DerivedClientBuilder newBuilder() {
        return this.builder.copy(this);
    }

    public <V> CompletableFuture<HttpResponse<V>> sendAsync(HttpRequest request, Class<V> type) {
        CompletableFuture upstream = HttpResponse.SupportedResponses.from(type).sendAsync(request, this);
        CompletableFuture<HttpResponse<V>> result = new CompletableFuture<HttpResponse<V>>();
        upstream.whenComplete(StandardHttpClient.completeOrCancel(r -> {
            if (r.body() instanceof Closeable) {
                Utils.closeQuietly((Closeable)r.body());
            }
        }, result));
        return result;
    }

    @Override
    public CompletableFuture<HttpResponse<AsyncBody>> consumeBytes(HttpRequest request, AsyncBody.Consumer<List<ByteBuffer>> consumer) {
        CompletableFuture<HttpResponse<AsyncBody>> result = new CompletableFuture<HttpResponse<AsyncBody>>();
        this.retryWithExponentialBackoff(result, () -> this.consumeBytesOnce(request, consumer), request.uri(), HttpResponse::code, r -> ((AsyncBody)r.body()).cancel());
        return result;
    }

    private CompletableFuture<HttpResponse<AsyncBody>> consumeBytesOnce(HttpRequest request, AsyncBody.Consumer<List<ByteBuffer>> consumer) {
        StandardHttpRequest standardHttpRequest = (StandardHttpRequest)request;
        StandardHttpRequest.Builder copy = standardHttpRequest.newBuilder();
        for (Interceptor interceptor : this.builder.getInterceptors().values()) {
            interceptor.before(copy, standardHttpRequest, this);
            standardHttpRequest = copy.build();
        }
        StandardHttpRequest effectiveRequest = standardHttpRequest;
        for (Interceptor interceptor : this.builder.getInterceptors().values()) {
            consumer = interceptor.consumer(consumer, effectiveRequest);
        }
        AsyncBody.Consumer<List<ByteBuffer>> consumer2 = consumer;
        CompletionStage<HttpResponse<AsyncBody>> cf = this.consumeBytesDirect(effectiveRequest, consumer2);
        cf.thenAccept(response -> this.builder.getInterceptors().values().forEach(i -> i.after(effectiveRequest, (HttpResponse<?>)response, effectiveConsumer)));
        for (Interceptor interceptor : this.builder.getInterceptors().values()) {
            cf = cf.thenCompose(response -> {
                if (!HttpResponse.isSuccessful(response.code())) {
                    return interceptor.afterFailure(copy, (HttpResponse<?>)response, (Interceptor.RequestTags)this).thenCompose(b -> {
                        if (Boolean.TRUE.equals(b)) {
                            ((AsyncBody)response.body()).cancel();
                            CompletableFuture<HttpResponse<AsyncBody>> result = this.consumeBytesDirect(copy.build(), effectiveConsumer);
                            result.thenAccept(r -> this.builder.getInterceptors().values().forEach(i -> i.after(effectiveRequest, (HttpResponse<?>)r, effectiveConsumer)));
                            return result;
                        }
                        return CompletableFuture.completedFuture(response);
                    });
                }
                return CompletableFuture.completedFuture(response);
            });
        }
        return cf;
    }

    private static <V> BiConsumer<? super V, ? super Throwable> completeOrCancel(Consumer<V> cancel, CompletableFuture<V> result) {
        return (r, t) -> {
            if (t != null) {
                result.completeExceptionally((Throwable)t);
            } else if (!result.complete(r)) {
                cancel.accept(r);
            }
        };
    }

    public <V> CompletableFuture<V> orTimeout(CompletableFuture<V> future, RequestConfig requestConfig) {
        int timeout = Optional.ofNullable(requestConfig).map(RequestConfig::getRequestTimeout).orElse(0);
        if (timeout > 0) {
            CompletableFuture<Void> scheduled = Utils.schedule(Runnable::run, () -> future.completeExceptionally(new TimeoutException()), (long)timeout + ADDITIONAL_REQEUST_TIMEOUT, TimeUnit.MILLISECONDS);
            future.whenComplete((v, t) -> scheduled.cancel(true));
        }
        return future;
    }

    protected <V> void retryWithExponentialBackoff(CompletableFuture<V> result, Supplier<CompletableFuture<V>> action, URI uri, Function<V, Integer> codeExtractor, Consumer<V> cancel, ExponentialBackoffIntervalCalculator retryIntervalCalculator, RequestConfig requestConfig) {
        this.orTimeout(action.get(), requestConfig).whenComplete((response, throwable) -> {
            if (retryIntervalCalculator.shouldRetry() && !result.isDone()) {
                long retryInterval = retryIntervalCalculator.nextReconnectInterval();
                boolean retry = false;
                if (response != null) {
                    Integer code = (Integer)codeExtractor.apply(response);
                    if (code != null && code >= 500) {
                        LOG.debug("HTTP operation on url: {} should be retried as the response code was {}, retrying after {} millis", uri, code, retryInterval);
                        retry = true;
                        cancel.accept(response);
                    }
                } else {
                    if (throwable instanceof CompletionException) {
                        throwable = ((CompletionException)throwable).getCause();
                    }
                    if (throwable instanceof IOException) {
                        LOG.debug(String.format("HTTP operation on url: %s should be retried after %d millis because of IOException", uri, retryInterval), (Throwable)throwable);
                        retry = true;
                    }
                }
                if (retry) {
                    Utils.schedule(Runnable::run, () -> this.lambda$null$12(result, (Supplier)action, uri, codeExtractor, cancel, retryIntervalCalculator, requestConfig), retryInterval, TimeUnit.MILLISECONDS);
                    return;
                }
            }
            StandardHttpClient.completeOrCancel(cancel, result).accept((Object)response, (Throwable)throwable);
        });
    }

    protected <V> void retryWithExponentialBackoff(CompletableFuture<V> result, Supplier<CompletableFuture<V>> action, URI uri, Function<V, Integer> codeExtractor, Consumer<V> cancel) {
        RequestConfig requestConfig = this.getTag((Class<V>)RequestConfig.class);
        this.retryWithExponentialBackoff(result, action, uri, codeExtractor, cancel, ExponentialBackoffIntervalCalculator.from(requestConfig), requestConfig);
    }

    @Override
    public WebSocket.Builder newWebSocketBuilder() {
        return new StandardWebSocketBuilder(this);
    }

    @Override
    public HttpRequest.Builder newHttpRequestBuilder() {
        return new StandardHttpRequest.Builder();
    }

    final CompletableFuture<WebSocket> buildWebSocket(StandardWebSocketBuilder standardWebSocketBuilder, WebSocket.Listener listener) {
        CompletableFuture intermediate = new CompletableFuture();
        this.retryWithExponentialBackoff(intermediate, () -> this.buildWebSocketOnce(standardWebSocketBuilder, listener), standardWebSocketBuilder.asHttpRequest().uri(), r -> Optional.of(r.webSocketUpgradeResponse).map(HttpResponse::code).orElse(null), r -> Optional.ofNullable(r.webSocket).ifPresent(w -> w.sendClose(1000, null)));
        CompletableFuture<WebSocket> result = new CompletableFuture<WebSocket>();
        intermediate.whenComplete((r, t) -> {
            if (t != null) {
                result.completeExceptionally((Throwable)t);
            } else {
                StandardHttpClient.completeOrCancel(w -> w.sendClose(1000, null), result).accept(r.webSocket, r.throwable != null ? new WebSocketHandshakeException(r.webSocketUpgradeResponse).initCause(r.throwable) : null);
            }
        });
        return result;
    }

    private CompletableFuture<WebSocketResponse> buildWebSocketOnce(StandardWebSocketBuilder standardWebSocketBuilder, WebSocket.Listener listener) {
        StandardWebSocketBuilder copy = standardWebSocketBuilder.newBuilder();
        this.builder.getInterceptors().values().forEach(i -> i.before(copy, copy.asHttpRequest(), this));
        CompletionStage<WebSocketResponse> cf = this.buildWebSocketDirect(copy, listener);
        cf.thenAccept(response -> this.builder.getInterceptors().values().forEach(i -> i.after(response.webSocketUpgradeResponse.request(), response.webSocketUpgradeResponse, null)));
        for (Interceptor interceptor : this.builder.getInterceptors().values()) {
            cf = cf.thenCompose(response -> {
                if (response.throwable != null) {
                    return interceptor.afterFailure(copy, response.webSocketUpgradeResponse, (Interceptor.RequestTags)this).thenCompose(b -> {
                        if (Boolean.TRUE.equals(b)) {
                            return this.buildWebSocketDirect(copy, listener);
                        }
                        CompletableFuture<WebSocketResponse> result = CompletableFuture.completedFuture(response);
                        result.thenAccept(r -> this.builder.getInterceptors().values().forEach(i -> i.after(r.webSocketUpgradeResponse.request(), r.webSocketUpgradeResponse, null)));
                        return result;
                    });
                }
                return CompletableFuture.completedFuture(response);
            });
        }
        return cf;
    }

    public <V> V getTag(Class<V> type) {
        return type.cast(this.builder.tags.get(type));
    }

    private /* synthetic */ void lambda$null$12(CompletableFuture result, Supplier action, URI uri, Function codeExtractor, Consumer cancel, ExponentialBackoffIntervalCalculator retryIntervalCalculator, RequestConfig requestConfig) {
        this.retryWithExponentialBackoff(result, action, uri, codeExtractor, cancel, retryIntervalCalculator, requestConfig);
    }
}

