/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.okhttp;

import io.fabric8.kubernetes.client.http.StandardHttpClientBuilder;
import io.fabric8.kubernetes.client.okhttp.OkHttpClientFactory;
import io.fabric8.kubernetes.client.okhttp.OkHttpClientImpl;
import java.net.Proxy;
import java.util.Arrays;
import java.util.Collections;
import javax.net.ssl.X509TrustManager;
import okhttp3.Authenticator;
import okhttp3.ConnectionSpec;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.TlsVersion;
import okhttp3.logging.HttpLoggingInterceptor;

class OkHttpClientBuilderImpl
extends StandardHttpClientBuilder<OkHttpClientImpl, OkHttpClientFactory, OkHttpClientBuilderImpl> {
    private final OkHttpClient.Builder builder;

    public OkHttpClientBuilderImpl(OkHttpClientFactory clientFactory, OkHttpClient.Builder builder) {
        super(clientFactory);
        this.builder = builder;
    }

    OkHttpClient.Builder getBuilder() {
        return this.builder;
    }

    @Override
    public OkHttpClientImpl build() {
        if (this.client != null) {
            return this.derivedBuild(((OkHttpClientImpl)this.client).getOkHttpClient().newBuilder());
        }
        return this.initialBuild(this.builder);
    }

    public OkHttpClientImpl initialBuild(OkHttpClient.Builder builder) {
        if (this.connectTimeout != null) {
            builder.connectTimeout(this.connectTimeout);
        }
        if (this.sslContext != null) {
            X509TrustManager trustManager = null;
            if (this.trustManagers != null && this.trustManagers.length == 1) {
                trustManager = (X509TrustManager)this.trustManagers[0];
            }
            builder.sslSocketFactory(this.sslContext.getSocketFactory(), trustManager);
        }
        if (this.followRedirects) {
            builder.followRedirects(true).followSslRedirects(true);
        }
        if (this.proxyAddress == null) {
            builder.proxy(Proxy.NO_PROXY);
        } else {
            builder.proxy(new Proxy(Proxy.Type.HTTP, this.proxyAddress));
        }
        if (this.proxyAuthorization != null) {
            builder.proxyAuthenticator((route, response) -> response.request().newBuilder().header("Proxy-Authorization", this.proxyAuthorization).build());
        }
        if (this.tlsVersions != null) {
            ConnectionSpec spec = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).tlsVersions((TlsVersion[])Arrays.stream(this.tlsVersions).map(tls -> TlsVersion.valueOf(tls.name())).toArray(TlsVersion[]::new)).build();
            builder.connectionSpecs(Arrays.asList(spec, ConnectionSpec.CLEARTEXT));
        }
        if (this.preferHttp11) {
            builder.protocols(Collections.singletonList(Protocol.HTTP_1_1));
        }
        return this.derivedBuild(builder);
    }

    private OkHttpClientImpl derivedBuild(OkHttpClient.Builder builder) {
        if (this.readTimeout != null) {
            builder.readTimeout(this.readTimeout);
        }
        if (this.writeTimeout != null) {
            builder.writeTimeout(this.writeTimeout);
        }
        if (this.authenticatorNone) {
            builder.authenticator(Authenticator.NONE);
        }
        if (this.forStreaming) {
            builder.cache(null);
        }
        OkHttpClient client = builder.build();
        if (this.forStreaming) {
            for (Interceptor i : client.networkInterceptors()) {
                if (!(i instanceof HttpLoggingInterceptor)) continue;
                HttpLoggingInterceptor interceptor = (HttpLoggingInterceptor)i;
                interceptor.setLevel(HttpLoggingInterceptor.Level.BASIC);
            }
        }
        return new OkHttpClientImpl(client, this);
    }

    @Override
    protected OkHttpClientBuilderImpl newInstance(OkHttpClientFactory clientFactory) {
        return new OkHttpClientBuilderImpl(clientFactory, this.builder);
    }
}

