/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.client.RequestConfig;
import io.fabric8.kubernetes.client.RequestConfigFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RequestConfigFluentImpl<A extends RequestConfigFluent<A>>
extends BaseFluent<A>
implements RequestConfigFluent<A> {
    private String impersonateUsername;
    private List<String> impersonateGroups;
    private Map<String, List<String>> impersonateExtras;
    private int watchReconnectInterval;
    private int watchReconnectLimit;
    private int uploadRequestTimeout;
    private int requestRetryBackoffLimit;
    private int requestRetryBackoffInterval;
    private int requestTimeout;
    private long scaleTimeout;
    private int loggingInterval;
    private long websocketTimeout;

    public RequestConfigFluentImpl() {
    }

    public RequestConfigFluentImpl(RequestConfig instance) {
        this.withWatchReconnectLimit(instance.getWatchReconnectLimit());
        this.withWatchReconnectInterval(instance.getWatchReconnectInterval());
        this.withRequestTimeout(instance.getRequestTimeout());
        this.withScaleTimeout(instance.getScaleTimeout());
        this.withLoggingInterval(instance.getLoggingInterval());
        this.withWebsocketTimeout(instance.getWebsocketTimeout());
        this.withRequestRetryBackoffLimit(instance.getRequestRetryBackoffLimit());
        this.withRequestRetryBackoffInterval(instance.getRequestRetryBackoffInterval());
        this.withUploadRequestTimeout(instance.getUploadRequestTimeout());
        this.withImpersonateUsername(instance.getImpersonateUsername());
        this.withImpersonateGroups(instance.getImpersonateGroups());
        this.withImpersonateExtras(instance.getImpersonateExtras());
    }

    @Override
    public String getImpersonateUsername() {
        return this.impersonateUsername;
    }

    @Override
    public A withImpersonateUsername(String impersonateUsername) {
        this.impersonateUsername = impersonateUsername;
        return (A)this;
    }

    @Override
    public Boolean hasImpersonateUsername() {
        return this.impersonateUsername != null;
    }

    @Override
    public A withImpersonateGroups(String ... impersonateGroups) {
        if (this.impersonateGroups != null) {
            this.impersonateGroups.clear();
        }
        if (impersonateGroups != null) {
            for (String item : impersonateGroups) {
                this.addToImpersonateGroups(item);
            }
        }
        return (A)this;
    }

    @Override
    public String[] getImpersonateGroups() {
        int size = this.impersonateGroups != null ? this.impersonateGroups.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.impersonateGroups) {
            result[index++] = item;
        }
        return result;
    }

    @Override
    public A addToImpersonateGroups(Integer index, String item) {
        if (this.impersonateGroups == null) {
            this.impersonateGroups = new ArrayList<String>();
        }
        this.impersonateGroups.add(index, item);
        return (A)this;
    }

    @Override
    public A setToImpersonateGroups(Integer index, String item) {
        if (this.impersonateGroups == null) {
            this.impersonateGroups = new ArrayList<String>();
        }
        this.impersonateGroups.set(index, item);
        return (A)this;
    }

    @Override
    public A addToImpersonateGroups(String ... items) {
        if (this.impersonateGroups == null) {
            this.impersonateGroups = new ArrayList<String>();
        }
        for (String item : items) {
            this.impersonateGroups.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToImpersonateGroups(Collection<String> items) {
        if (this.impersonateGroups == null) {
            this.impersonateGroups = new ArrayList<String>();
        }
        for (String item : items) {
            this.impersonateGroups.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromImpersonateGroups(String ... items) {
        for (String item : items) {
            if (this.impersonateGroups == null) continue;
            this.impersonateGroups.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromImpersonateGroups(Collection<String> items) {
        for (String item : items) {
            if (this.impersonateGroups == null) continue;
            this.impersonateGroups.remove(item);
        }
        return (A)this;
    }

    @Override
    public Boolean hasImpersonateGroups() {
        return this.impersonateGroups != null && !this.impersonateGroups.isEmpty();
    }

    @Override
    public A addToImpersonateExtras(String key, List<String> value) {
        if (this.impersonateExtras == null && key != null && value != null) {
            this.impersonateExtras = new LinkedHashMap<String, List<String>>();
        }
        if (key != null && value != null) {
            this.impersonateExtras.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToImpersonateExtras(Map<String, List<String>> map) {
        if (this.impersonateExtras == null && map != null) {
            this.impersonateExtras = new LinkedHashMap<String, List<String>>();
        }
        if (map != null) {
            this.impersonateExtras.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromImpersonateExtras(String key) {
        if (this.impersonateExtras == null) {
            return (A)this;
        }
        if (key != null && this.impersonateExtras != null) {
            this.impersonateExtras.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromImpersonateExtras(Map<String, List<String>> map) {
        if (this.impersonateExtras == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.impersonateExtras == null) continue;
                this.impersonateExtras.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, List<String>> getImpersonateExtras() {
        return this.impersonateExtras;
    }

    @Override
    public <K, V> A withImpersonateExtras(Map<String, List<String>> impersonateExtras) {
        this.impersonateExtras = impersonateExtras == null ? null : new LinkedHashMap<String, List<String>>(impersonateExtras);
        return (A)this;
    }

    @Override
    public Boolean hasImpersonateExtras() {
        return this.impersonateExtras != null;
    }

    @Override
    public int getWatchReconnectInterval() {
        return this.watchReconnectInterval;
    }

    @Override
    public A withWatchReconnectInterval(int watchReconnectInterval) {
        this.watchReconnectInterval = watchReconnectInterval;
        return (A)this;
    }

    @Override
    public Boolean hasWatchReconnectInterval() {
        return true;
    }

    @Override
    public int getWatchReconnectLimit() {
        return this.watchReconnectLimit;
    }

    @Override
    public A withWatchReconnectLimit(int watchReconnectLimit) {
        this.watchReconnectLimit = watchReconnectLimit;
        return (A)this;
    }

    @Override
    public Boolean hasWatchReconnectLimit() {
        return true;
    }

    @Override
    public int getUploadRequestTimeout() {
        return this.uploadRequestTimeout;
    }

    @Override
    public A withUploadRequestTimeout(int uploadRequestTimeout) {
        this.uploadRequestTimeout = uploadRequestTimeout;
        return (A)this;
    }

    @Override
    public Boolean hasUploadRequestTimeout() {
        return true;
    }

    @Override
    public int getRequestRetryBackoffLimit() {
        return this.requestRetryBackoffLimit;
    }

    @Override
    public A withRequestRetryBackoffLimit(int requestRetryBackoffLimit) {
        this.requestRetryBackoffLimit = requestRetryBackoffLimit;
        return (A)this;
    }

    @Override
    public Boolean hasRequestRetryBackoffLimit() {
        return true;
    }

    @Override
    public int getRequestRetryBackoffInterval() {
        return this.requestRetryBackoffInterval;
    }

    @Override
    public A withRequestRetryBackoffInterval(int requestRetryBackoffInterval) {
        this.requestRetryBackoffInterval = requestRetryBackoffInterval;
        return (A)this;
    }

    @Override
    public Boolean hasRequestRetryBackoffInterval() {
        return true;
    }

    @Override
    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    @Override
    public A withRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
        return (A)this;
    }

    @Override
    public Boolean hasRequestTimeout() {
        return true;
    }

    @Override
    public long getScaleTimeout() {
        return this.scaleTimeout;
    }

    @Override
    public A withScaleTimeout(long scaleTimeout) {
        this.scaleTimeout = scaleTimeout;
        return (A)this;
    }

    @Override
    public Boolean hasScaleTimeout() {
        return true;
    }

    @Override
    public int getLoggingInterval() {
        return this.loggingInterval;
    }

    @Override
    public A withLoggingInterval(int loggingInterval) {
        this.loggingInterval = loggingInterval;
        return (A)this;
    }

    @Override
    public Boolean hasLoggingInterval() {
        return true;
    }

    @Override
    public long getWebsocketTimeout() {
        return this.websocketTimeout;
    }

    @Override
    public A withWebsocketTimeout(long websocketTimeout) {
        this.websocketTimeout = websocketTimeout;
        return (A)this;
    }

    @Override
    public Boolean hasWebsocketTimeout() {
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestConfigFluentImpl that = (RequestConfigFluentImpl)o;
        if (this.impersonateUsername != null ? !this.impersonateUsername.equals(that.impersonateUsername) : that.impersonateUsername != null) {
            return false;
        }
        if (this.impersonateGroups != null ? !this.impersonateGroups.equals(that.impersonateGroups) : that.impersonateGroups != null) {
            return false;
        }
        if (this.impersonateExtras != null ? !this.impersonateExtras.equals(that.impersonateExtras) : that.impersonateExtras != null) {
            return false;
        }
        if (this.watchReconnectInterval != that.watchReconnectInterval) {
            return false;
        }
        if (this.watchReconnectLimit != that.watchReconnectLimit) {
            return false;
        }
        if (this.uploadRequestTimeout != that.uploadRequestTimeout) {
            return false;
        }
        if (this.requestRetryBackoffLimit != that.requestRetryBackoffLimit) {
            return false;
        }
        if (this.requestRetryBackoffInterval != that.requestRetryBackoffInterval) {
            return false;
        }
        if (this.requestTimeout != that.requestTimeout) {
            return false;
        }
        if (this.scaleTimeout != that.scaleTimeout) {
            return false;
        }
        if (this.loggingInterval != that.loggingInterval) {
            return false;
        }
        return this.websocketTimeout == that.websocketTimeout;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.impersonateUsername, this.impersonateGroups, this.impersonateExtras, this.watchReconnectInterval, this.watchReconnectLimit, this.uploadRequestTimeout, this.requestRetryBackoffLimit, this.requestRetryBackoffInterval, this.requestTimeout, this.scaleTimeout, this.loggingInterval, this.websocketTimeout, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.impersonateUsername != null) {
            sb.append("impersonateUsername:");
            sb.append(this.impersonateUsername + ",");
        }
        if (this.impersonateGroups != null && !this.impersonateGroups.isEmpty()) {
            sb.append("impersonateGroups:");
            sb.append(this.impersonateGroups + ",");
        }
        if (this.impersonateExtras != null && !this.impersonateExtras.isEmpty()) {
            sb.append("impersonateExtras:");
            sb.append(this.impersonateExtras + ",");
        }
        sb.append("watchReconnectInterval:");
        sb.append(this.watchReconnectInterval + ",");
        sb.append("watchReconnectLimit:");
        sb.append(this.watchReconnectLimit + ",");
        sb.append("uploadRequestTimeout:");
        sb.append(this.uploadRequestTimeout + ",");
        sb.append("requestRetryBackoffLimit:");
        sb.append(this.requestRetryBackoffLimit + ",");
        sb.append("requestRetryBackoffInterval:");
        sb.append(this.requestRetryBackoffInterval + ",");
        sb.append("requestTimeout:");
        sb.append(this.requestTimeout + ",");
        sb.append("scaleTimeout:");
        sb.append(this.scaleTimeout + ",");
        sb.append("loggingInterval:");
        sb.append(this.loggingInterval + ",");
        sb.append("websocketTimeout:");
        sb.append(this.websocketTimeout);
        sb.append("}");
        return sb.toString();
    }
}

