/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.resource.v1alpha2;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.resource.v1alpha2.NamedResourcesResources;
import io.fabric8.kubernetes.api.model.resource.v1alpha2.NamedResourcesResourcesBuilder;
import io.fabric8.kubernetes.api.model.resource.v1alpha2.NamedResourcesResourcesFluent;
import io.fabric8.kubernetes.api.model.resource.v1alpha2.ResourceSlice;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ResourceSliceFluent<A extends ResourceSliceFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private String driverName;
    private String kind;
    private ObjectMetaBuilder metadata;
    private NamedResourcesResourcesBuilder namedResources;
    private String nodeName;
    private Map<String, Object> additionalProperties;

    public ResourceSliceFluent() {
    }

    public ResourceSliceFluent(ResourceSlice instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ResourceSlice instance) {
        ResourceSlice resourceSlice = instance = instance != null ? instance : new ResourceSlice();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withDriverName(instance.getDriverName());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withNamedResources(instance.getNamedResources());
            this.withNodeName(instance.getNodeName());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public A withDriverName(String driverName) {
        this.driverName = driverName;
        return (A)this;
    }

    public boolean hasDriverName() {
        return this.driverName != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove("metadata");
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public NamedResourcesResources buildNamedResources() {
        return this.namedResources != null ? this.namedResources.build() : null;
    }

    public A withNamedResources(NamedResourcesResources namedResources) {
        this._visitables.remove("namedResources");
        if (namedResources != null) {
            this.namedResources = new NamedResourcesResourcesBuilder(namedResources);
            this._visitables.get("namedResources").add(this.namedResources);
        } else {
            this.namedResources = null;
            this._visitables.get("namedResources").remove(this.namedResources);
        }
        return (A)this;
    }

    public boolean hasNamedResources() {
        return this.namedResources != null;
    }

    public NamedResourcesNested<A> withNewNamedResources() {
        return new NamedResourcesNested(null);
    }

    public NamedResourcesNested<A> withNewNamedResourcesLike(NamedResourcesResources item) {
        return new NamedResourcesNested(item);
    }

    public NamedResourcesNested<A> editNamedResources() {
        return this.withNewNamedResourcesLike(Optional.ofNullable(this.buildNamedResources()).orElse(null));
    }

    public NamedResourcesNested<A> editOrNewNamedResources() {
        return this.withNewNamedResourcesLike(Optional.ofNullable(this.buildNamedResources()).orElse(new NamedResourcesResourcesBuilder().build()));
    }

    public NamedResourcesNested<A> editOrNewNamedResourcesLike(NamedResourcesResources item) {
        return this.withNewNamedResourcesLike(Optional.ofNullable(this.buildNamedResources()).orElse(item));
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public A withNodeName(String nodeName) {
        this.nodeName = nodeName;
        return (A)this;
    }

    public boolean hasNodeName() {
        return this.nodeName != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceSliceFluent that = (ResourceSliceFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.driverName, that.driverName)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.namedResources, that.namedResources)) {
            return false;
        }
        if (!Objects.equals(this.nodeName, that.nodeName)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.driverName, this.kind, this.metadata, this.namedResources, this.nodeName, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.driverName != null) {
            sb.append("driverName:");
            sb.append(this.driverName + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.namedResources != null) {
            sb.append("namedResources:");
            sb.append(this.namedResources + ",");
        }
        if (this.nodeName != null) {
            sb.append("nodeName:");
            sb.append(this.nodeName + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class NamedResourcesNested<N>
    extends NamedResourcesResourcesFluent<NamedResourcesNested<N>>
    implements Nested<N> {
        NamedResourcesResourcesBuilder builder;

        NamedResourcesNested(NamedResourcesResources item) {
            this.builder = new NamedResourcesResourcesBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ResourceSliceFluent.this.withNamedResources(this.builder.build());
        }

        public N endNamedResources() {
            return this.and();
        }
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ResourceSliceFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }
}

