/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.Consumes;
import javax.ws.rs.Encoded;
import javax.ws.rs.Produces;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.util.Encode;
import org.jboss.resteasy.util.FindAnnotation;
import org.jboss.resteasy.util.NoContent;

@Provider
@Produces(value={"application/x-www-form-urlencoded"})
@Consumes(value={"application/x-www-form-urlencoded"})
@ConstrainedTo(value=RuntimeType.CLIENT)
public class FormUrlEncodedProvider
implements MessageBodyReader<MultivaluedMap>,
MessageBodyWriter<MultivaluedMap> {
    private static final Logger logger = Logger.getLogger(FormUrlEncodedProvider.class);

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return MultivaluedMap.class.equals(type);
    }

    @Override
    public MultivaluedMap readFrom(Class<MultivaluedMap> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        boolean encoded;
        if (NoContent.isContentLengthZero(httpHeaders)) {
            return new MultivaluedMapImpl();
        }
        boolean bl = encoded = FindAnnotation.findAnnotation(annotations, Encoded.class) != null;
        if (encoded) {
            return FormUrlEncodedProvider.parseForm(entityStream);
        }
        return Encode.decode(FormUrlEncodedProvider.parseForm(entityStream));
    }

    public static MultivaluedMap<String, String> parseForm(InputStream entityStream) throws IOException {
        String[] params;
        char[] buffer = new char[100];
        StringBuffer buf = new StringBuffer();
        BufferedReader reader = new BufferedReader(new InputStreamReader(entityStream));
        int wasRead = 0;
        do {
            if ((wasRead = reader.read(buffer, 0, 100)) <= 0) continue;
            buf.append(buffer, 0, wasRead);
        } while (wasRead > -1);
        String form = buf.toString();
        MultivaluedMapImpl<String, String> formData = new MultivaluedMapImpl<String, String>();
        if ("".equals(form)) {
            return formData;
        }
        for (String param : params = form.split("&")) {
            if (param.indexOf(61) >= 0) {
                String[] nv = param.split("=");
                String val = nv.length > 1 ? nv[1] : "";
                formData.add(nv[0], val);
                continue;
            }
            formData.add(param, "");
        }
        return formData;
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return MultivaluedMap.class.isAssignableFrom(type);
    }

    @Override
    public long getSize(MultivaluedMap stringStringMultivaluedMap, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    @Override
    public void writeTo(MultivaluedMap data, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        MultivaluedMap formData = data;
        boolean encoded = FindAnnotation.findAnnotation(annotations, Encoded.class) != null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baos, "UTF-8");
        boolean first = true;
        for (Map.Entry entry : formData.entrySet()) {
            String encodedName = (String)entry.getKey();
            if (!encoded) {
                encodedName = URLEncoder.encode((String)entry.getKey(), "UTF-8");
            }
            for (String value : (List)entry.getValue()) {
                if (first) {
                    first = false;
                } else {
                    writer.write("&");
                }
                if (!encoded) {
                    value = URLEncoder.encode(value, "UTF-8");
                }
                writer.write(encodedName);
                writer.write("=");
                writer.write(value);
            }
            writer.flush();
        }
        byte[] bytes = baos.toByteArray();
        entityStream.write(bytes);
    }
}

