/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.cache;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.jaxrs.cache.BrowserCache;
import org.jboss.resteasy.util.DateUtil;
import org.jboss.resteasy.util.ReadFromStream;

public class CacheInterceptor
implements ClientRequestFilter,
ClientResponseFilter {
    protected BrowserCache cache;

    public CacheInterceptor(BrowserCache cache) {
        this.cache = cache;
    }

    @Override
    public void filter(ClientRequestContext request) throws IOException {
        if (!request.getMethod().equalsIgnoreCase("GET")) {
            return;
        }
        try {
            BrowserCache.Entry entry = this.getEntry(request);
            if (entry == null) {
                return;
            }
            if (entry.expired()) {
                BrowserCache.Header[] headers;
                this.cache.remove(request.getUri().toString(), entry.getMediaType());
                for (BrowserCache.Header header : headers = entry.getValidationHeaders()) {
                    request.getHeaders().putSingle(header.getName(), header.getValue());
                }
                request.setProperty("expired.cache.entry", entry);
                return;
            }
            request.setProperty("cached", "cached");
            request.abortWith(this.cachedResponse(entry));
        }
        catch (IOException io) {
            throw io;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Response cachedResponse(BrowserCache.Entry entry) {
        ByteArrayInputStream bais = new ByteArrayInputStream(entry.getCached());
        Response.ResponseBuilder builder = Response.ok().entity(bais);
        for (Map.Entry header : entry.getHeaders().entrySet()) {
            for (String val : (List)header.getValue()) {
                builder.header((String)header.getKey(), val);
            }
        }
        return builder.build();
    }

    @Override
    public void filter(ClientRequestContext request, ClientResponseContext response) throws IOException {
        if (!request.getMethod().equalsIgnoreCase("GET") || request.getProperty("cached") != null) {
            return;
        }
        if (response.getStatus() == 304) {
            BrowserCache.Entry entry = (BrowserCache.Entry)request.getProperty("expired.cache.entry");
            this.updateOnNotModified(request, entry, response);
            return;
        }
        if (response.getStatus() == 200) {
            this.cache(request, response);
        }
    }

    private void useCacheEntry(ClientResponseContext response, BrowserCache.Entry entry) {
        ByteArrayInputStream bais = new ByteArrayInputStream(entry.getCached());
        response.setEntityStream(bais);
        response.setStatus(200);
        for (Map.Entry header : entry.getHeaders().entrySet()) {
            response.getHeaders().remove(header.getKey());
            for (String val : (List)header.getValue()) {
                response.getHeaders().add((String)header.getKey(), val);
            }
        }
    }

    private void cache(ClientRequestContext request, ClientResponseContext response) throws IOException {
        if (response.getStatus() != 200) {
            return;
        }
        this.cacheIfPossible(request, response);
    }

    public void updateOnNotModified(ClientRequestContext request, BrowserCache.Entry old, ClientResponseContext response) {
        old.getHeaders().remove("Cache-Control");
        old.getHeaders().remove("Expires");
        old.getHeaders().remove("Last-Modified");
        String cc = response.getHeaderString("Cache-Control");
        String exp = response.getHeaderString("Expires");
        int expires = -1;
        if (cc != null) {
            CacheControl cacheControl = CacheControl.valueOf(cc);
            if (cacheControl.isNoCache()) {
                this.useCacheEntry(response, old);
                return;
            }
            expires = cacheControl.getMaxAge();
        } else if (exp != null) {
            Date date = DateUtil.parseDate(exp);
            expires = (int)((date.getTime() - System.currentTimeMillis()) / 1000L);
        }
        if (cc != null) {
            old.getHeaders().putSingle("Cache-Control", cc);
        }
        if (exp != null) {
            old.getHeaders().putSingle("Cache-Control", exp);
        }
        String lastModified = response.getHeaderString("Last-Modified");
        String etag = response.getHeaderString("ETag");
        if (etag == null) {
            etag = old.getHeaders().getFirst("ETag");
        } else {
            old.getHeaders().putSingle("ETag", etag);
        }
        if (lastModified != null) {
            old.getHeaders().putSingle("Last-Modified", lastModified);
        }
        if (etag == null && lastModified == null && cc == null && exp == null) {
            this.useCacheEntry(response, old);
            return;
        }
        BrowserCache.Entry entry = this.cache.put(request.getUri().toString(), old.getMediaType(), old.getHeaders(), old.getCached(), expires, etag, lastModified);
        this.useCacheEntry(response, entry);
    }

    public void cacheIfPossible(ClientRequestContext request, ClientResponseContext response) throws IOException {
        String cc = response.getHeaderString("Cache-Control");
        String exp = response.getHeaderString("Expires");
        int expires = -1;
        if (cc != null) {
            CacheControl cacheControl = CacheControl.valueOf(cc);
            if (cacheControl.isNoCache()) {
                return;
            }
            expires = cacheControl.getMaxAge();
        } else if (exp != null) {
            Date date = DateUtil.parseDate(exp);
            expires = (int)((date.getTime() - System.currentTimeMillis()) / 1000L);
        }
        String lastModified = response.getHeaderString("Last-Modified");
        String etag = response.getHeaderString("ETag");
        String contentType = response.getHeaderString("Content-Type");
        byte[] cached = ReadFromStream.readFromStream(1024, response.getEntityStream());
        MediaType mediaType = MediaType.valueOf(contentType);
        BrowserCache.Entry entry = this.cache.put(request.getUri().toString(), mediaType, response.getHeaders(), cached, expires, etag, lastModified);
        response.setEntityStream(new ByteArrayInputStream(cached));
    }

    protected BrowserCache.Entry getEntry(ClientRequestContext request) throws Exception {
        String uri = request.getUri().toString();
        List<MediaType> acceptableMediaTypes = request.getAcceptableMediaTypes();
        BrowserCache.Entry entry = null;
        if (acceptableMediaTypes.size() > 0) {
            for (MediaType accept : acceptableMediaTypes) {
                entry = this.cache.get(uri, accept);
                if (entry == null) continue;
                return entry;
            }
        } else {
            return this.cache.getAny(uri);
        }
        return null;
    }
}

