/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.log;

import java.io.PrintStream;
import java.util.concurrent.atomic.AtomicInteger;

class SharedPrintStream {
    private PrintStream printStream;
    private AtomicInteger numUsers;

    SharedPrintStream(PrintStream ps) {
        this.printStream = ps;
        this.numUsers = new AtomicInteger(1);
    }

    PrintStream getPrintStream() {
        return this.printStream;
    }

    void allocate() {
        this.numUsers.incrementAndGet();
    }

    boolean close() {
        int nrUsers = this.numUsers.decrementAndGet();
        if (nrUsers == 0 && this.printStream != System.out) {
            this.printStream.close();
            return true;
        }
        return false;
    }
}

